/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.aspsp.profile.domain.common.CommonAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.service.ConfirmationExpirationService;
import de.adorsys.psd2.consent.service.authorisation.AuthService;
import de.adorsys.psd2.consent.service.mapper.AuthorisationMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CmsAuthorisationService<T extends Authorisable>
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(CmsAuthorisationService.class);
    protected final CmsPsuService cmsPsuService;
    protected final PsuDataMapper psuDataMapper;
    protected final AspspProfileService aspspProfileService;
    protected final AuthorisationMapper authorisationMapper;
    protected final AuthorisationRepository authorisationRepository;
    protected final ConfirmationExpirationService<T> confirmationExpirationService;

    @Override
    public List<AuthorisationEntity> getAuthorisationsByParentId(String parentId) {
        return this.authorisationRepository.findAllByParentExternalIdAndAuthorisationType(parentId, this.getAuthorisationType());
    }

    @Override
    public Optional<AuthorisationEntity> getAuthorisationById(String authorisationId) {
        return this.authorisationRepository.findByExternalIdAndAuthorisationType(authorisationId, this.getAuthorisationType());
    }

    @Override
    public AuthorisationEntity saveAuthorisation(CreateAuthorisationRequest request, Authorisable authorisationParent) {
        List<PsuData> psuDataList = authorisationParent.getPsuDataList();
        Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(this.psuDataMapper.mapToPsuData(request.getPsuData(), authorisationParent.getInstanceId()), psuDataList);
        psuDataOptional.ifPresent(psuData -> authorisationParent.setPsuDataList(this.cmsPsuService.enrichPsuData((PsuData)psuData, psuDataList)));
        authorisationParent.setPsuDataList(psuDataList);
        CommonAspspProfileSetting commonAspspProfileSetting = this.aspspProfileService.getAspspSettings(authorisationParent.getInstanceId()).getCommon();
        AuthorisationEntity entity = this.authorisationMapper.prepareAuthorisationEntity(authorisationParent, request, psuDataOptional, this.getAuthorisationType(), commonAspspProfileSetting.getRedirectUrlExpirationTimeMs(), commonAspspProfileSetting.getAuthorisationExpirationTimeMs());
        return (AuthorisationEntity)this.authorisationRepository.save(entity);
    }

    @Override
    public AuthorisationEntity doUpdateAuthorisation(AuthorisationEntity authorisationEntity, UpdateAuthorisationRequest updateAuthorisationRequest) {
        PsuData psuRequest = this.psuDataMapper.mapToPsuData(updateAuthorisationRequest.getPsuData(), authorisationEntity.getInstanceId());
        if (ScaStatus.RECEIVED == authorisationEntity.getScaStatus()) {
            if (!this.cmsPsuService.isPsuDataRequestCorrect(psuRequest, authorisationEntity.getPsuData())) {
                log.info("Authorisation ID: [{}], SCA status: [{}]. Update authorisation failed, because psu data request does not match stored psu data", (Object)authorisationEntity.getExternalId(), (Object)authorisationEntity.getScaStatus().getValue());
                return authorisationEntity;
            }
            Optional<Authorisable> aisConsentOptional = this.getAuthorisationParent(authorisationEntity.getParentExternalId());
            if (aisConsentOptional.isEmpty()) {
                log.info("Authorisation ID: [{}], Parent ID: [{}]. Update authorisation failed, couldn't find parent by ID from the authorisation", (Object)authorisationEntity.getExternalId(), (Object)authorisationEntity.getParentExternalId());
                return authorisationEntity;
            }
            Authorisable authorisationParent = aisConsentOptional.get();
            Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(psuRequest, authorisationParent.getPsuDataList());
            if (psuDataOptional.isPresent()) {
                PsuData psuData = psuDataOptional.get();
                authorisationParent.setPsuDataList(this.cmsPsuService.enrichPsuData(psuData, authorisationParent.getPsuDataList()));
                authorisationEntity.setPsuData(psuData);
                this.updateAuthorisable(authorisationParent);
            }
        } else {
            boolean isPsuCorrect;
            boolean bl = isPsuCorrect = Objects.nonNull(authorisationEntity.getPsuData()) && Objects.nonNull(psuRequest) && authorisationEntity.getPsuData().contentEquals(psuRequest);
            if (!isPsuCorrect) {
                log.info("Authorisation ID: [{}], SCA status: [{}]. Update authorisation failed, because PSU data request does not match stored PSU data", (Object)authorisationEntity.getExternalId(), (Object)authorisationEntity.getScaStatus().getValue());
                return authorisationEntity;
            }
        }
        if (ScaStatus.SCAMETHODSELECTED == updateAuthorisationRequest.getScaStatus()) {
            authorisationEntity.setAuthenticationMethodId(updateAuthorisationRequest.getAuthenticationMethodId());
        }
        authorisationEntity.setScaStatus(updateAuthorisationRequest.getScaStatus());
        return (AuthorisationEntity)this.authorisationRepository.save(authorisationEntity);
    }

    @Override
    public Authorisable checkAndUpdateOnConfirmationExpiration(Authorisable authorisable) {
        return this.confirmationExpirationService.checkAndUpdateOnConfirmationExpiration(this.castToParent(authorisable));
    }

    @Override
    public boolean isConfirmationExpired(Authorisable authorisable) {
        return this.confirmationExpirationService.isConfirmationExpired(this.castToParent(authorisable));
    }

    @Override
    public Authorisable updateOnConfirmationExpiration(Authorisable authorisable) {
        return this.confirmationExpirationService.updateOnConfirmationExpiration(this.castToParent(authorisable));
    }

    protected void updateAuthorisable(Object authorisable) {
    }

    abstract AuthorisationType getAuthorisationType();

    abstract T castToParent(Authorisable var1);

    @ConstructorProperties(value={"cmsPsuService", "psuDataMapper", "aspspProfileService", "authorisationMapper", "authorisationRepository", "confirmationExpirationService"})
    public CmsAuthorisationService(CmsPsuService cmsPsuService, PsuDataMapper psuDataMapper, AspspProfileService aspspProfileService, AuthorisationMapper authorisationMapper, AuthorisationRepository authorisationRepository, ConfirmationExpirationService<T> confirmationExpirationService) {
        this.cmsPsuService = cmsPsuService;
        this.psuDataMapper = psuDataMapper;
        this.aspspProfileService = aspspProfileService;
        this.authorisationMapper = authorisationMapper;
        this.authorisationRepository = authorisationRepository;
        this.confirmationExpirationService = confirmationExpirationService;
    }
}

