/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.service.PisCommonPaymentConfirmationExpirationService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PisCommonPaymentConfirmationExpirationServiceImpl
implements PisCommonPaymentConfirmationExpirationService {
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final AuthorisationRepository authorisationRepository;
    private final AspspProfileService aspspProfileService;

    @Override
    @Transactional
    public List<PisCommonPaymentData> updatePaymentDataListOnConfirmationExpiration(List<PisCommonPaymentData> pisCommonPaymentDataList) {
        return IterableUtils.toList((Iterable)this.pisCommonPaymentDataRepository.saveAll(this.obsoletePaymentDataList(pisCommonPaymentDataList)));
    }

    private void failAuthorisation(AuthorisationEntity authorisation) {
        authorisation.setScaStatus(ScaStatus.FAILED);
        authorisation.setRedirectUrlExpirationTimestamp(OffsetDateTime.now());
    }

    private List<PisCommonPaymentData> obsoletePaymentDataList(List<PisCommonPaymentData> pisCommonPaymentDataList) {
        return pisCommonPaymentDataList.stream().map(this::obsoletePaymentData).collect(Collectors.toList());
    }

    private PisCommonPaymentData obsoletePaymentData(PisCommonPaymentData pisCommonPaymentData) {
        pisCommonPaymentData.setTransactionStatus(TransactionStatus.RJCT);
        String paymentId = pisCommonPaymentData.getExternalId();
        List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationTypeIn(paymentId, EnumSet.of(AuthorisationType.PIS_CREATION, AuthorisationType.PIS_CANCELLATION));
        authorisations.forEach(auth -> auth.setScaStatus(ScaStatus.FAILED));
        this.authorisationRepository.saveAll(authorisations);
        return pisCommonPaymentData;
    }

    @Override
    @Transactional
    public PisCommonPaymentData checkAndUpdateOnConfirmationExpiration(PisCommonPaymentData pisCommonPaymentData) {
        if (this.isConfirmationExpired(pisCommonPaymentData)) {
            return this.updateOnConfirmationExpiration(pisCommonPaymentData);
        }
        return pisCommonPaymentData;
    }

    @Override
    public boolean isConfirmationExpired(PisCommonPaymentData pisCommonPaymentData) {
        if (pisCommonPaymentData == null) {
            return false;
        }
        long expirationPeriodMs = this.aspspProfileService.getAspspSettings(pisCommonPaymentData.getInstanceId()).getPis().getNotConfirmedPaymentExpirationTimeMs();
        return pisCommonPaymentData.isConfirmationExpired(expirationPeriodMs);
    }

    @Override
    @Transactional
    public PisCommonPaymentData updateOnConfirmationExpiration(PisCommonPaymentData pisCommonPaymentData) {
        pisCommonPaymentData.setTransactionStatus(TransactionStatus.RJCT);
        String paymentId = pisCommonPaymentData.getExternalId();
        List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationTypeIn(paymentId, EnumSet.of(AuthorisationType.PIS_CREATION, AuthorisationType.PIS_CANCELLATION));
        authorisations.forEach(this::failAuthorisation);
        this.authorisationRepository.saveAll(authorisations);
        return (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(pisCommonPaymentData);
    }

    @ConstructorProperties(value={"pisCommonPaymentDataRepository", "authorisationRepository", "aspspProfileService"})
    public PisCommonPaymentConfirmationExpirationServiceImpl(PisCommonPaymentDataRepository pisCommonPaymentDataRepository, AuthorisationRepository authorisationRepository, AspspProfileService aspspProfileService) {
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.authorisationRepository = authorisationRepository;
        this.aspspProfileService = aspspProfileService;
    }
}

