/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.domain.account.AisConsentUsage;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.AisConsentUsageRepository;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AisConsentUsageService {
    private final AisConsentUsageRepository aisConsentUsageRepository;

    @Transactional
    public void incrementUsage(ConsentEntity consent, AisConsentActionRequest request) {
        AisConsentUsage aisConsentUsage = this.getUsage(consent, request.getRequestUri());
        int usage = aisConsentUsage.getUsage();
        aisConsentUsage.setUsage(++usage);
        aisConsentUsage.setResourceId(request.getResourceId());
        aisConsentUsage.setTransactionId(request.getTransactionId());
        this.aisConsentUsageRepository.save(aisConsentUsage);
    }

    @Transactional
    public void resetUsage(ConsentEntity consent) {
        List<AisConsentUsage> aisConsentUsageList = this.aisConsentUsageRepository.findReadByConsentAndUsageDate(consent, LocalDate.now());
        aisConsentUsageList.forEach(acu -> acu.setUsage(0));
        this.aisConsentUsageRepository.saveAll(aisConsentUsageList);
    }

    @Transactional
    public Map<String, Integer> getUsageCounterMap(ConsentEntity consent) {
        return this.aisConsentUsageRepository.findReadByConsentAndUsageDate(consent, LocalDate.now()).stream().collect(Collectors.toMap(AisConsentUsage::getRequestUri, u -> Math.max(consent.getFrequencyPerDay() - u.getUsage(), 0)));
    }

    private AisConsentUsage getUsage(ConsentEntity consent, String requestUri) {
        return this.aisConsentUsageRepository.findWriteByConsentAndUsageDateAndRequestUri(consent, LocalDate.now(), requestUri).orElseGet(() -> {
            AisConsentUsage usage = new AisConsentUsage(consent, requestUri);
            consent.addUsage(usage);
            return usage;
        });
    }

    @ConstructorProperties(value={"aisConsentUsageRepository"})
    public AisConsentUsageService(AisConsentUsageRepository aisConsentUsageRepository) {
        this.aisConsentUsageRepository = aisConsentUsageRepository;
    }
}

