/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.service.AisConsentService;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.core.data.AccountAccess;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AisConsentServiceInternalEncrypted
implements AisConsentServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(AisConsentServiceInternalEncrypted.class);
    private final SecurityDataService securityDataService;
    private final AisConsentService aisConsentService;

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<CmsResponse.VoidResponse> checkConsentAndSaveActionLog(AisConsentActionRequest encryptedRequest) throws WrongChecksumException {
        String consentId = encryptedRequest.getConsentId();
        Optional<String> decryptedConsentId = this.securityDataService.decryptId(consentId);
        if (decryptedConsentId.isEmpty()) {
            log.info("Encrypted Consent ID: [{}]. Check consent and save action log failed, couldn't decrypt consent id", (Object)consentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        AisConsentActionRequest decryptedRequest = new AisConsentActionRequest(encryptedRequest.getTppId(), decryptedConsentId.get(), encryptedRequest.getActionStatus(), encryptedRequest.getRequestUri(), encryptedRequest.isUpdateUsage(), encryptedRequest.getResourceId(), encryptedRequest.getTransactionId());
        return this.aisConsentService.checkConsentAndSaveActionLog(decryptedRequest);
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<CmsConsent> updateAspspAccountAccess(String encryptedConsentId, AccountAccess request) throws WrongChecksumException {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (decryptIdOptional.isEmpty()) {
            log.info("Encrypted Consent ID: [{}]. Update aspsp account access with response failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentService.updateAspspAccountAccess(decryptIdOptional.get(), request);
    }

    @ConstructorProperties(value={"securityDataService", "aisConsentService"})
    public AisConsentServiceInternalEncrypted(SecurityDataService securityDataService, AisConsentService aisConsentService) {
        this.securityDataService = securityDataService;
        this.aisConsentService = aisConsentService;
    }
}

