/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.impl;

import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.AisConsentVerifyingRepository;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingFactory;
import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingService;
import de.adorsys.psd2.core.data.Consent;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AisConsentRepositoryImpl
implements AisConsentVerifyingRepository {
    private static final Logger log = LoggerFactory.getLogger(AisConsentRepositoryImpl.class);
    private final ConsentJpaRepository aisConsentRepository;
    private final ChecksumCalculatingFactory calculatingFactory;
    private final AisConsentMapper aisConsentMapper;
    private final AuthorisationRepository authorisationRepository;

    @Override
    @Transactional(rollbackFor={WrongChecksumException.class})
    public ConsentEntity verifyAndSave(ConsentEntity entity) throws WrongChecksumException {
        return this.verifyAndSaveInternal(entity);
    }

    @Override
    @Transactional(rollbackFor={WrongChecksumException.class})
    public ConsentEntity verifyAndUpdate(ConsentEntity entity) throws WrongChecksumException {
        return this.verifyAndUpdateInternal(entity);
    }

    @Override
    @Transactional(rollbackFor={WrongChecksumException.class})
    public List<ConsentEntity> verifyAndSaveAll(List<ConsentEntity> consents) throws WrongChecksumException {
        ArrayList<ConsentEntity> consentList = new ArrayList<ConsentEntity>();
        for (ConsentEntity entity : consents) {
            ConsentEntity consent = this.verifyAndSaveInternal(entity);
            consentList.add(consent);
        }
        return consentList;
    }

    @Override
    @Transactional
    public Optional<ConsentEntity> getActualAisConsent(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).filter(c -> !c.getConsentStatus().isFinalisedStatus());
    }

    private ConsentEntity verifyAndSaveInternal(ConsentEntity consentEntity) throws WrongChecksumException {
        Optional<ChecksumCalculatingService> calculatingServiceOptional = this.calculatingFactory.getServiceByChecksum(consentEntity.getChecksum(), ConsentType.AIS);
        if (calculatingServiceOptional.isPresent()) {
            ChecksumCalculatingService calculatingService = calculatingServiceOptional.get();
            if (!this.isAisConsentChecksumCorrect(consentEntity, calculatingService)) {
                throw new WrongChecksumException();
            }
            if (this.wasStatusSwitchedToValid(consentEntity)) {
                byte[] newChecksum = calculatingService.calculateChecksumForConsent((Consent<?>)this.mapToAisConsent(consentEntity));
                consentEntity.setChecksum(newChecksum);
            }
        }
        return (ConsentEntity)this.aisConsentRepository.save(consentEntity);
    }

    private ConsentEntity verifyAndUpdateInternal(ConsentEntity entity) throws WrongChecksumException {
        Optional<ChecksumCalculatingService> calculatingServiceOptional = this.calculatingFactory.getServiceByChecksum(entity.getChecksum(), ConsentType.AIS);
        if (calculatingServiceOptional.isPresent()) {
            ChecksumCalculatingService calculatingService = calculatingServiceOptional.get();
            if (!this.isAisConsentChecksumCorrect(entity, calculatingService)) {
                throw new WrongChecksumException();
            }
            if (entity.getConsentStatus() == ConsentStatus.VALID) {
                byte[] newChecksum = calculatingService.calculateChecksumForConsent((Consent<?>)this.mapToAisConsent(entity));
                entity.setChecksum(newChecksum);
            }
        }
        return (ConsentEntity)this.aisConsentRepository.save(entity);
    }

    private boolean isAisConsentChecksumCorrect(ConsentEntity entity, ChecksumCalculatingService calculatingService) {
        byte[] checksumFromDb = entity.getChecksum();
        if (checksumFromDb != null && this.wasStatusHoldBefore(entity) && !calculatingService.verifyConsentWithChecksum((Consent<?>)this.mapToAisConsent(entity), checksumFromDb)) {
            log.warn("AIS consent checksum verification failed! AIS consent ID: [{}]. Contact ASPSP for details.", (Object)entity.getExternalId());
            return false;
        }
        return true;
    }

    private boolean wasStatusSwitchedToValid(ConsentEntity entity) {
        return entity.getConsentStatus() == ConsentStatus.VALID && EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.PARTIALLY_AUTHORISED).contains(this.getPreviousConsentStatus(entity));
    }

    private boolean wasStatusHoldBefore(ConsentEntity entity) {
        return this.getPreviousConsentStatus(entity) == ConsentStatus.VALID || this.isFinalisedStatus(entity);
    }

    private AisConsent mapToAisConsent(ConsentEntity entity) {
        List<AuthorisationEntity> authorisationEntityList = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationType(entity.getExternalId(), AuthorisationType.AIS);
        return this.aisConsentMapper.mapToAisConsent(entity, authorisationEntityList);
    }

    private ConsentStatus getPreviousConsentStatus(ConsentEntity entity) {
        Optional<ConsentEntity> optionalConsentStatus = this.aisConsentRepository.findByExternalId(entity.getExternalId());
        return optionalConsentStatus.map(ConsentEntity::getConsentStatus).orElse(null);
    }

    private boolean isFinalisedStatus(ConsentEntity entity) {
        ConsentStatus previousConsentStatus = this.getPreviousConsentStatus(entity);
        return previousConsentStatus != null && previousConsentStatus.isFinalisedStatus();
    }

    @ConstructorProperties(value={"aisConsentRepository", "calculatingFactory", "aisConsentMapper", "authorisationRepository"})
    public AisConsentRepositoryImpl(ConsentJpaRepository aisConsentRepository, ChecksumCalculatingFactory calculatingFactory, AisConsentMapper aisConsentMapper, AuthorisationRepository authorisationRepository) {
        this.aisConsentRepository = aisConsentRepository;
        this.calculatingFactory = calculatingFactory;
        this.aisConsentMapper = aisConsentMapper;
        this.authorisationRepository = authorisationRepository;
    }
}

