/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.account;

import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import java.time.LocalDate;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity(name="consent_usage")
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"consent_id", "request_uri", "usage_date"})})
public class AisConsentUsage {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="consent_usage_generator")
    @SequenceGenerator(name="consent_usage_generator", sequenceName="consent_usage_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="consent_id", nullable=false)
    private ConsentEntity consent;
    @Column(name="request_uri", nullable=false)
    private String requestUri;
    @Column(name="resource_id")
    private String resourceId;
    @Column(name="transaction_id")
    private String transactionId;
    @Column(name="usage_date", nullable=false)
    private LocalDate usageDate;
    @Column(name="usage_amount", nullable=false)
    private int usage;
    @Version
    @Column(name="version")
    private long version;

    public AisConsentUsage(ConsentEntity consent, String requestUri) {
        this.usageDate = LocalDate.now();
        this.consent = consent;
        this.requestUri = requestUri;
    }

    public Long getId() {
        return this.id;
    }

    public ConsentEntity getConsent() {
        return this.consent;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public LocalDate getUsageDate() {
        return this.usageDate;
    }

    public int getUsage() {
        return this.usage;
    }

    public long getVersion() {
        return this.version;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setConsent(ConsentEntity consent) {
        this.consent = consent;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setUsageDate(LocalDate usageDate) {
        this.usageDate = usageDate;
    }

    public void setUsage(int usage) {
        this.usage = usage;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisConsentUsage)) {
            return false;
        }
        AisConsentUsage other = (AisConsentUsage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        ConsentEntity this$consent = this.getConsent();
        ConsentEntity other$consent = other.getConsent();
        if (this$consent == null ? other$consent != null : !((Object)this$consent).equals(other$consent)) {
            return false;
        }
        String this$requestUri = this.getRequestUri();
        String other$requestUri = other.getRequestUri();
        if (this$requestUri == null ? other$requestUri != null : !this$requestUri.equals(other$requestUri)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        LocalDate this$usageDate = this.getUsageDate();
        LocalDate other$usageDate = other.getUsageDate();
        if (this$usageDate == null ? other$usageDate != null : !((Object)this$usageDate).equals(other$usageDate)) {
            return false;
        }
        if (this.getUsage() != other.getUsage()) {
            return false;
        }
        return this.getVersion() == other.getVersion();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AisConsentUsage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        ConsentEntity $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : ((Object)$consent).hashCode());
        String $requestUri = this.getRequestUri();
        result = result * 59 + ($requestUri == null ? 43 : $requestUri.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        LocalDate $usageDate = this.getUsageDate();
        result = result * 59 + ($usageDate == null ? 43 : ((Object)$usageDate).hashCode());
        result = result * 59 + this.getUsage();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        return result;
    }

    public String toString() {
        return "AisConsentUsage(id=" + this.getId() + ", consent=" + this.getConsent() + ", requestUri=" + this.getRequestUri() + ", resourceId=" + this.getResourceId() + ", transactionId=" + this.getTransactionId() + ", usageDate=" + this.getUsageDate() + ", usage=" + this.getUsage() + ", version=" + this.getVersion() + ")";
    }

    public AisConsentUsage() {
    }
}

