/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.sha;

import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingService;
import de.adorsys.psd2.consent.service.sha.NoProcessingChecksumService;
import de.adorsys.psd2.consent.service.sha.v3.AisChecksumCalculatingServiceV3;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChecksumCalculatingFactory {
    private MultiKeyMap<MultiKey, ChecksumCalculatingService> services = new MultiKeyMap();
    @Autowired
    private AisChecksumCalculatingServiceV3 aisV3;
    @Autowired
    private NoProcessingChecksumService noProcessingService;

    @PostConstruct
    public void init() {
        this.services.put(new MultiKey((Object)"001", (Object)ConsentType.AIS), (Object)this.noProcessingService);
        this.services.put(new MultiKey((Object)"002", (Object)ConsentType.AIS), (Object)this.noProcessingService);
        this.services.put(new MultiKey((Object)this.aisV3.getVersion(), (Object)ConsentType.AIS), (Object)this.aisV3);
    }

    public Optional<ChecksumCalculatingService> getServiceByChecksum(byte[] checksum, ConsentType consentType) {
        if (checksum == null) {
            return this.getDefaultService(consentType);
        }
        String checksumStr = new String(checksum);
        String[] elements = checksumStr.split("_%_");
        if (elements.length < 1) {
            return this.getDefaultService(consentType);
        }
        String versionSting = elements[0];
        return Optional.ofNullable((ChecksumCalculatingService)this.services.get((Object)new MultiKey((Object)versionSting, (Object)consentType)));
    }

    private Optional<ChecksumCalculatingService> getDefaultService(ConsentType consentType) {
        if (ConsentType.AIS == consentType) {
            return Optional.of(this.aisV3);
        }
        return Optional.empty();
    }
}

