/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.repository.PisPaymentDataRepository;
import de.adorsys.psd2.consent.service.CorePaymentsConvertService;
import de.adorsys.psd2.consent.service.PisCommonPaymentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.authorisation.CmsAuthorisationService;
import de.adorsys.psd2.consent.service.mapper.AuthorisationMapper;
import de.adorsys.psd2.consent.service.mapper.PisCommonPaymentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PisCancellationAuthService
extends CmsAuthorisationService<PisCommonPaymentData> {
    private static final Logger log = LoggerFactory.getLogger(PisCancellationAuthService.class);
    private PisPaymentDataRepository pisPaymentDataRepository;
    private PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private PisCommonPaymentMapper pisCommonPaymentMapper;
    private CorePaymentsConvertService corePaymentsConvertService;

    @Autowired
    public PisCancellationAuthService(CmsPsuService cmsPsuService, PsuDataMapper psuDataMapper, AspspProfileService aspspProfileService, AuthorisationRepository authorisationRepository, PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService, PisPaymentDataRepository pisPaymentDataRepository, AuthorisationMapper authorisationMapper, PisCommonPaymentDataRepository pisCommonPaymentDataRepository, PisCommonPaymentMapper pisCommonPaymentMapper, CorePaymentsConvertService corePaymentsConvertService) {
        super(cmsPsuService, psuDataMapper, aspspProfileService, authorisationMapper, authorisationRepository, pisCommonPaymentConfirmationExpirationService);
        this.pisPaymentDataRepository = pisPaymentDataRepository;
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.corePaymentsConvertService = corePaymentsConvertService;
    }

    @Override
    public Optional<Authorisable> getNotFinalisedAuthorisationParent(String parentId) {
        Optional<PisCommonPaymentData> commonPaymentData = this.pisPaymentDataRepository.findByPaymentId(parentId).filter(CollectionUtils::isNotEmpty).map(list -> ((PisPaymentData)list.get(0)).getPaymentData());
        if (commonPaymentData.isEmpty()) {
            commonPaymentData = this.pisCommonPaymentDataRepository.findByPaymentId(parentId);
        }
        return commonPaymentData.filter(p -> p.getTransactionStatus().isNotFinalisedStatus()).map(this::convertToCommonPayment);
    }

    @Override
    public Optional<Authorisable> getAuthorisationParent(String parentId) {
        return this.pisCommonPaymentDataRepository.findByPaymentId(parentId).map(con -> con);
    }

    @Override
    AuthorisationType getAuthorisationType() {
        return AuthorisationType.PIS_CANCELLATION;
    }

    @Override
    PisCommonPaymentData castToParent(Authorisable authorisable) {
        return (PisCommonPaymentData)authorisable;
    }

    private PisCommonPaymentData convertToCommonPayment(PisCommonPaymentData pisCommonPaymentData) {
        if (pisCommonPaymentData == null || pisCommonPaymentData.getPayment() != null) {
            return pisCommonPaymentData;
        }
        List<PisPayment> pisPayments = pisCommonPaymentData.getPayments().stream().map(this.pisCommonPaymentMapper::mapToPisPayment).collect(Collectors.toList());
        byte[] paymentData = this.corePaymentsConvertService.buildPaymentData(pisPayments, pisCommonPaymentData.getPaymentType());
        if (paymentData != null) {
            pisCommonPaymentData.setPayment(paymentData);
            return (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(pisCommonPaymentData);
        }
        return pisCommonPaymentData;
    }
}

