/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.specification.CommonSpecification;
import de.adorsys.psd2.consent.repository.specification.EntityAttributeSpecificationProvider;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.criteria.Join;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ConsentSpecification {
    private final CommonSpecification<ConsentEntity> commonSpecification;

    public Specification<ConsentEntity> byAspspAccountIdAndCreationPeriodAndInstanceId(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return Specification.where(this.byAspspAccountIdInAspspAccountAccess(aspspAccountId)).and(this.commonSpecification.byCreationTimestamp(createDateFrom, createDateTo)).and(this.commonSpecification.byInstanceId(instanceId));
    }

    public Specification<ConsentEntity> byPsuIdDataAndAspspAccountIdAndInstanceId(@NotNull PsuIdData psuIdData, @Nullable String aspspAccountId, @Nullable String instanceId) {
        return Specification.where(this.byAspspAccountIdInAspspAccountAccess(aspspAccountId)).and(this.commonSpecification.byPsuIdDataInList(psuIdData)).and(this.commonSpecification.byInstanceId(instanceId));
    }

    public Specification<ConsentEntity> byConsentIdAndInstanceId(String consentId, String instanceId) {
        return Specification.where(this.commonSpecification.byInstanceId(instanceId)).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("externalId", consentId));
    }

    public Specification<ConsentEntity> byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(@NotNull String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @Nullable String instanceId) {
        return Specification.where(this.byTpp(tppAuthorisationNumber)).and(this.commonSpecification.byCreationTimestamp(createDateFrom, createDateTo)).and(this.commonSpecification.byPsuIdDataInList(psuIdData)).and(this.commonSpecification.byInstanceId(instanceId));
    }

    public Specification<ConsentEntity> byPsuDataInListAndInstanceId(PsuIdData psuIdData, String instanceId) {
        return this.commonSpecification.byPsuIdDataInList(psuIdData).and(this.commonSpecification.byInstanceId(instanceId));
    }

    public Specification<ConsentEntity> byTpp(@Nullable String tppAuthorisationNumber) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join consentTppInformationJoin = root.join("tppInformation");
            Join tppInfoJoin = consentTppInformationJoin.join("tppInfo");
            return EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(tppInfoJoin, "authorisationNumber", tppAuthorisationNumber).toPredicate(root, query, cb);
        };
    }

    private Specification<ConsentEntity> byAspspAccountIdInAspspAccountAccess(@Nullable String aspspAccountId) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join aspspAccountAccessJoin = root.join("aspspAccountAccesses");
            return EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(aspspAccountAccessJoin, "aspspAccountId", aspspAccountId).toPredicate(root, query, cb);
        };
    }

    @ConstructorProperties(value={"commonSpecification"})
    public ConsentSpecification(CommonSpecification<ConsentEntity> commonSpecification) {
        this.commonSpecification = commonSpecification;
    }
}

