package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationTemplate;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-07-01T08:54:41+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class AuthorisationTemplateMapperImpl implements AuthorisationTemplateMapper {

    @Override
    public AuthorisationTemplate mapToAuthorisationTemplate(AuthorisationTemplateEntity entity) {
        if ( entity == null ) {
            return null;
        }

        AuthorisationTemplate authorisationTemplate = new AuthorisationTemplate();

        authorisationTemplate.setCancelTppRedirectUri( createTppRedirectUri(entity.getCancelRedirectUri(), entity.getCancelNokRedirectUri()) );
        authorisationTemplate.setTppRedirectUri( createTppRedirectUri(entity.getRedirectUri(), entity.getNokRedirectUri()) );

        return authorisationTemplate;
    }

    @Override
    public AuthorisationTemplateEntity mapToAuthorisationTemplateEntity(AuthorisationTemplate authorisationTemplate) {
        if ( authorisationTemplate == null ) {
            return null;
        }

        AuthorisationTemplateEntity authorisationTemplateEntity = new AuthorisationTemplateEntity();

        authorisationTemplateEntity.setRedirectUri( getUriOrNull(authorisationTemplate.getTppRedirectUri(), TppRedirectUri::getUri) );
        authorisationTemplateEntity.setCancelNokRedirectUri( getUriOrNull(authorisationTemplate.getCancelTppRedirectUri(), TppRedirectUri::getNokUri) );
        authorisationTemplateEntity.setNokRedirectUri( getUriOrNull(authorisationTemplate.getTppRedirectUri(), TppRedirectUri::getNokUri) );
        authorisationTemplateEntity.setCancelRedirectUri( getUriOrNull(authorisationTemplate.getCancelTppRedirectUri(), TppRedirectUri::getUri) );

        return authorisationTemplateEntity;
    }
}
