package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-08-28T10:12:54+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 1.8.0_265 (Azul Systems, Inc.)"
)
@Component
public class AuthorisationMapperImpl implements AuthorisationMapper {

    @Autowired
    private PsuDataMapper psuDataMapper;

    @Override
    public Authorisation mapToAuthorisation(AuthorisationEntity authorisationEntity) {
        if ( authorisationEntity == null ) {
            return null;
        }

        Authorisation authorisation = new Authorisation();

        authorisation.setAuthorisationId( authorisationEntity.getExternalId() );
        authorisation.setPsuIdData( psuDataMapper.mapToPsuIdData( authorisationEntity.getPsuData() ) );
        authorisation.setParentId( authorisationEntity.getParentExternalId() );
        authorisation.setChosenScaApproach( authorisationEntity.getScaApproach() );
        authorisation.setAuthorisationType( authorisationEntity.getAuthorisationType() );
        authorisation.setScaStatus( authorisationEntity.getScaStatus() );
        authorisation.setAuthenticationMethodId( authorisationEntity.getAuthenticationMethodId() );
        authorisation.setScaAuthenticationData( authorisationEntity.getScaAuthenticationData() );

        return authorisation;
    }

    @Override
    public List<Authorisation> mapToAuthorisations(List<AuthorisationEntity> authorisationEntityList) {
        if ( authorisationEntityList == null ) {
            return null;
        }

        List<Authorisation> list = new ArrayList<Authorisation>( authorisationEntityList.size() );
        for ( AuthorisationEntity authorisationEntity : authorisationEntityList ) {
            list.add( mapToAuthorisation( authorisationEntity ) );
        }

        return list;
    }
}
