/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.UpdatePaymentAfterSpiService;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.service.CommonPaymentDataService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UpdatePaymentAfterSpiServiceInternal
implements UpdatePaymentAfterSpiService {
    private static final Logger log = LoggerFactory.getLogger(UpdatePaymentAfterSpiServiceInternal.class);
    private final CommonPaymentDataService commonPaymentDataService;

    @Transactional
    public CmsResponse<Boolean> updatePaymentStatus(@NotNull String paymentId, @NotNull TransactionStatus status) {
        Optional<PisCommonPaymentData> paymentDataOptional = this.commonPaymentDataService.getPisCommonPaymentData(paymentId, null);
        if (!paymentDataOptional.isPresent() || paymentDataOptional.get().isFinalised()) {
            log.info("Payment ID [{}]. Update payment status by id failed, because pis payment data not found or payment is finalized", (Object)paymentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        boolean updated = this.commonPaymentDataService.updateStatusInPaymentData(paymentDataOptional.get(), status);
        return CmsResponse.builder().payload((Object)updated).build();
    }

    @Transactional
    public CmsResponse<Boolean> updatePaymentCancellationTppRedirectUri(@NotNull String paymentId, @NotNull TppRedirectUri tppRedirectUri) {
        Optional<PisCommonPaymentData> paymentDataOptional = this.commonPaymentDataService.getPisCommonPaymentData(paymentId, null);
        if (!paymentDataOptional.isPresent() || paymentDataOptional.get().isFinalised()) {
            log.info("Payment ID [{}]. Update payment status by id failed, because pis payment data not found or payment is finalized", (Object)paymentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        boolean updated = this.commonPaymentDataService.updateCancelTppRedirectURIs(paymentDataOptional.get(), tppRedirectUri);
        return CmsResponse.builder().payload((Object)updated).build();
    }

    @Transactional
    public CmsResponse<Boolean> updatePaymentCancellationInternalRequestId(@NotNull String paymentId, @NotNull String internalRequestId) {
        Optional<PisCommonPaymentData> paymentDataOptional = this.commonPaymentDataService.getPisCommonPaymentData(paymentId, null);
        if (!paymentDataOptional.isPresent() || paymentDataOptional.get().isFinalised()) {
            log.info("Payment ID [{}]. Update payment intrenal request id failed, because pis payment data not found or payment is finalized", (Object)paymentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        boolean updated = this.commonPaymentDataService.updatePaymentCancellationInternalRequestId(paymentDataOptional.get(), internalRequestId);
        return CmsResponse.builder().payload((Object)updated).build();
    }

    @ConstructorProperties(value={"commonPaymentDataService"})
    public UpdatePaymentAfterSpiServiceInternal(CommonPaymentDataService commonPaymentDataService) {
        this.commonPaymentDataService = commonPaymentDataService;
    }
}

