/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.authorisation.AuthorisationParentHolder;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.api.service.AuthorisationService;
import de.adorsys.psd2.consent.api.service.AuthorisationServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AuthorisationServiceInternalEncrypted
implements AuthorisationServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationServiceInternalEncrypted.class);
    private final SecurityDataService securityDataService;
    private final AuthorisationService authorisationService;

    @Transactional
    public CmsResponse<CreateAuthorisationResponse> createAuthorisation(AuthorisationParentHolder parentHolder, CreateAuthorisationRequest request) {
        String encryptedId = parentHolder.getParentId();
        Optional<String> decryptedIdOptional = this.securityDataService.decryptId(encryptedId);
        if (!decryptedIdOptional.isPresent()) {
            log.info("Encrypted Parent ID: [{}]. Create authorisation has failed, couldn't decrypt parent id", (Object)encryptedId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.authorisationService.createAuthorisation(new AuthorisationParentHolder(parentHolder.getAuthorisationType(), decryptedIdOptional.get()), request);
    }

    @Transactional(readOnly=true)
    public CmsResponse<Authorisation> getAuthorisationById(String authorisationId) {
        return this.authorisationService.getAuthorisationById(authorisationId);
    }

    @Transactional
    public CmsResponse<Authorisation> updateAuthorisation(String authorisationId, UpdateAuthorisationRequest request) {
        return this.authorisationService.updateAuthorisation(authorisationId, request);
    }

    @Transactional
    public CmsResponse<Boolean> updateAuthorisationStatus(String authorisationId, ScaStatus scaStatus) {
        return this.authorisationService.updateAuthorisationStatus(authorisationId, scaStatus);
    }

    @Transactional
    public CmsResponse<List<String>> getAuthorisationsByParentId(AuthorisationParentHolder parentHolder) {
        String encryptedId = parentHolder.getParentId();
        Optional<String> decryptedIdOptional = this.securityDataService.decryptId(encryptedId);
        if (!decryptedIdOptional.isPresent()) {
            log.info("Encrypted Parent ID: [{}]. Get authorisation has failed, couldn't decrypt parent id", (Object)encryptedId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.authorisationService.getAuthorisationsByParentId(new AuthorisationParentHolder(parentHolder.getAuthorisationType(), decryptedIdOptional.get()));
    }

    @Transactional
    public CmsResponse<ScaStatus> getAuthorisationScaStatus(String authorisationId, AuthorisationParentHolder parentHolder) {
        String encryptedId = parentHolder.getParentId();
        Optional<String> decryptedIdOptional = this.securityDataService.decryptId(encryptedId);
        if (!decryptedIdOptional.isPresent()) {
            log.info("Encrypted Parent ID: [{}]. Get SCA status has failed, couldn't decrypt parent id", (Object)encryptedId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.authorisationService.getAuthorisationScaStatus(authorisationId, new AuthorisationParentHolder(parentHolder.getAuthorisationType(), decryptedIdOptional.get()));
    }

    @Transactional(readOnly=true)
    public CmsResponse<Boolean> isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        return this.authorisationService.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    @Transactional
    public CmsResponse<Boolean> saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        return this.authorisationService.saveAuthenticationMethods(authorisationId, methods);
    }

    @Transactional
    public CmsResponse<Boolean> updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        return this.authorisationService.updateScaApproach(authorisationId, scaApproach);
    }

    @Transactional(readOnly=true)
    public CmsResponse<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId) {
        return this.authorisationService.getAuthorisationScaApproach(authorisationId);
    }

    @ConstructorProperties(value={"securityDataService", "authorisationService"})
    public AuthorisationServiceInternalEncrypted(SecurityDataService securityDataService, AuthorisationService authorisationService) {
        this.securityDataService = securityDataService;
        this.authorisationService = authorisationService;
    }
}

