/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.service.AisConsentService;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.account.AisConsentAction;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.AisConsentActionRepository;
import de.adorsys.psd2.consent.repository.AisConsentVerifyingRepository;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.AisConsentUsageService;
import de.adorsys.psd2.consent.service.OneOffConsentExpirationService;
import de.adorsys.psd2.consent.service.account.AccountAccessUpdater;
import de.adorsys.psd2.consent.service.mapper.AccessMapper;
import de.adorsys.psd2.consent.service.mapper.CmsConsentMapper;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AisConsentServiceInternal
implements AisConsentService {
    private static final Logger log = LoggerFactory.getLogger(AisConsentServiceInternal.class);
    private final AisConsentVerifyingRepository aisConsentRepository;
    private final AisConsentActionRepository aisConsentActionRepository;
    private final AuthorisationRepository authorisationRepository;
    private final AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService;
    private final AisConsentUsageService aisConsentUsageService;
    private final OneOffConsentExpirationService oneOffConsentExpirationService;
    private final CmsConsentMapper cmsConsentMapper;
    private final AccessMapper accessMapper;
    private final AccountAccessUpdater accountAccessUpdater;

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<CmsResponse.VoidResponse> checkConsentAndSaveActionLog(AisConsentActionRequest request) throws WrongChecksumException {
        Optional<ConsentEntity> consentOpt = this.aisConsentRepository.getActualAisConsent(request.getConsentId());
        if (consentOpt.isPresent()) {
            ConsentEntity consent = consentOpt.get();
            this.aisConsentConfirmationExpirationService.checkAndUpdateOnConfirmationExpiration(consent);
            this.checkAndUpdateOnExpiration(consent);
            this.updateAisConsentUsage(consent, request);
            this.logConsentAction(consent.getExternalId(), this.resolveConsentActionStatus(request, consent), request.getTppId());
        }
        return CmsResponse.builder().payload((Object)CmsResponse.voidResponse()).build();
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<CmsConsent> updateAspspAccountAccess(String consentId, AisAccountAccessInfo request) throws WrongChecksumException {
        Optional<ConsentEntity> consentOptional = this.aisConsentRepository.getActualAisConsent(consentId);
        if (!consentOptional.isPresent()) {
            log.info("Consent ID [{}]. Update aspsp account access with response failed, because consent not found", (Object)consentId);
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        ConsentEntity consentEntity = consentOptional.get();
        ConsentEntity updatedConsent = this.updateConsentAccess(consentEntity, request);
        ConsentEntity savedConsent = this.aisConsentRepository.verifyAndUpdate(updatedConsent);
        CmsConsent cmsConsent = this.mapToCmsConsent(savedConsent);
        return CmsResponse.builder().payload((Object)cmsConsent).build();
    }

    private ConsentEntity updateConsentAccess(ConsentEntity consentEntity, AisAccountAccessInfo request) {
        List<AspspAccountAccess> aspspAccountAccesses = consentEntity.getAspspAccountAccesses();
        AccountAccess existingAccess = this.accessMapper.mapAspspAccessesToAccountAccess(aspspAccountAccesses, consentEntity.getOwnerNameType());
        AccountAccess requestedAccess = this.accessMapper.mapToAccountAccess(request);
        AccountAccess updatedAccesses = this.accountAccessUpdater.updateAccountReferencesInAccess(existingAccess, requestedAccess);
        List<AspspAccountAccess> updatedAspspAccountAccesses = this.accessMapper.mapToAspspAccountAccess(updatedAccesses);
        consentEntity.setAspspAccountAccesses(updatedAspspAccountAccesses);
        return consentEntity;
    }

    private ConsentEntity checkAndUpdateOnExpiration(ConsentEntity consent) {
        if (consent.shouldConsentBeExpired()) {
            return this.aisConsentConfirmationExpirationService.expireConsent(consent);
        }
        return consent;
    }

    private void updateAisConsentUsage(ConsentEntity consent, AisConsentActionRequest request) throws WrongChecksumException {
        if (!request.isUpdateUsage()) {
            return;
        }
        this.aisConsentUsageService.incrementUsage(consent, request);
        CmsConsent cmsConsent = this.mapToCmsConsent(consent);
        if (!consent.isRecurringIndicator() && consent.getFrequencyPerDay() == 1 && this.oneOffConsentExpirationService.isConsentExpired(cmsConsent, consent.getId())) {
            consent.setConsentStatus(ConsentStatus.EXPIRED);
        }
        consent.setLastActionDate(LocalDate.now());
        this.aisConsentRepository.verifyAndSave(consent);
    }

    private CmsConsent mapToCmsConsent(ConsentEntity consent) {
        List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationType(consent.getExternalId(), AuthorisationType.AIS);
        Map<String, Integer> usageCounterMap = this.aisConsentUsageService.getUsageCounterMap(consent);
        return this.cmsConsentMapper.mapToCmsConsent(consent, authorisations, usageCounterMap);
    }

    private ActionStatus resolveConsentActionStatus(AisConsentActionRequest request, ConsentEntity consent) {
        if (consent == null) {
            log.info("Consent ID: [{}]. Consent action status resolver received null consent", (Object)request.getConsentId());
            return ActionStatus.BAD_PAYLOAD;
        }
        return request.getActionStatus();
    }

    private void logConsentAction(String requestedConsentId, ActionStatus actionStatus, String tppId) {
        AisConsentAction action = new AisConsentAction();
        action.setActionStatus(actionStatus);
        action.setRequestedConsentId(requestedConsentId);
        action.setTppId(tppId);
        action.setRequestDate(LocalDate.now());
        this.aisConsentActionRepository.save(action);
    }

    @ConstructorProperties(value={"aisConsentRepository", "aisConsentActionRepository", "authorisationRepository", "aisConsentConfirmationExpirationService", "aisConsentUsageService", "oneOffConsentExpirationService", "cmsConsentMapper", "accessMapper", "accountAccessUpdater"})
    public AisConsentServiceInternal(AisConsentVerifyingRepository aisConsentRepository, AisConsentActionRepository aisConsentActionRepository, AuthorisationRepository authorisationRepository, AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService, AisConsentUsageService aisConsentUsageService, OneOffConsentExpirationService oneOffConsentExpirationService, CmsConsentMapper cmsConsentMapper, AccessMapper accessMapper, AccountAccessUpdater accountAccessUpdater) {
        this.aisConsentRepository = aisConsentRepository;
        this.aisConsentActionRepository = aisConsentActionRepository;
        this.authorisationRepository = authorisationRepository;
        this.aisConsentConfirmationExpirationService = aisConsentConfirmationExpirationService;
        this.aisConsentUsageService = aisConsentUsageService;
        this.oneOffConsentExpirationService = oneOffConsentExpirationService;
        this.cmsConsentMapper = cmsConsentMapper;
        this.accessMapper = accessMapper;
        this.accountAccessUpdater = accountAccessUpdater;
    }
}

