/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.sha.v3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingService;
import de.adorsys.psd2.consent.service.sha.Sha512HashingService;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.Consent;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AisChecksumCalculatingServiceV3
implements ChecksumCalculatingService {
    private static final Logger log = LoggerFactory.getLogger(AisChecksumCalculatingServiceV3.class);
    private static final String VERSION = "003";
    private static final Charset CHARSET = Charset.defaultCharset();
    private final Sha512HashingService hashingService = new Sha512HashingService();
    private final ObjectMapper objectMapper = this.buildObjectMapper();

    @Override
    public boolean verifyConsentWithChecksum(Consent<?> consent, byte[] checksum) {
        if (consent == null || checksum == null) {
            return false;
        }
        if (ConsentType.AIS == consent.getConsentType()) {
            AisConsent aisConsent = (AisConsent)consent;
            return this.verifyConsentWithChecksumForAisConsent(aisConsent, checksum);
        }
        return false;
    }

    @Override
    public byte[] calculateChecksumForConsent(Consent<?> consent) {
        if (consent == null) {
            return new byte[0];
        }
        if (ConsentType.AIS == consent.getConsentType()) {
            AisConsent aisConsent = (AisConsent)consent;
            return this.calculateChecksumForAisConsent(aisConsent);
        }
        return new byte[0];
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    private boolean verifyConsentWithChecksumForAisConsent(AisConsent aisConsent, byte[] checksum) {
        String checksumStr = new String(checksum);
        String[] elements = checksumStr.split("_%_");
        if (elements.length == 1) {
            return false;
        }
        String consentChecksumFromDb = elements[1];
        String aisConsentChecksumCommon = this.calculateChecksumForAisConsentCommon(aisConsent);
        if (!consentChecksumFromDb.equals(aisConsentChecksumCommon)) {
            return false;
        }
        return this.isAspspAccessesChecksumValid(elements, aisConsent.getAspspAccountAccesses());
    }

    private boolean isAspspAccessesChecksumValid(String[] elements, AccountAccess aspspAccess) {
        if (elements.length > 2) {
            String aspspAccessFromDb = elements[2];
            Map<AccountReferenceType, String> accessChecksumMapFromDB = this.getChecksumMapFromEncodedString(aspspAccessFromDb);
            Map<AccountReferenceType, String> currentAccessChecksumMap = this.calculateChecksumMapByReferenceType(aspspAccess);
            return this.areCurrentAccessesValid(accessChecksumMapFromDB, currentAccessChecksumMap);
        }
        return true;
    }

    private byte[] calculateChecksumForAisConsent(AisConsent aisConsent) {
        Map<AccountReferenceType, String> checksumMap;
        StringBuilder sb = new StringBuilder(VERSION).append("_%_");
        String aisConsentChecksumCommon = this.calculateChecksumForAisConsentCommon(aisConsent);
        sb.append(aisConsentChecksumCommon);
        AccountAccess aspspAccountAccess = aisConsent.getAspspAccountAccesses();
        if (aspspAccountAccess.isNotEmpty((AisConsentData)aisConsent.getConsentData()) && !(checksumMap = this.calculateChecksumMapByReferenceType(aspspAccountAccess)).isEmpty()) {
            byte[] checksumMapInBytes = this.getBytesFromObject(checksumMap);
            String aspspAccessChecksumEncodedString = Base64.getEncoder().encodeToString(checksumMapInBytes);
            sb.append("_%_");
            sb.append(aspspAccessChecksumEncodedString);
        }
        return sb.toString().getBytes();
    }

    private Map<AccountReferenceType, String> getChecksumMapFromEncodedString(String aspspAccessFromDb) {
        byte[] decodedString = Base64.getDecoder().decode(aspspAccessFromDb);
        return this.getChecksumMapFromBytes(decodedString);
    }

    private String calculateChecksumForAisConsentCommon(AisConsent aisConsent) {
        LinkedHashMap<String, Comparable<Boolean>> map = new LinkedHashMap<String, Comparable<Boolean>>();
        map.put("recurringIndicator", Boolean.valueOf(aisConsent.isRecurringIndicator()));
        map.put("combinedServiceIndicator", Boolean.valueOf(((AisConsentData)aisConsent.getConsentData()).isCombinedServiceIndicator()));
        map.put("validUntil", aisConsent.getValidUntil());
        map.put("tppFrequencyPerDay", aisConsent.getFrequencyPerDay());
        map.put("accesses", (Comparable<Boolean>)aisConsent.getTppAccountAccesses());
        byte[] consentAsBytes = this.getBytesFromObject(map);
        byte[] consentChecksum = this.calculateChecksum(consentAsBytes);
        return Base64.getEncoder().encodeToString(consentChecksum);
    }

    private Map<AccountReferenceType, String> calculateChecksumMapByReferenceType(AccountAccess aspspAccess) {
        LinkedHashMap<AccountReferenceType, String> checkSumMap = new LinkedHashMap<AccountReferenceType, String>();
        for (AccountReferenceType type : AccountReferenceType.values()) {
            String checksumByType = this.getChecksumByType(aspspAccess, type);
            if (checksumByType == null) continue;
            checkSumMap.put(type, checksumByType);
        }
        return checkSumMap;
    }

    private String getChecksumByType(AccountAccess aspspAccess, AccountReferenceType type) {
        Set references = Stream.of(aspspAccess.getAccounts(), aspspAccess.getBalances(), aspspAccess.getTransactions()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        List filtered = references.stream().filter(acc -> acc.getUsedAccountReferenceSelector().getAccountReferenceType() == type).filter(acc -> StringUtils.isNotBlank((CharSequence)acc.getResourceId()) || StringUtils.isNotBlank((CharSequence)acc.getAspspAccountId())).sorted(Comparator.comparing(AccountReference::getAccountReferenceType).thenComparing(acc -> Optional.ofNullable(acc.getCurrency()).map(Currency::getCurrencyCode).orElse(null))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filtered)) {
            return null;
        }
        byte[] consentRefsAsBytes = this.getBytesFromObject(filtered);
        byte[] consentRefsChecksum = this.calculateChecksum(consentRefsAsBytes);
        return Base64.getEncoder().encodeToString(consentRefsChecksum);
    }

    private boolean areCurrentAccessesValid(Map<AccountReferenceType, String> accessMapFromDB, Map<AccountReferenceType, String> currentAccessMap) {
        if (accessMapFromDB == null || currentAccessMap == null) {
            return false;
        }
        return accessMapFromDB.entrySet().stream().allMatch(ent -> Optional.ofNullable(ent.getValue()).map(v -> v.equals(currentAccessMap.get(ent.getKey()))).orElse(false));
    }

    private byte[] calculateChecksum(byte[] checksumSource) {
        return this.hashingService.hash(checksumSource, CHARSET);
    }

    private Map<AccountReferenceType, String> getChecksumMapFromBytes(byte[] bytes) {
        try {
            return (Map)this.objectMapper.readValue(bytes, (TypeReference)new TypeReference<LinkedHashMap<AccountReferenceType, String>>(){});
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }

    private byte[] getBytesFromObject(Object inputValue) {
        try {
            return this.objectMapper.writeValueAsBytes(inputValue);
        }
        catch (JsonProcessingException e) {
            return new byte[0];
        }
    }

    private ObjectMapper buildObjectMapper() {
        ObjectMapper localObjectMapper = new ObjectMapper();
        localObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        localObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        localObjectMapper.registerModule((Module)new JavaTimeModule());
        return localObjectMapper;
    }
}

