/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.migration;

import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.domain.piis.PiisConsentEntity;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.migration.ObsoletePiisConsentJpaRepository;
import de.adorsys.psd2.core.data.piis.v1.PiisConsentData;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PiisConsentLazyMigrationService {
    private static final Logger log = LoggerFactory.getLogger(PiisConsentLazyMigrationService.class);
    private final ObsoletePiisConsentJpaRepository obsoletePiisConsentJpaRepository;
    private final ConsentJpaRepository consentJpaRepository;
    private final ConsentDataMapper consentDataMapper;

    public ConsentEntity migrateIfNeeded(ConsentEntity consentEntity) {
        Optional<PiisConsentEntity> obsoletePiisConsentOptional;
        if (consentEntity.getData() == null && (obsoletePiisConsentOptional = this.obsoletePiisConsentJpaRepository.findByExternalId(consentEntity.getExternalId())).isPresent()) {
            byte[] consentData = this.getConsentData(obsoletePiisConsentOptional.get());
            consentEntity.setData(consentData);
            this.consentJpaRepository.save(consentEntity);
        }
        return consentEntity;
    }

    public List<ConsentEntity> migrateIfNeeded(List<ConsentEntity> consentEntities) {
        consentEntities.forEach(this::migrateIfNeeded);
        return consentEntities;
    }

    private byte[] getConsentData(PiisConsentEntity piisConsent) {
        PiisConsentData piisConsentData = new PiisConsentData(piisConsent.getCardNumber(), piisConsent.getCardExpiryDate(), piisConsent.getCardInformation(), piisConsent.getRegistrationInformation());
        return this.consentDataMapper.getBytesFromConsentData((Object)piisConsentData);
    }

    @ConstructorProperties(value={"obsoletePiisConsentJpaRepository", "consentJpaRepository", "consentDataMapper"})
    public PiisConsentLazyMigrationService(ObsoletePiisConsentJpaRepository obsoletePiisConsentJpaRepository, ConsentJpaRepository consentJpaRepository, ConsentDataMapper consentDataMapper) {
        this.obsoletePiisConsentJpaRepository = obsoletePiisConsentJpaRepository;
        this.consentJpaRepository = consentJpaRepository;
        this.consentDataMapper = consentDataMapper;
    }
}

