/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.api.ais.CmsAisAccountConsent;
import de.adorsys.psd2.consent.aspsp.api.ais.CmsAspspAisExportService;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.specification.AisConsentSpecification;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.service.migration.AisConsentLazyMigrationService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsAspspAisExportServiceInternal
implements CmsAspspAisExportService {
    private static final Logger log = LoggerFactory.getLogger(CmsAspspAisExportServiceInternal.class);
    private final AisConsentSpecification aisConsentSpecification;
    private final ConsentJpaRepository consentJpaRepository;
    private final AisConsentMapper aisConsentMapper;
    private final AuthorisationRepository authorisationRepository;
    private final AisConsentLazyMigrationService aisConsentLazyMigrationService;

    @Transactional
    public Collection<CmsAisAccountConsent> exportConsentsByTpp(String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @NotNull String instanceId) {
        if (StringUtils.isBlank((CharSequence)tppAuthorisationNumber) || StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("TPP ID: [{}], InstanceId: [{}]. Export Consents by TPP: Some of these two values are empty", (Object)tppAuthorisationNumber, (Object)instanceId);
            return Collections.emptyList();
        }
        return this.consentJpaRepository.findAll(this.aisConsentSpecification.byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(tppAuthorisationNumber, createDateFrom, createDateTo, psuIdData, instanceId)).stream().map(this.aisConsentLazyMigrationService::migrateIfNeeded).map(this::mapToCmsAisAccountConsentWithAuthorisations).collect(Collectors.toList());
    }

    @Transactional
    public Collection<CmsAisAccountConsent> exportConsentsByPsu(PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @NotNull String instanceId) {
        if (psuIdData == null || psuIdData.isEmpty() || StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("InstanceId: [{}]. Export consents by Psu failed, psuIdData or instanceId is empty or null.", (Object)instanceId);
            return Collections.emptyList();
        }
        return this.consentJpaRepository.findAll(this.aisConsentSpecification.byPsuIdDataAndCreationPeriodAndInstanceId(psuIdData, createDateFrom, createDateTo, instanceId)).stream().map(this.aisConsentLazyMigrationService::migrateIfNeeded).map(this::mapToCmsAisAccountConsentWithAuthorisations).collect(Collectors.toList());
    }

    @Transactional
    public Collection<CmsAisAccountConsent> exportConsentsByAccountId(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @NotNull String instanceId) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("InstanceId: [{}], aspspAccountId: [{}]. Export consents by accountId failed, instanceId is empty or null.", (Object)instanceId, (Object)aspspAccountId);
            return Collections.emptyList();
        }
        Specification<ConsentEntity> specification = this.aisConsentSpecification.byAspspAccountIdAndCreationPeriodAndInstanceId(aspspAccountId, createDateFrom, createDateTo, instanceId);
        List consents = this.consentJpaRepository.findAll(specification).stream().map(this.aisConsentLazyMigrationService::migrateIfNeeded).collect(Collectors.toList());
        return consents.stream().map(this::mapToCmsAisAccountConsentWithAuthorisations).collect(Collectors.toList());
    }

    private CmsAisAccountConsent mapToCmsAisAccountConsentWithAuthorisations(ConsentEntity aisConsentEntity) {
        List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationType(aisConsentEntity.getExternalId(), AuthorisationType.AIS);
        return this.aisConsentMapper.mapToCmsAisAccountConsent(aisConsentEntity, authorisations);
    }

    @ConstructorProperties(value={"aisConsentSpecification", "consentJpaRepository", "aisConsentMapper", "authorisationRepository", "aisConsentLazyMigrationService"})
    public CmsAspspAisExportServiceInternal(AisConsentSpecification aisConsentSpecification, ConsentJpaRepository consentJpaRepository, AisConsentMapper aisConsentMapper, AuthorisationRepository authorisationRepository, AisConsentLazyMigrationService aisConsentLazyMigrationService) {
        this.aisConsentSpecification = aisConsentSpecification;
        this.consentJpaRepository = consentJpaRepository;
        this.aisConsentMapper = aisConsentMapper;
        this.authorisationRepository = authorisationRepository;
        this.aisConsentLazyMigrationService = aisConsentLazyMigrationService;
    }
}

