/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentTransaction;
import de.adorsys.psd2.consent.repository.AisConsentTransactionRepository;
import de.adorsys.psd2.consent.repository.AisConsentUsageRepository;
import de.adorsys.psd2.consent.service.mapper.CmsAisConsentMapper;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class OneOffConsentExpirationService {
    public static final int READ_ONLY_ACCOUNT_DETAILS_COUNT = 1;
    public static final int READ_ACCOUNT_DETAILS_AND_BALANCES_COUNT = 2;
    public static final int READ_ACCOUNT_DETAILS_AND_TRANSACTIONS_COUNT = 2;
    public static final int READ_ALL_DETAILS_COUNT = 3;
    private final AisConsentUsageRepository aisConsentUsageRepository;
    private final AisConsentTransactionRepository aisConsentTransactionRepository;
    private final CmsAisConsentMapper cmsAisConsentMapper;

    public boolean isConsentExpired(CmsConsent cmsConsent, Long consentId) {
        AisConsentRequestType consentRequestType = this.cmsAisConsentMapper.mapToAisConsent(cmsConsent).getConsentRequestType();
        if (consentRequestType == AisConsentRequestType.BANK_OFFERED) {
            return false;
        }
        if (consentRequestType == AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS) {
            return true;
        }
        AccountAccess aspspAccountAccesses = cmsConsent.getAspspAccountAccesses();
        List references = Stream.of(aspspAccountAccesses.getAccounts(), aspspAccountAccesses.getBalances(), aspspAccountAccesses.getTransactions()).flatMap(Collection::stream).collect(Collectors.toList());
        List consentResourceIds = references.stream().map(AccountReference::getResourceId).distinct().collect(Collectors.toList());
        boolean isExpired = true;
        for (String resourceId : consentResourceIds) {
            List<AisConsentTransaction> consentTransactions = this.aisConsentTransactionRepository.findByConsentIdAndResourceId(consentId, resourceId, (Pageable)PageRequest.of((int)0, (int)1));
            int numberOfTransactions = CollectionUtils.isNotEmpty(consentTransactions) ? consentTransactions.get(0).getNumberOfTransactions() : 0;
            int maximumNumberOfGetRequestsForConsent = this.getMaximumNumberOfGetRequestsForConsentsAccount(aspspAccountAccesses, resourceId, numberOfTransactions);
            int numberOfUsedGetRequestsForConsent = this.aisConsentUsageRepository.countByConsentIdAndResourceId(consentId, resourceId);
            if (numberOfUsedGetRequestsForConsent >= maximumNumberOfGetRequestsForConsent) continue;
            isExpired = false;
            break;
        }
        return isExpired;
    }

    private int getMaximumNumberOfGetRequestsForConsentsAccount(AccountAccess aspspAccountAccesses, String resourceId, int numberOfTransactions) {
        boolean accessesForAccountsEmpty = this.isAccessForAccountReferencesEmpty(aspspAccountAccesses.getAccounts(), resourceId);
        boolean accessesForBalanceEmpty = this.isAccessForAccountReferencesEmpty(aspspAccountAccesses.getBalances(), resourceId);
        boolean accessesForTransactionsEmpty = this.isAccessForAccountReferencesEmpty(aspspAccountAccesses.getTransactions(), resourceId);
        if (!accessesForAccountsEmpty && accessesForBalanceEmpty && accessesForTransactionsEmpty) {
            return 1;
        }
        if (accessesForTransactionsEmpty) {
            return 2;
        }
        if (accessesForBalanceEmpty) {
            return 2 + numberOfTransactions;
        }
        return 3 + numberOfTransactions;
    }

    private boolean isAccessForAccountReferencesEmpty(List<AccountReference> accounts, String resourceId) {
        return accounts.stream().noneMatch(access -> access.getResourceId().equals(resourceId));
    }

    @ConstructorProperties(value={"aisConsentUsageRepository", "aisConsentTransactionRepository", "cmsAisConsentMapper"})
    public OneOffConsentExpirationService(AisConsentUsageRepository aisConsentUsageRepository, AisConsentTransactionRepository aisConsentTransactionRepository, CmsAisConsentMapper cmsAisConsentMapper) {
        this.aisConsentUsageRepository = aisConsentUsageRepository;
        this.aisConsentTransactionRepository = aisConsentTransactionRepository;
        this.cmsAisConsentMapper = cmsAisConsentMapper;
    }
}

