/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.consent.CmsCreateConsentResponse;
import de.adorsys.psd2.consent.api.service.ConsentService;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.AisConsentVerifyingRepository;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.TppInfoRepository;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.AisConsentUsageService;
import de.adorsys.psd2.consent.service.mapper.CmsConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.migration.AisConsentLazyMigrationService;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConsentServiceInternal
implements ConsentService {
    private static final Logger log = LoggerFactory.getLogger(ConsentServiceInternal.class);
    private final AuthorisationRepository authorisationRepository;
    private final ConsentJpaRepository consentJpaRepository;
    private final AisConsentVerifyingRepository aisConsentRepository;
    private final TppInfoRepository tppInfoRepository;
    private final PsuDataMapper psuDataMapper;
    private final AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService;
    private final CmsPsuService cmsPsuService;
    private final AisConsentUsageService aisConsentUsageService;
    private final CmsConsentMapper cmsConsentMapper;
    private final AisConsentLazyMigrationService aisConsentLazyMigrationService;
    private final AspspProfileService aspspProfileService;

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<CmsCreateConsentResponse> createConsent(CmsConsent cmsConsent) throws WrongChecksumException {
        if (cmsConsent.getFrequencyPerDay() == null) {
            log.info("TPP ID: [{}]. Consent cannot be created, because request contains no allowed frequency per day", (Object)cmsConsent.getTppInformation().getTppInfo().getAuthorisationNumber());
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        ConsentEntity consentEntityFromMapper = this.cmsConsentMapper.mapToNewConsentEntity(cmsConsent);
        ConsentEntity consent = this.adjustConsentEntity(consentEntityFromMapper, cmsConsent.getConsentType());
        this.tppInfoRepository.findByAuthorisationNumber(cmsConsent.getTppInformation().getTppInfo().getAuthorisationNumber()).ifPresent(tppInfo -> consent.getTppInformation().setTppInfo((TppInfoEntity)tppInfo));
        ConsentEntity savedConsent = this.aisConsentRepository.verifyAndSave(consent);
        if (savedConsent.getId() != null) {
            return CmsResponse.builder().payload((Object)new CmsCreateConsentResponse(savedConsent.getExternalId(), this.cmsConsentMapper.mapToCmsConsent(savedConsent, Collections.emptyList(), Collections.emptyMap()))).build();
        }
        log.info("TPP ID: [{}], External Consent ID: [{}]. Consent cannot be created, because when saving to DB got null ID", (Object)cmsConsent.getTppInformation().getTppInfo().getAuthorisationNumber(), (Object)savedConsent.getExternalId());
        return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
    }

    @Transactional
    public CmsResponse<ConsentStatus> getConsentStatusById(String consentId) {
        Optional<ConsentStatus> consentStatusOptional = this.consentJpaRepository.findByExternalId(consentId).map(this.aisConsentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).map(this::checkAndUpdateOnExpiration).map(ConsentEntity::getConsentStatus);
        if (consentStatusOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)consentStatusOptional.get()).build();
        }
        log.info("Consent ID: [{}]. Get consent status failed, because consent not found", (Object)consentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<Boolean> updateConsentStatusById(String consentId, ConsentStatus status) throws WrongChecksumException {
        Optional<ConsentEntity> consentOptional = this.getActualAisConsent(consentId);
        if (consentOptional.isPresent()) {
            ConsentEntity consent = consentOptional.get();
            boolean result = this.setStatusAndSaveConsent(consent, status);
            return CmsResponse.builder().payload((Object)result).build();
        }
        log.info("Consent ID [{}]. Update consent status by ID failed, because consent not found", (Object)consentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    @Transactional
    public CmsResponse<CmsConsent> getConsentById(String consentId) {
        Optional<ConsentEntity> consentEntityOptional = this.consentJpaRepository.findByExternalId(consentId).map(this.aisConsentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).map(this::checkAndUpdateOnExpiration);
        if (!consentEntityOptional.isPresent()) {
            log.info("Consent ID [{}]. Get consent by ID failed, couldn't find consent by its ID", (Object)consentId);
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        ConsentEntity consentEntity = consentEntityOptional.get();
        consentEntity = this.aisConsentLazyMigrationService.migrateIfNeeded(consentEntity);
        List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationType(consentEntity.getExternalId(), AuthorisationType.AIS);
        CmsConsent cmsConsent = this.cmsConsentMapper.mapToCmsConsent(consentEntity, authorisations, this.aisConsentUsageService.getUsageCounterMap(consentEntity));
        return CmsResponse.builder().payload((Object)cmsConsent).build();
    }

    @Transactional
    public CmsResponse<Boolean> findAndTerminateOldConsentsByNewConsentId(String newConsentId) {
        TppInfoEntity tppInfo;
        ConsentEntity newConsent = this.consentJpaRepository.findByExternalId(newConsentId).orElseThrow(() -> {
            log.info("Consent ID: [{}]. Cannot find consent by ID", (Object)newConsentId);
            return new IllegalArgumentException("Wrong consent ID: " + newConsentId);
        });
        if (newConsent.isOneAccessType()) {
            log.info("Consent ID: [{}]. Cannot find old consents, because consent is OneAccessType", (Object)newConsentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        if (newConsent.isWrongConsentData()) {
            log.info("Consent ID: [{}]. Find old consents failed, because consent PSU data list is empty or TPP Info is null", (Object)newConsentId);
            throw new IllegalArgumentException("Wrong consent data");
        }
        List<PsuData> psuDataList = newConsent.getPsuDataList();
        Set<String> psuIds = psuDataList.stream().filter(Objects::nonNull).map(PsuData::getPsuId).collect(Collectors.toSet());
        List<ConsentEntity> oldConsents = this.consentJpaRepository.findOldConsentsByNewConsentParams(psuIds, (tppInfo = newConsent.getTppInformation().getTppInfo()).getAuthorisationNumber(), newConsent.getInstanceId(), newConsent.getExternalId(), EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.PARTIALLY_AUTHORISED, ConsentStatus.VALID));
        List<ConsentEntity> oldConsentsWithExactPsuDataLists = oldConsents.stream().distinct().filter(c -> this.cmsPsuService.isPsuDataListEqual(c.getPsuDataList(), psuDataList)).collect(Collectors.toList());
        if (oldConsentsWithExactPsuDataLists.isEmpty()) {
            log.info("Consent ID: [{}]. Cannot find old consents, because consent hasn't exact PSU data lists as old consents", (Object)newConsentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        oldConsentsWithExactPsuDataLists.forEach(this::updateStatus);
        this.consentJpaRepository.saveAll(oldConsentsWithExactPsuDataLists);
        return CmsResponse.builder().payload((Object)true).build();
    }

    public CmsResponse<List<PsuIdData>> getPsuDataByConsentId(String consentId) {
        Optional<List> psuIdDataOptional = this.getActualAisConsent(consentId).map(ac -> this.psuDataMapper.mapToPsuIdDataList(ac.getPsuDataList()));
        if (psuIdDataOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)psuIdDataOptional.get()).build();
        }
        log.info("Consent ID [{}]. Get psu data by consent id failed, because consent not found", (Object)consentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<Boolean> updateMultilevelScaRequired(String consentId, boolean multilevelScaRequired) throws WrongChecksumException {
        Optional<ConsentEntity> aisConsentOptional = this.consentJpaRepository.findByExternalId(consentId);
        if (!aisConsentOptional.isPresent()) {
            log.info("Consent ID: [{}]. Get update multilevel SCA required status failed, because consent authorisation is not found", (Object)consentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        ConsentEntity consent = aisConsentOptional.get();
        consent.setMultilevelScaRequired(multilevelScaRequired);
        this.aisConsentRepository.verifyAndSave(consent);
        return CmsResponse.builder().payload((Object)true).build();
    }

    private ConsentEntity checkAndUpdateOnExpiration(ConsentEntity consent) {
        if (consent != null && consent.shouldConsentBeExpired()) {
            return this.aisConsentConfirmationExpirationService.expireConsent(consent);
        }
        return consent;
    }

    private Optional<ConsentEntity> getActualAisConsent(String consentId) {
        return this.consentJpaRepository.findByExternalId(consentId).filter(c -> !c.getConsentStatus().isFinalisedStatus());
    }

    private boolean setStatusAndSaveConsent(ConsentEntity consent, ConsentStatus status) throws WrongChecksumException {
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(status);
        ConsentEntity aisConsent = this.aisConsentRepository.verifyAndSave(consent);
        return Optional.ofNullable(aisConsent).isPresent();
    }

    private void updateStatus(ConsentEntity aisConsent) {
        aisConsent.setConsentStatus(aisConsent.getConsentStatus() == ConsentStatus.RECEIVED || aisConsent.getConsentStatus() == ConsentStatus.PARTIALLY_AUTHORISED ? ConsentStatus.REJECTED : ConsentStatus.TERMINATED_BY_TPP);
    }

    private ConsentEntity adjustConsentEntity(ConsentEntity consentEntity, ConsentType consentType) {
        if (ConsentType.AIS == consentType) {
            int lifetime = this.aspspProfileService.getAspspSettings().getAis().getConsentTypes().getMaxConsentValidityDays();
            consentEntity.setValidUntil(this.adjustValidUntilDate(consentEntity.getValidUntil(), lifetime));
        }
        return consentEntity;
    }

    private LocalDate adjustValidUntilDate(LocalDate date, int lifetime) {
        if (lifetime <= 0) {
            return date;
        }
        LocalDate lifeTimeDate = LocalDate.now().plusDays((long)lifetime - 1L);
        return lifeTimeDate.isBefore(date) ? lifeTimeDate : date;
    }

    @ConstructorProperties(value={"authorisationRepository", "consentJpaRepository", "aisConsentRepository", "tppInfoRepository", "psuDataMapper", "aisConsentConfirmationExpirationService", "cmsPsuService", "aisConsentUsageService", "cmsConsentMapper", "aisConsentLazyMigrationService", "aspspProfileService"})
    public ConsentServiceInternal(AuthorisationRepository authorisationRepository, ConsentJpaRepository consentJpaRepository, AisConsentVerifyingRepository aisConsentRepository, TppInfoRepository tppInfoRepository, PsuDataMapper psuDataMapper, AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService, CmsPsuService cmsPsuService, AisConsentUsageService aisConsentUsageService, CmsConsentMapper cmsConsentMapper, AisConsentLazyMigrationService aisConsentLazyMigrationService, AspspProfileService aspspProfileService) {
        this.authorisationRepository = authorisationRepository;
        this.consentJpaRepository = consentJpaRepository;
        this.aisConsentRepository = aisConsentRepository;
        this.tppInfoRepository = tppInfoRepository;
        this.psuDataMapper = psuDataMapper;
        this.aisConsentConfirmationExpirationService = aisConsentConfirmationExpirationService;
        this.cmsPsuService = cmsPsuService;
        this.aisConsentUsageService = aisConsentUsageService;
        this.cmsConsentMapper = cmsConsentMapper;
        this.aisConsentLazyMigrationService = aisConsentLazyMigrationService;
        this.aspspProfileService = aspspProfileService;
    }
}

