/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.repository.specification.CommonSpecification;
import de.adorsys.psd2.consent.repository.specification.EntityAttributeSpecificationProvider;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.criteria.Join;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class PisCommonPaymentDataSpecification {
    private final CommonSpecification<PisCommonPaymentData> commonSpecification;

    public Specification<PisCommonPaymentData> byPaymentId(String paymentId) {
        return Specification.where(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("paymentId", paymentId));
    }

    public Specification<PisCommonPaymentData> byPaymentIdAndInstanceId(String paymentId, String instanceId) {
        return Specification.where(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("paymentId", paymentId)).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("instanceId", instanceId));
    }

    public Specification<PisCommonPaymentData> byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(@NotNull String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @Nullable String instanceId) {
        return Specification.where(this.byTppAuthorisationNumber(tppAuthorisationNumber)).and(this.commonSpecification.byCreationTimestamp(createDateFrom, createDateTo)).and(this.commonSpecification.byPsuIdDataInList(psuIdData)).and(this.commonSpecification.byInstanceId(instanceId));
    }

    public Specification<PisCommonPaymentData> byPsuIdDataAndCreationPeriodAndInstanceId(@NotNull PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return this.commonSpecification.byPsuIdDataAndCreationPeriodAndInstanceId(psuIdData, createDateFrom, createDateTo, instanceId);
    }

    public Specification<PisCommonPaymentData> byAspspAccountIdAndCreationPeriodAndInstanceId(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return Specification.where(this.byAspspAccountId(aspspAccountId)).and(this.commonSpecification.byCreationTimestamp(createDateFrom, createDateTo)).and(this.commonSpecification.byInstanceId(instanceId));
    }

    private Specification<PisCommonPaymentData> byAspspAccountId(@Nullable String aspspAccountId) {
        return EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("aspspAccountId", aspspAccountId);
    }

    private Specification<PisCommonPaymentData> byTppAuthorisationNumber(@Nullable String tppAuthorisationNumber) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join tppInfoJoin = root.join("tppInfo");
            return EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(tppInfoJoin, "authorisationNumber", tppAuthorisationNumber).toPredicate(root, query, cb);
        };
    }

    @ConstructorProperties(value={"commonSpecification"})
    public PisCommonPaymentDataSpecification(CommonSpecification<PisCommonPaymentData> commonSpecification) {
        this.commonSpecification = commonSpecification;
    }
}

