/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountConsentAuthorisation;
import de.adorsys.psd2.consent.api.ais.CmsAisAccountConsent;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentTppInformationEntity;
import de.adorsys.psd2.consent.service.AisConsentUsageService;
import de.adorsys.psd2.consent.service.mapper.AccessMapper;
import de.adorsys.psd2.consent.service.mapper.AuthorisationTemplateMapper;
import de.adorsys.psd2.consent.service.mapper.ConsentTppInformationMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.authorisation.AccountConsentAuthorization;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.springframework.stereotype.Component;

@Component
public class AisConsentMapper {
    private final PsuDataMapper psuDataMapper;
    private final TppInfoMapper tppInfoMapper;
    private final AisConsentUsageService aisConsentUsageService;
    private final AuthorisationTemplateMapper authorisationTemplateMapper;
    private final ConsentDataMapper consentDataMapper;
    private final ConsentTppInformationMapper consentTppInformationMapper;
    private final AccessMapper accessMapper;

    private AisAccountAccess getAvailableAccess(AisConsent aisConsent) {
        AisAccountAccess tppAccountAccess = this.mapToAisAccountAccess(aisConsent);
        AisAccountAccess aspspAccountAccess = this.mapToAspspAisAccountAccess(aisConsent);
        if (tppAccountAccess.getAllPsd2() != null || !aspspAccountAccess.isNotEmpty()) {
            return tppAccountAccess;
        }
        return aspspAccountAccess;
    }

    public CmsAisAccountConsent mapToCmsAisAccountConsent(ConsentEntity consent, List<AuthorisationEntity> authorisations) {
        AisConsent aisConsent = this.mapToAisConsent(consent, authorisations);
        AisAccountAccess chosenAccess = this.getAvailableAccess(aisConsent);
        ConsentTppInformationEntity tppInformation = consent.getTppInformation();
        return new CmsAisAccountConsent(consent.getExternalId(), chosenAccess, consent.isRecurringIndicator(), consent.getValidUntil(), consent.getExpireDate(), consent.getFrequencyPerDay(), consent.getLastActionDate(), consent.getConsentStatus(), aisConsent.isWithBalance(), tppInformation.isTppRedirectPreferred(), aisConsent.getConsentRequestType(), aisConsent.getPsuIdDataList(), this.tppInfoMapper.mapToTppInfo(tppInformation.getTppInfo()), aisConsent.getAuthorisationTemplate(), consent.isMultilevelScaRequired(), this.mapToAisAccountConsentAuthorisation(authorisations), aisConsent.getUsageCounterMap(), consent.getCreationTimestamp(), consent.getStatusChangeTimestamp(), tppInformation.getTppBrandLoggingInformation());
    }

    public AisConsent mapToAisConsent(ConsentEntity entity, List<AuthorisationEntity> authorisations) {
        AisConsentData aisConsentData = this.consentDataMapper.mapToAisConsentData(entity.getData());
        Map<String, Integer> usageCounterMap = this.aisConsentUsageService.getUsageCounterMap(entity);
        return new AisConsent(aisConsentData, entity.getExternalId(), entity.getInternalRequestId(), entity.getConsentStatus(), Integer.valueOf(entity.getFrequencyPerDay()), entity.isRecurringIndicator(), entity.isMultilevelScaRequired(), entity.getValidUntil(), entity.getExpireDate(), entity.getLastActionDate(), entity.getCreationTimestamp(), entity.getStatusChangeTimestamp(), this.consentTppInformationMapper.mapToConsentTppInformation(entity.getTppInformation()), this.authorisationTemplateMapper.mapToAuthorisationTemplate(entity.getAuthorisationTemplate()), this.psuDataMapper.mapToPsuIdDataList(entity.getPsuDataList()), this.mapToAccountConsentAuthorisations(authorisations), usageCounterMap, this.accessMapper.mapTppAccessesToAccountAccess(entity.getTppAccountAccesses(), entity.getOwnerNameType()), this.accessMapper.mapAspspAccessesToAccountAccess(entity.getAspspAccountAccesses(), entity.getOwnerNameType()));
    }

    public AccountAccess mapToAccountAccess(AisAccountAccess accountAccess) {
        return new AccountAccess(ListUtils.emptyIfNull((List)accountAccess.getAccounts()), ListUtils.emptyIfNull((List)accountAccess.getBalances()), ListUtils.emptyIfNull((List)accountAccess.getTransactions()), accountAccess.getAccountAdditionalInformationAccess());
    }

    private AisAccountAccess mapToAisAccountAccess(AisConsent aisConsent) {
        AccountAccess tppAccesses = aisConsent.getTppAccountAccesses();
        AisConsentData consentData = (AisConsentData)aisConsent.getConsentData();
        return new AisAccountAccess(tppAccesses.getAccounts(), tppAccesses.getBalances(), tppAccesses.getTransactions(), this.getAccessType(consentData.getAvailableAccounts()), this.getAccessType(consentData.getAllPsd2()), this.getAccessType(consentData.getAvailableAccountsWithBalance()), tppAccesses.getAdditionalInformationAccess());
    }

    private AisAccountAccess mapToAspspAisAccountAccess(AisConsent aisConsent) {
        AccountAccess aspspAccesses = aisConsent.getAspspAccountAccesses();
        AisConsentData consentData = (AisConsentData)aisConsent.getConsentData();
        return new AisAccountAccess(aspspAccesses.getAccounts(), aspspAccesses.getBalances(), aspspAccesses.getTransactions(), this.getAccessType(consentData.getAvailableAccounts()), this.getAccessType(consentData.getAllPsd2()), this.getAccessType(consentData.getAvailableAccountsWithBalance()), aspspAccesses.getAdditionalInformationAccess());
    }

    private String getAccessType(AccountAccessType type) {
        return Optional.ofNullable(type).map(Enum::name).orElse(null);
    }

    private List<AisAccountConsentAuthorisation> mapToAisAccountConsentAuthorisation(List<AuthorisationEntity> aisConsentAuthorisations) {
        if (CollectionUtils.isEmpty(aisConsentAuthorisations)) {
            return Collections.emptyList();
        }
        return aisConsentAuthorisations.stream().map(this::mapToAisAccountConsentAuthorisation).collect(Collectors.toList());
    }

    private List<AccountConsentAuthorization> mapToAccountConsentAuthorisations(List<AuthorisationEntity> aisConsentAuthorisations) {
        if (CollectionUtils.isEmpty(aisConsentAuthorisations)) {
            return Collections.emptyList();
        }
        return aisConsentAuthorisations.stream().map(this::mapToAccountConsentAuthorisation).collect(Collectors.toList());
    }

    private AisAccountConsentAuthorisation mapToAisAccountConsentAuthorisation(AuthorisationEntity aisConsentAuthorisation) {
        return Optional.ofNullable(aisConsentAuthorisation).map(auth -> new AisAccountConsentAuthorisation(auth.getExternalId(), this.psuDataMapper.mapToPsuIdData(auth.getPsuData()), auth.getScaStatus())).orElse(null);
    }

    private AccountConsentAuthorization mapToAccountConsentAuthorisation(AuthorisationEntity aisConsentAuthorisation) {
        return Optional.ofNullable(aisConsentAuthorisation).map(auth -> {
            AccountConsentAuthorization authorisation = new AccountConsentAuthorization();
            authorisation.setId(auth.getExternalId());
            authorisation.setConsentId(auth.getParentExternalId());
            authorisation.setPsuIdData(this.psuDataMapper.mapToPsuIdData(auth.getPsuData()));
            authorisation.setScaStatus(auth.getScaStatus());
            authorisation.setPassword(null);
            authorisation.setChosenScaApproach(auth.getScaApproach());
            authorisation.setAuthenticationMethodId(auth.getAuthenticationMethodId());
            authorisation.setScaAuthenticationData(auth.getScaAuthenticationData());
            return authorisation;
        }).orElse(null);
    }

    @ConstructorProperties(value={"psuDataMapper", "tppInfoMapper", "aisConsentUsageService", "authorisationTemplateMapper", "consentDataMapper", "consentTppInformationMapper", "accessMapper"})
    public AisConsentMapper(PsuDataMapper psuDataMapper, TppInfoMapper tppInfoMapper, AisConsentUsageService aisConsentUsageService, AuthorisationTemplateMapper authorisationTemplateMapper, ConsentDataMapper consentDataMapper, ConsentTppInformationMapper consentTppInformationMapper, AccessMapper accessMapper) {
        this.psuDataMapper = psuDataMapper;
        this.tppInfoMapper = tppInfoMapper;
        this.aisConsentUsageService = aisConsentUsageService;
        this.authorisationTemplateMapper = authorisationTemplateMapper;
        this.consentDataMapper = consentDataMapper;
        this.consentTppInformationMapper = consentTppInformationMapper;
        this.accessMapper = accessMapper;
    }
}

