/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.AccountInfo;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.consent.api.ais.AccountAdditionalInformationAccess;
import de.adorsys.psd2.consent.api.ais.AdditionalAccountInformationType;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.domain.account.TppAccountAccess;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class AccessMapper {
    public AccountAccess mapTppAccessesToAccountAccess(List<TppAccountAccess> tppAccountAccesses, AdditionalAccountInformationType additionalAccountInformationType) {
        AccountAccessListHolder holder = new AccountAccessListHolder();
        tppAccountAccesses.forEach(a -> {
            AccountReference accountReference = new AccountReference(a.getAccountReferenceType(), a.getAccountIdentifier(), a.getCurrency());
            holder.addAccountReference(accountReference, a.getTypeAccess());
        });
        return new AccountAccess(holder.getAccounts(), holder.getBalances(), holder.getTransactions(), new AdditionalInformationAccess(additionalAccountInformationType.getReferencesByType(holder.getOwnerNames())));
    }

    public AccountAccess mapAspspAccessesToAccountAccess(List<AspspAccountAccess> aspspAccountAccesses, AdditionalAccountInformationType additionalAccountInformationType) {
        AccountAccessListHolder holder = new AccountAccessListHolder();
        aspspAccountAccesses.forEach(a -> {
            AccountReference accountReference = new AccountReference(a.getAccountReferenceType(), a.getAccountIdentifier(), a.getCurrency(), a.getResourceId(), a.getAspspAccountId());
            holder.addAccountReference(accountReference, a.getTypeAccess());
        });
        return new AccountAccess(holder.getAccounts(), holder.getBalances(), holder.getTransactions(), new AdditionalInformationAccess(additionalAccountInformationType.getReferencesByType(holder.getOwnerNames())));
    }

    public List<TppAccountAccess> mapToTppAccountAccess(AccountAccess accountAccess) {
        ArrayList<TppAccountAccess> tppAccountAccesses = new ArrayList<TppAccountAccess>();
        tppAccountAccesses.addAll(accountAccess.getAccounts().stream().map(a -> new TppAccountAccess(a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.ACCOUNT, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency())).collect(Collectors.toList()));
        tppAccountAccesses.addAll(accountAccess.getBalances().stream().map(a -> new TppAccountAccess(a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.BALANCE, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency())).collect(Collectors.toList()));
        tppAccountAccesses.addAll(accountAccess.getTransactions().stream().map(a -> new TppAccountAccess(a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.TRANSACTION, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency())).collect(Collectors.toList()));
        AdditionalInformationAccess additionalInformationAccess = accountAccess.getAdditionalInformationAccess();
        if (additionalInformationAccess != null && CollectionUtils.isNotEmpty((Collection)additionalInformationAccess.getOwnerName())) {
            tppAccountAccesses.addAll(additionalInformationAccess.getOwnerName().stream().map(a -> new TppAccountAccess(a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.OWNER_NAME, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency())).collect(Collectors.toList()));
        }
        return tppAccountAccesses;
    }

    public List<AspspAccountAccess> mapToAspspAccountAccess(AccountAccess accountAccess) {
        ArrayList<AspspAccountAccess> aspspAccountAccesses = new ArrayList<AspspAccountAccess>();
        aspspAccountAccesses.addAll(accountAccess.getAccounts().stream().map(a -> new AspspAccountAccess(a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.ACCOUNT, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency(), a.getResourceId(), a.getAspspAccountId())).collect(Collectors.toList()));
        aspspAccountAccesses.addAll(accountAccess.getBalances().stream().map(a -> new AspspAccountAccess(a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.BALANCE, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency(), a.getResourceId(), a.getAspspAccountId())).collect(Collectors.toList()));
        aspspAccountAccesses.addAll(accountAccess.getTransactions().stream().map(a -> new AspspAccountAccess(a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.TRANSACTION, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency(), a.getResourceId(), a.getAspspAccountId())).collect(Collectors.toList()));
        AdditionalInformationAccess additionalInformationAccess = accountAccess.getAdditionalInformationAccess();
        if (additionalInformationAccess != null && CollectionUtils.isNotEmpty((Collection)additionalInformationAccess.getOwnerName())) {
            aspspAccountAccesses.addAll(additionalInformationAccess.getOwnerName().stream().map(a -> new AspspAccountAccess(a.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.OWNER_NAME, a.getUsedAccountReferenceSelector().getAccountReferenceType(), a.getCurrency(), a.getResourceId(), a.getAspspAccountId())).collect(Collectors.toList()));
        }
        return aspspAccountAccesses;
    }

    public AccountAccess mapToAccountAccess(AisAccountAccessInfo aisAccountAccessInfo) {
        Set<AccountReference> accounts = this.mapToAccountReferences(aisAccountAccessInfo.getAccounts());
        Set<AccountReference> balances = this.mapToAccountReferences(aisAccountAccessInfo.getBalances());
        Set<AccountReference> transactions = this.mapToAccountReferences(aisAccountAccessInfo.getTransactions());
        Set<AccountReference> allAccounts = this.addReferencesToAccounts(accounts, balances, transactions);
        return new AccountAccess(new ArrayList<AccountReference>(allAccounts), new ArrayList<AccountReference>(balances), new ArrayList<AccountReference>(transactions), this.mapToAdditionalInformationAccess(aisAccountAccessInfo.getAccountAdditionalInformationAccess()));
    }

    public AspspAccountAccess mapToAspspAccountAccess(AccountReference accountReference) {
        return new AspspAccountAccess(accountReference.getUsedAccountReferenceSelector().getAccountValue(), TypeAccess.ACCOUNT, accountReference.getUsedAccountReferenceSelector().getAccountReferenceType(), accountReference.getCurrency(), accountReference.getResourceId(), accountReference.getAspspAccountId());
    }

    public AccountReference mapToAccountReference(AspspAccountAccess aspspAccountAccess) {
        return new AccountReference(aspspAccountAccess.getAccountReferenceType(), aspspAccountAccess.getAccountIdentifier(), aspspAccountAccess.getCurrency(), aspspAccountAccess.getResourceId(), aspspAccountAccess.getAspspAccountId());
    }

    private AdditionalInformationAccess mapToAdditionalInformationAccess(AccountAdditionalInformationAccess accountAdditionalInformationAccess) {
        if (accountAdditionalInformationAccess == null) {
            return null;
        }
        List ownerNameAccountInfo = accountAdditionalInformationAccess.getOwnerName();
        if (ownerNameAccountInfo == null) {
            return new AdditionalInformationAccess(null);
        }
        List ownerNameAccountReferences = ownerNameAccountInfo.stream().map(this::mapToAccountReference).collect(Collectors.toList());
        return new AdditionalInformationAccess(ownerNameAccountReferences);
    }

    private Set<AccountReference> mapToAccountReferences(@NotNull List<AccountInfo> accountInfoList) {
        return accountInfoList.stream().map(this::mapToAccountReference).collect(Collectors.toSet());
    }

    private AccountReference mapToAccountReference(AccountInfo accountInfo) {
        return new AccountReference(accountInfo.getAccountType(), accountInfo.getAccountIdentifier(), this.getCurrencyByString(accountInfo.getCurrency()), accountInfo.getResourceId(), accountInfo.getAspspAccountId());
    }

    private Currency getCurrencyByString(String currency) {
        return Optional.ofNullable(currency).map(Currency::getInstance).orElse(null);
    }

    private Set<AccountReference> addReferencesToAccounts(Set<AccountReference> accounts, Set<AccountReference> balances, Set<AccountReference> transactions) {
        return Stream.of(accounts, balances, transactions).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static class AccountAccessListHolder {
        List<AccountReference> accounts = new ArrayList<AccountReference>();
        List<AccountReference> balances = new ArrayList<AccountReference>();
        List<AccountReference> transactions = new ArrayList<AccountReference>();
        List<AccountReference> ownerNames = new ArrayList<AccountReference>();

        private AccountAccessListHolder() {
        }

        void addAccountReference(AccountReference accountReference, TypeAccess typeAccess) {
            if (TypeAccess.ACCOUNT == typeAccess) {
                this.accounts.add(accountReference);
            } else if (TypeAccess.BALANCE == typeAccess) {
                this.balances.add(accountReference);
            } else if (TypeAccess.TRANSACTION == typeAccess) {
                this.transactions.add(accountReference);
            } else if (TypeAccess.OWNER_NAME == typeAccess) {
                this.ownerNames.add(accountReference);
            }
        }

        public List<AccountReference> getAccounts() {
            return this.accounts;
        }

        public List<AccountReference> getBalances() {
            return this.balances;
        }

        public List<AccountReference> getTransactions() {
            return this.transactions;
        }

        public List<AccountReference> getOwnerNames() {
            return this.ownerNames;
        }
    }
}

