/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.aspsp.api.pis.AspspPaymentService;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.service.CommonPaymentDataService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AspspPaymentServiceInternal
implements AspspPaymentService {
    private static final Logger log = LoggerFactory.getLogger(AspspPaymentServiceInternal.class);
    private final CommonPaymentDataService commonPaymentDataService;

    @Transactional
    public boolean updatePaymentStatus(@NotNull String paymentId, @NotNull TransactionStatus status, @NotNull String instanceId) {
        Optional<PisCommonPaymentData> paymentDataOptional = this.commonPaymentDataService.getPisCommonPaymentData(paymentId, instanceId);
        return paymentDataOptional.map(pd -> this.commonPaymentDataService.updateStatusInPaymentData((PisCommonPaymentData)pd, status)).orElseGet(() -> {
            log.info("Payment ID [{}], Instance ID: [{}]. Update payment status failed, because PIS common payment data not found", (Object)paymentId, (Object)instanceId);
            return false;
        });
    }

    @ConstructorProperties(value={"commonPaymentDataService"})
    public AspspPaymentServiceInternal(CommonPaymentDataService commonPaymentDataService) {
        this.commonPaymentDataService = commonPaymentDataService;
    }
}

