/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.authorisation.AuthorisationParentHolder;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.api.service.AuthorisationService;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.ScaMethod;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.service.authorisation.AuthService;
import de.adorsys.psd2.consent.service.authorisation.AuthServiceResolver;
import de.adorsys.psd2.consent.service.authorisation.AuthorisationClosingService;
import de.adorsys.psd2.consent.service.mapper.AuthorisationMapper;
import de.adorsys.psd2.consent.service.mapper.ScaMethodMapper;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthorisationServiceInternal
implements AuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationServiceInternal.class);
    private final AuthorisationRepository authorisationRepository;
    private final ScaMethodMapper scaMethodMapper;
    private final AuthorisationMapper authorisationMapper;
    private final AuthServiceResolver authServiceResolver;
    private final AuthorisationClosingService authorisationClosingService;

    @Transactional
    public CmsResponse<CreateAuthorisationResponse> createAuthorisation(AuthorisationParentHolder parentHolder, CreateAuthorisationRequest request) {
        String parentId = parentHolder.getParentId();
        AuthorisationType authorisationType = parentHolder.getAuthorisationType();
        AuthService authService = this.authServiceResolver.getAuthService(authorisationType);
        Optional<Authorisable> paymentOptional = authService.getNotFinalisedAuthorisationParent(parentId);
        if (!paymentOptional.isPresent()) {
            log.info("Authorisation type: [{}], Parent ID: [{}]. Create authorisation has failed, because authorisation's parent couldn't be found", (Object)authorisationType, (Object)parentId);
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        this.authorisationClosingService.closePreviousAuthorisationsByParent(parentId, authorisationType, request.getPsuData());
        Authorisable authorisationParent = paymentOptional.get();
        AuthorisationEntity newAuthorisation = authService.saveAuthorisation(request, authorisationParent);
        CreateAuthorisationResponse response = new CreateAuthorisationResponse(newAuthorisation.getExternalId(), newAuthorisation.getScaStatus(), authorisationParent.getInternalRequestId(authorisationType), request.getPsuData());
        return CmsResponse.builder().payload((Object)response).build();
    }

    @Transactional(readOnly=true)
    public CmsResponse<Authorisation> getAuthorisationById(String authorisationId) {
        Optional<AuthorisationEntity> authorisationOptional = this.getAuthorisation(authorisationId);
        if (!authorisationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Get authorisation has failed, because authorisation could not found", (Object)authorisationId);
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        AuthorisationEntity authorisation = authorisationOptional.get();
        return CmsResponse.builder().payload((Object)this.authorisationMapper.mapToAuthorisation(authorisation)).build();
    }

    @Transactional
    public CmsResponse<Authorisation> updateAuthorisation(String authorisationId, UpdateAuthorisationRequest request) {
        Optional<AuthorisationEntity> authorisationOptional = this.getAuthorisation(authorisationId);
        if (!authorisationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Update authorisation has failed, because authorisation couldn't be found", (Object)authorisationId);
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        AuthorisationEntity authorisation = authorisationOptional.get();
        PsuIdData psuDataFromRequest = request.getPsuData();
        this.authorisationClosingService.closePreviousAuthorisationsByAuthorisation(authorisation, psuDataFromRequest);
        if (authorisation.getScaStatus().isFinalisedStatus()) {
            log.info("Authorisation ID: [{}], SCA status: [{}]. Update authorisation has failed, because authorisation has finalised status", (Object)authorisationId, (Object)authorisation.getScaStatus().getValue());
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        AuthorisationEntity updatedAuthorisation = this.authServiceResolver.getAuthService(request.getAuthorisationType()).doUpdateAuthorisation(authorisation, request);
        return CmsResponse.builder().payload((Object)this.authorisationMapper.mapToAuthorisation(updatedAuthorisation)).build();
    }

    @Transactional
    public CmsResponse<Boolean> updateAuthorisationStatus(String authorisationId, ScaStatus scaStatus) {
        Optional<AuthorisationEntity> authorisationOptional = this.getAuthorisation(authorisationId);
        if (!authorisationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Update authorisation status has failed, because authorisation couldn't be found by id", (Object)authorisationId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        AuthorisationEntity authorisationEntity = authorisationOptional.get();
        authorisationEntity.setScaStatus(scaStatus);
        this.authorisationRepository.save(authorisationEntity);
        return CmsResponse.builder().payload((Object)true).build();
    }

    @Transactional
    public CmsResponse<List<String>> getAuthorisationsByParentId(AuthorisationParentHolder parentHolder) {
        AuthService authService = this.authServiceResolver.getAuthService(parentHolder.getAuthorisationType());
        Optional<Authorisable> authorisationParentOptional = authService.getAuthorisationParent(parentHolder.getParentId());
        if (!authorisationParentOptional.isPresent()) {
            log.info("Parent ID: [{}]. Get the list of authorisation IDs has failed, because parent couldn't be found", (Object)parentHolder.getParentId());
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        Authorisable authorisationParent = authorisationParentOptional.get();
        Authorisable checkedParent = authService.checkAndUpdateOnConfirmationExpiration(authorisationParent);
        List<AuthorisationEntity> authorisations = authService.getAuthorisationsByParentId(checkedParent.getExternalId());
        List authorisationIds = authorisations.stream().map(AuthorisationEntity::getExternalId).collect(Collectors.toList());
        return CmsResponse.builder().payload(authorisationIds).build();
    }

    @Transactional
    public CmsResponse<ScaStatus> getAuthorisationScaStatus(String authorisationId, AuthorisationParentHolder parentHolder) {
        AuthService authService = this.authServiceResolver.getAuthService(parentHolder.getAuthorisationType());
        Optional<Authorisable> parentOptional = authService.getAuthorisationParent(parentHolder.getParentId());
        if (!parentOptional.isPresent()) {
            log.info("Parent ID: [{}], Authorisation ID: [{}]. Get authorisation SCA status has failed, because parent couldn't be found", (Object)parentHolder.getParentId(), (Object)authorisationId);
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        Authorisable parent = parentOptional.get();
        if (authService.isConfirmationExpired(parent)) {
            authService.updateOnConfirmationExpiration(parent);
            log.info("Parent ID: [{}], Authorisation ID: [{}]. Get authorisation SCA status has failed, because parent is expired", (Object)parentHolder.getParentId(), (Object)authorisationId);
            return CmsResponse.builder().payload((Object)ScaStatus.FAILED).build();
        }
        Optional<AuthorisationEntity> authorisation = this.findAuthorisationInParent(authorisationId, parentHolder.getAuthorisationType(), parent);
        if (authorisation.isPresent()) {
            return CmsResponse.builder().payload((Object)authorisation.get().getScaStatus()).build();
        }
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    @Transactional(readOnly=true)
    public CmsResponse<Boolean> isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        Optional<AuthorisationEntity> authorisationOptional = this.getAuthorisation(authorisationId);
        Optional<Boolean> isDecoupledOptional = authorisationOptional.map(a -> a.getAvailableScaMethods().stream().filter(m -> Objects.equals(m.getAuthenticationMethodId(), authenticationMethodId)).anyMatch(ScaMethod::isDecoupled));
        if (isDecoupledOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)isDecoupledOptional.get()).build();
        }
        log.info("Authorisation ID: [{}]. Check whether authentication method is decoupled has failed, because authorisation with such method couldn't be found", (Object)authorisationId);
        return CmsResponse.builder().payload((Object)false).build();
    }

    @Transactional
    public CmsResponse<Boolean> saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        Optional<AuthorisationEntity> authorisationOptional = this.getAuthorisation(authorisationId);
        if (!authorisationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Save authentication methods has failed, because authorisation couldn't be found", (Object)authorisationId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        AuthorisationEntity authorisation = authorisationOptional.get();
        authorisation.setAvailableScaMethods(this.scaMethodMapper.mapToScaMethods(methods));
        this.authorisationRepository.save(authorisation);
        return CmsResponse.builder().payload((Object)true).build();
    }

    @Transactional
    public CmsResponse<Boolean> updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        Optional<AuthorisationEntity> authorisationOptional = this.getAuthorisation(authorisationId);
        if (!authorisationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Update SCA approach has failed, because authorisation couldn't be found", (Object)authorisationId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        AuthorisationEntity authorisation = authorisationOptional.get();
        authorisation.setScaApproach(scaApproach);
        this.authorisationRepository.save(authorisation);
        return CmsResponse.builder().payload((Object)true).build();
    }

    @Transactional(readOnly=true)
    public CmsResponse<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId) {
        Optional<AuthorisationScaApproachResponse> approachResponseOptional = this.authorisationRepository.findByExternalId(authorisationId).map(a -> new AuthorisationScaApproachResponse(a.getScaApproach()));
        if (approachResponseOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)approachResponseOptional.get()).build();
        }
        log.info("Authorisation ID: [{}]. Get SCA approach has failed, because authorisation couldn't be found", (Object)authorisationId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    private Optional<AuthorisationEntity> findAuthorisationInParent(String authorisationId, AuthorisationType authorisationType, Authorisable parent) {
        AuthService authService = this.authServiceResolver.getAuthService(authorisationType);
        return authService.getAuthorisationById(authorisationId).filter(a -> a.getParentExternalId().equals(parent.getExternalId()));
    }

    private Optional<AuthorisationEntity> getAuthorisation(String authorisationId) {
        return this.authorisationRepository.findByExternalId(authorisationId);
    }

    @ConstructorProperties(value={"authorisationRepository", "scaMethodMapper", "authorisationMapper", "authServiceResolver", "authorisationClosingService"})
    public AuthorisationServiceInternal(AuthorisationRepository authorisationRepository, ScaMethodMapper scaMethodMapper, AuthorisationMapper authorisationMapper, AuthServiceResolver authServiceResolver, AuthorisationClosingService authorisationClosingService) {
        this.authorisationRepository = authorisationRepository;
        this.scaMethodMapper = scaMethodMapper;
        this.authorisationMapper = authorisationMapper;
        this.authServiceResolver = authServiceResolver;
        this.authorisationClosingService = authorisationClosingService;
    }
}

