/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.account;

import de.adorsys.psd2.consent.api.AccountInfo;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.consent.api.ais.AccountAdditionalInformationAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.domain.account.AccountAccess;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public abstract class AccountAccessHolder<T extends AccountAccess> {
    protected Set<T> accountAccesses = new HashSet<T>();
    private AisAccountAccessInfo accountAccessInfo;

    public AccountAccessHolder(AisAccountAccessInfo accountAccessInfo) {
        this.accountAccessInfo = accountAccessInfo;
        this.fillAccess(this.accountAccessInfo);
    }

    private void fillAccess(AisAccountAccessInfo accountAccessInfo) {
        this.doFillAccess(accountAccessInfo.getAccounts(), TypeAccess.ACCOUNT);
        this.doFillAccess(accountAccessInfo.getBalances(), TypeAccess.BALANCE);
        this.doFillAccess(accountAccessInfo.getTransactions(), TypeAccess.TRANSACTION);
        AccountAdditionalInformationAccess accountAdditionalInformationAccess = accountAccessInfo.getAccountAdditionalInformationAccess();
        if (accountAdditionalInformationAccess != null) {
            this.doFillAccess(accountAdditionalInformationAccess.getOwnerName(), TypeAccess.OWNER_NAME);
        }
    }

    protected abstract void doFillAccess(List<AccountInfo> var1, TypeAccess var2);

    protected Currency getCurrencyByString(String currency) {
        return Optional.ofNullable(currency).map(Currency::getInstance).orElse(null);
    }

    public Set<T> getAccountAccesses() {
        return this.accountAccesses;
    }

    public AisAccountAccessInfo getAccountAccessInfo() {
        return this.accountAccessInfo;
    }
}

