/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.consent.CmsCreateConsentResponse;
import de.adorsys.psd2.consent.api.service.ConsentService;
import de.adorsys.psd2.consent.api.service.ConsentServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConsentServiceInternalEncrypted
implements ConsentServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(ConsentServiceInternalEncrypted.class);
    private final SecurityDataService securityDataService;
    private final ConsentService consentService;

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<CmsCreateConsentResponse> createConsent(CmsConsent request) throws WrongChecksumException {
        CmsResponse serviceResponse = this.consentService.createConsent(request);
        if (serviceResponse.hasError()) {
            return serviceResponse;
        }
        CmsCreateConsentResponse cmsCreateConsentResponse = (CmsCreateConsentResponse)serviceResponse.getPayload();
        Optional<String> encryptIdOptional = this.securityDataService.encryptId(cmsCreateConsentResponse.getConsentId());
        if (!encryptIdOptional.isPresent()) {
            log.info("Consent ID: [{}]. Create consent failed, couldn't encrypt consent id", (Object)cmsCreateConsentResponse.getConsentId());
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return CmsResponse.builder().payload((Object)new CmsCreateConsentResponse(encryptIdOptional.get(), cmsCreateConsentResponse.getCmsConsent())).build();
    }

    @Transactional
    public CmsResponse<ConsentStatus> getConsentStatusById(String encryptedConsentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Get consent status by id failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.consentService.getConsentStatusById(decryptIdOptional.get());
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<Boolean> updateConsentStatusById(String encryptedConsentId, ConsentStatus status) throws WrongChecksumException {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Update consent by id failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.consentService.updateConsentStatusById(decryptIdOptional.get(), status);
    }

    @Transactional
    public CmsResponse<CmsConsent> getConsentById(String encryptedConsentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Get consent by id failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.consentService.getConsentById(decryptIdOptional.get());
    }

    @Transactional
    public CmsResponse<Boolean> findAndTerminateOldConsentsByNewConsentId(String encryptedNewConsentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedNewConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Terminate consent by id failed, couldn't decrypt consent id", (Object)encryptedNewConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.consentService.findAndTerminateOldConsentsByNewConsentId(decryptIdOptional.get());
    }

    public CmsResponse<List<PsuIdData>> getPsuDataByConsentId(String encryptedConsentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Get psu data by consent id failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.consentService.getPsuDataByConsentId(decryptIdOptional.get());
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<Boolean> updateMultilevelScaRequired(String encryptedConsentId, boolean multilevelScaRequired) throws WrongChecksumException {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Update MultilevelScaRequired failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.consentService.updateMultilevelScaRequired(decryptIdOptional.get(), multilevelScaRequired);
    }

    @ConstructorProperties(value={"securityDataService", "consentService"})
    public ConsentServiceInternalEncrypted(SecurityDataService securityDataService, ConsentService consentService) {
        this.securityDataService = securityDataService;
        this.consentService = consentService;
    }
}

