/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.piis.CmsPiisConsent;
import de.adorsys.psd2.consent.aspsp.api.piis.CreatePiisConsentRequest;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.service.mapper.AccessMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.core.data.piis.v1.PiisConsentData;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.piis.PiisConsentTppAccessType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PiisConsentMapper {
    private final PsuDataMapper psuDataMapper;
    private final ConsentDataMapper consentDataMapper;
    private final AccessMapper accessMapper;

    public List<CmsPiisConsent> mapToCmsPiisConsentList(List<ConsentEntity> consentEntities) {
        return consentEntities.stream().map(this::mapToCmsPiisConsent).collect(Collectors.toList());
    }

    public CmsPiisConsent mapToCmsPiisConsent(ConsentEntity consentEntity) {
        PiisConsentData piisConsentData = this.consentDataMapper.mapToPiisConsentData(consentEntity.getData());
        AccountReference accountReference = this.accessMapper.mapToAccountReference(consentEntity.getAspspAccountAccesses().get(0));
        ZoneOffset offset = OffsetDateTime.now().getOffset();
        return new CmsPiisConsent(consentEntity.getExternalId(), consentEntity.isRecurringIndicator(), consentEntity.getRequestDateTime() != null ? consentEntity.getRequestDateTime().atOffset(offset) : null, consentEntity.getLastActionDate(), consentEntity.getValidUntil(), this.psuDataMapper.mapToPsuIdData(consentEntity.getPsuDataList().get(0)), consentEntity.getConsentStatus(), accountReference, PiisConsentTppAccessType.SINGLE_TPP, consentEntity.getCreationTimestamp(), consentEntity.getInstanceId(), piisConsentData.getCardNumber(), piisConsentData.getCardExpiryDate(), piisConsentData.getCardInformation(), piisConsentData.getRegistrationInformation(), consentEntity.getStatusChangeTimestamp(), consentEntity.getTppInformation().getTppInfo().getAuthorisationNumber());
    }

    public ConsentEntity mapToPiisConsentEntity(PsuIdData psuIdData, TppInfoEntity tppInfoEntity, CreatePiisConsentRequest request) {
        ConsentEntity consent = new ConsentEntity();
        consent.setExternalId(UUID.randomUUID().toString());
        consent.setConsentStatus(ConsentStatus.VALID);
        consent.setRequestDateTime(LocalDateTime.now());
        consent.setValidUntil(request.getValidUntil());
        consent.setLastActionDate(LocalDate.now());
        consent.getPsuDataList().add(this.psuDataMapper.mapToPsuData(psuIdData));
        consent.getAspspAccountAccesses().add(this.accessMapper.mapToAspspAccountAccess(request.getAccount()));
        consent.getTppInformation().setTppInfo(tppInfoEntity);
        PiisConsentData consentData = new PiisConsentData(request.getCardNumber(), request.getCardExpiryDate(), request.getCardInformation(), request.getRegistrationInformation());
        consent.setData(this.consentDataMapper.getBytesFromConsentData((Object)consentData));
        consent.setConsentType(ConsentType.PIIS_ASPSP.toString());
        return consent;
    }

    @ConstructorProperties(value={"psuDataMapper", "consentDataMapper", "accessMapper"})
    public PiisConsentMapper(PsuDataMapper psuDataMapper, ConsentDataMapper consentDataMapper, AccessMapper accessMapper) {
        this.psuDataMapper = psuDataMapper;
        this.consentDataMapper = consentDataMapper;
        this.accessMapper = accessMapper;
    }
}

