/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.ais.AdditionalAccountInformationType;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.service.mapper.AccessMapper;
import de.adorsys.psd2.consent.service.mapper.AuthorisationMapper;
import de.adorsys.psd2.consent.service.mapper.AuthorisationTemplateMapper;
import de.adorsys.psd2.consent.service.mapper.ConsentTppInformationMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.stereotype.Component;

@Component
public class CmsConsentMapper {
    private final AuthorisationTemplateMapper authorisationTemplateMapper;
    private final ConsentTppInformationMapper consentTppInformationMapper;
    private final PsuDataMapper psuDataMapper;
    private final AuthorisationMapper authorisationMapper;
    private final AccessMapper accessMapper;

    public CmsConsent mapToCmsConsent(ConsentEntity entity, List<AuthorisationEntity> authorisations, Map<String, Integer> usages) {
        CmsConsent cmsConsent = new CmsConsent();
        cmsConsent.setId(entity.getExternalId());
        cmsConsent.setConsentData(entity.getData());
        cmsConsent.setChecksum(entity.getChecksum());
        cmsConsent.setConsentStatus(entity.getConsentStatus());
        cmsConsent.setConsentType(ConsentType.getByValue((String)entity.getConsentType()));
        cmsConsent.setTppInformation(this.consentTppInformationMapper.mapToConsentTppInformation(entity.getTppInformation()));
        cmsConsent.setAuthorisationTemplate(this.authorisationTemplateMapper.mapToAuthorisationTemplate(entity.getAuthorisationTemplate()));
        cmsConsent.setInternalRequestId(entity.getInternalRequestId());
        cmsConsent.setFrequencyPerDay(Integer.valueOf(entity.getFrequencyPerDay()));
        cmsConsent.setValidUntil(entity.getValidUntil());
        cmsConsent.setPsuIdDataList(this.psuDataMapper.mapToPsuIdDataList(entity.getPsuDataList()));
        cmsConsent.setRecurringIndicator(entity.isRecurringIndicator());
        cmsConsent.setMultilevelScaRequired(entity.isMultilevelScaRequired());
        cmsConsent.setExpireDate(entity.getExpireDate());
        cmsConsent.setLastActionDate(entity.getLastActionDate());
        cmsConsent.setAuthorisations(this.authorisationMapper.mapToAuthorisations(authorisations));
        cmsConsent.setUsages(usages);
        cmsConsent.setTppAccountAccesses(this.accessMapper.mapTppAccessesToAccountAccess(entity.getTppAccountAccesses(), entity.getOwnerNameType()));
        cmsConsent.setAspspAccountAccesses(this.accessMapper.mapAspspAccessesToAccountAccess(entity.getAspspAccountAccesses(), entity.getOwnerNameType()));
        return cmsConsent;
    }

    public ConsentEntity mapToNewConsentEntity(CmsConsent cmsConsent) {
        ConsentEntity entity = new ConsentEntity();
        entity.setData(cmsConsent.getConsentData());
        entity.setChecksum(cmsConsent.getChecksum());
        entity.setExternalId(UUID.randomUUID().toString());
        entity.setConsentStatus(cmsConsent.getConsentStatus());
        entity.setConsentType(cmsConsent.getConsentType().getName());
        entity.setFrequencyPerDay(cmsConsent.getFrequencyPerDay());
        entity.setMultilevelScaRequired(cmsConsent.isMultilevelScaRequired());
        entity.setRequestDateTime(LocalDateTime.now());
        entity.setValidUntil(cmsConsent.getValidUntil());
        entity.setExpireDate(cmsConsent.getExpireDate());
        entity.setPsuDataList(this.psuDataMapper.mapToPsuDataList(cmsConsent.getPsuIdDataList()));
        entity.setAuthorisationTemplate(this.authorisationTemplateMapper.mapToAuthorisationTemplateEntity(cmsConsent.getAuthorisationTemplate()));
        entity.setRecurringIndicator(cmsConsent.isRecurringIndicator());
        entity.setLastActionDate(LocalDate.now());
        entity.setInternalRequestId(cmsConsent.getInternalRequestId());
        entity.setTppInformation(this.consentTppInformationMapper.mapToConsentTppInformationEntity(cmsConsent.getTppInformation()));
        AccountAccess tppAccountAccesses = cmsConsent.getTppAccountAccesses();
        entity.setTppAccountAccesses(this.accessMapper.mapToTppAccountAccess(tppAccountAccesses));
        entity.setAspspAccountAccesses(this.accessMapper.mapToAspspAccountAccess(cmsConsent.getAspspAccountAccesses()));
        AdditionalInformationAccess additionalInformationAccess = tppAccountAccesses.getAdditionalInformationAccess();
        if (additionalInformationAccess != null) {
            entity.setOwnerNameType(AdditionalAccountInformationType.findTypeByList((List)additionalInformationAccess.getOwnerName()));
        }
        return entity;
    }

    @ConstructorProperties(value={"authorisationTemplateMapper", "consentTppInformationMapper", "psuDataMapper", "authorisationMapper", "accessMapper"})
    public CmsConsentMapper(AuthorisationTemplateMapper authorisationTemplateMapper, ConsentTppInformationMapper consentTppInformationMapper, PsuDataMapper psuDataMapper, AuthorisationMapper authorisationMapper, AccessMapper accessMapper) {
        this.authorisationTemplateMapper = authorisationTemplateMapper;
        this.consentTppInformationMapper = consentTppInformationMapper;
        this.psuDataMapper = psuDataMapper;
        this.authorisationMapper = authorisationMapper;
        this.accessMapper = accessMapper;
    }
}

