/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.consent;

import de.adorsys.psd2.consent.api.ais.AdditionalAccountInformationType;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.account.AisConsentUsage;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.domain.account.TppAccountAccess;
import de.adorsys.psd2.consent.domain.consent.ConsentTppInformationEntity;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import org.apache.commons.collections4.CollectionUtils;

@Entity(name="consent")
public class ConsentEntity
extends InstanceDependableEntity
implements Authorisable {
    @Id
    @Column(name="consent_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="consent_generator")
    @SequenceGenerator(name="consent_generator", sequenceName="consent_id_seq", allocationSize=1)
    private Long id;
    @Column(name="external_id", nullable=false)
    private String externalId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="consent_status", nullable=false)
    private ConsentStatus consentStatus;
    @Column(name="consent_type", nullable=false)
    private String consentType;
    @Column(name="frequency_per_day", nullable=false)
    private int frequencyPerDay;
    @Column(name="recurring_indicator", nullable=false)
    private boolean recurringIndicator;
    @Column(name="multilevel_sca_required", nullable=false)
    private boolean multilevelScaRequired;
    @Lob
    @Column(name="checksum")
    private byte[] checksum;
    @Lob
    @Column(name="data")
    private byte[] data;
    @Column(name="creation_timestamp", nullable=false)
    private OffsetDateTime creationTimestamp = OffsetDateTime.now();
    @Column(name="expire_date")
    private LocalDate expireDate;
    @Column(name="valid_until")
    private LocalDate validUntil;
    @Column(name="last_action_date")
    private LocalDate lastActionDate;
    @Column(name="request_date_time", nullable=false)
    private LocalDateTime requestDateTime;
    @Column(name="status_change_timestamp")
    private OffsetDateTime statusChangeTimestamp;
    @Column(name="internal_request_id")
    private String internalRequestId;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="authorisation_template_id", nullable=false)
    private AuthorisationTemplateEntity authorisationTemplate = new AuthorisationTemplateEntity();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="consent_tpp_information_id", nullable=false)
    private ConsentTppInformationEntity tppInformation = new ConsentTppInformationEntity();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="ais_consent_psu_data", joinColumns={@JoinColumn(name="ais_consent_id")}, inverseJoinColumns={@JoinColumn(name="psu_data_id")})
    private List<PsuData> psuDataList = new ArrayList<PsuData>();
    @OneToMany(mappedBy="consent", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AisConsentUsage> usages = new ArrayList<AisConsentUsage>();
    @ElementCollection
    @CollectionTable(name="ais_account_access", joinColumns={@JoinColumn(name="consent_id")})
    private List<TppAccountAccess> tppAccountAccesses = new ArrayList<TppAccountAccess>();
    @ElementCollection
    @CollectionTable(name="ais_aspsp_account_access", joinColumns={@JoinColumn(name="consent_id")})
    private List<AspspAccountAccess> aspspAccountAccesses = new ArrayList<AspspAccountAccess>();
    @Column(name="owner_name_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AdditionalAccountInformationType ownerNameType = AdditionalAccountInformationType.NONE;
    @Transient
    private ConsentStatus previousConsentStatus;

    @PostLoad
    public void consentPostLoad() {
        this.previousConsentStatus = this.consentStatus;
    }

    @PreUpdate
    public void consentPreUpdate() {
        if (this.previousConsentStatus != this.consentStatus) {
            this.statusChangeTimestamp = OffsetDateTime.now();
        }
    }

    @PrePersist
    public void consentPrePersist() {
        if (Objects.isNull(this.statusChangeTimestamp)) {
            this.statusChangeTimestamp = this.creationTimestamp;
        }
    }

    public boolean isConfirmationExpired(long expirationPeriodMs) {
        if (EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.PARTIALLY_AUTHORISED).contains(this.consentStatus)) {
            return this.creationTimestamp.plus(expirationPeriodMs, ChronoUnit.MILLIS).isBefore(OffsetDateTime.now());
        }
        return false;
    }

    public void addUsage(AisConsentUsage aisConsentUsage) {
        if (this.usages == null) {
            this.usages = new ArrayList<AisConsentUsage>();
        }
        this.usages.add(aisConsentUsage);
    }

    public boolean isWrongConsentData() {
        return CollectionUtils.isEmpty(this.psuDataList) || this.tppInformation == null || this.tppInformation.getTppInfo() == null;
    }

    public boolean isExpiredByDate() {
        return LocalDate.now().compareTo(this.validUntil) > 0;
    }

    public boolean shouldConsentBeExpired() {
        return !this.getConsentStatus().isFinalisedStatus() && (this.isExpiredByDate() || this.isNonReccuringAlreadyUsed());
    }

    public boolean isNonReccuringAlreadyUsed() {
        return !this.recurringIndicator && this.usages.stream().anyMatch(u -> u.getUsageDate().isBefore(LocalDate.now()));
    }

    public boolean isOneAccessType() {
        return !this.recurringIndicator;
    }

    @Override
    public String getInternalRequestId(AuthorisationType authorisationType) {
        if (authorisationType == AuthorisationType.AIS) {
            return this.internalRequestId;
        }
        throw new IllegalArgumentException("Invalid authorisation type: " + authorisationType);
    }

    public Long getId() {
        return this.id;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    public ConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    public String getConsentType() {
        return this.consentType;
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public boolean isMultilevelScaRequired() {
        return this.multilevelScaRequired;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public byte[] getData() {
        return this.data;
    }

    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public LocalDate getExpireDate() {
        return this.expireDate;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public LocalDate getLastActionDate() {
        return this.lastActionDate;
    }

    public LocalDateTime getRequestDateTime() {
        return this.requestDateTime;
    }

    public OffsetDateTime getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public String getInternalRequestId() {
        return this.internalRequestId;
    }

    @Override
    public AuthorisationTemplateEntity getAuthorisationTemplate() {
        return this.authorisationTemplate;
    }

    public ConsentTppInformationEntity getTppInformation() {
        return this.tppInformation;
    }

    @Override
    public List<PsuData> getPsuDataList() {
        return this.psuDataList;
    }

    public List<AisConsentUsage> getUsages() {
        return this.usages;
    }

    public List<TppAccountAccess> getTppAccountAccesses() {
        return this.tppAccountAccesses;
    }

    public List<AspspAccountAccess> getAspspAccountAccesses() {
        return this.aspspAccountAccesses;
    }

    public AdditionalAccountInformationType getOwnerNameType() {
        return this.ownerNameType;
    }

    public ConsentStatus getPreviousConsentStatus() {
        return this.previousConsentStatus;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setConsentStatus(ConsentStatus consentStatus) {
        this.consentStatus = consentStatus;
    }

    public void setConsentType(String consentType) {
        this.consentType = consentType;
    }

    public void setFrequencyPerDay(int frequencyPerDay) {
        this.frequencyPerDay = frequencyPerDay;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setMultilevelScaRequired(boolean multilevelScaRequired) {
        this.multilevelScaRequired = multilevelScaRequired;
    }

    public void setChecksum(byte[] checksum) {
        this.checksum = checksum;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public void setExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setLastActionDate(LocalDate lastActionDate) {
        this.lastActionDate = lastActionDate;
    }

    public void setRequestDateTime(LocalDateTime requestDateTime) {
        this.requestDateTime = requestDateTime;
    }

    public void setStatusChangeTimestamp(OffsetDateTime statusChangeTimestamp) {
        this.statusChangeTimestamp = statusChangeTimestamp;
    }

    public void setInternalRequestId(String internalRequestId) {
        this.internalRequestId = internalRequestId;
    }

    public void setAuthorisationTemplate(AuthorisationTemplateEntity authorisationTemplate) {
        this.authorisationTemplate = authorisationTemplate;
    }

    public void setTppInformation(ConsentTppInformationEntity tppInformation) {
        this.tppInformation = tppInformation;
    }

    @Override
    public void setPsuDataList(List<PsuData> psuDataList) {
        this.psuDataList = psuDataList;
    }

    public void setUsages(List<AisConsentUsage> usages) {
        this.usages = usages;
    }

    public void setTppAccountAccesses(List<TppAccountAccess> tppAccountAccesses) {
        this.tppAccountAccesses = tppAccountAccesses;
    }

    public void setAspspAccountAccesses(List<AspspAccountAccess> aspspAccountAccesses) {
        this.aspspAccountAccesses = aspspAccountAccesses;
    }

    public void setOwnerNameType(AdditionalAccountInformationType ownerNameType) {
        this.ownerNameType = ownerNameType;
    }

    public void setPreviousConsentStatus(ConsentStatus previousConsentStatus) {
        this.previousConsentStatus = previousConsentStatus;
    }

    public String toString() {
        return "ConsentEntity(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", consentStatus=" + this.getConsentStatus() + ", consentType=" + this.getConsentType() + ", frequencyPerDay=" + this.getFrequencyPerDay() + ", recurringIndicator=" + this.isRecurringIndicator() + ", multilevelScaRequired=" + this.isMultilevelScaRequired() + ", checksum=" + Arrays.toString(this.getChecksum()) + ", data=" + Arrays.toString(this.getData()) + ", creationTimestamp=" + this.getCreationTimestamp() + ", expireDate=" + this.getExpireDate() + ", validUntil=" + this.getValidUntil() + ", lastActionDate=" + this.getLastActionDate() + ", requestDateTime=" + this.getRequestDateTime() + ", statusChangeTimestamp=" + this.getStatusChangeTimestamp() + ", internalRequestId=" + this.getInternalRequestId() + ", authorisationTemplate=" + this.getAuthorisationTemplate() + ", tppInformation=" + this.getTppInformation() + ", psuDataList=" + this.getPsuDataList() + ", usages=" + this.getUsages() + ", tppAccountAccesses=" + this.getTppAccountAccesses() + ", aspspAccountAccesses=" + this.getAspspAccountAccesses() + ", ownerNameType=" + this.getOwnerNameType() + ", previousConsentStatus=" + this.getPreviousConsentStatus() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsentEntity)) {
            return false;
        }
        ConsentEntity other = (ConsentEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        ConsentStatus this$consentStatus = this.getConsentStatus();
        ConsentStatus other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        String this$consentType = this.getConsentType();
        String other$consentType = other.getConsentType();
        if (this$consentType == null ? other$consentType != null : !this$consentType.equals(other$consentType)) {
            return false;
        }
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        if (this.isMultilevelScaRequired() != other.isMultilevelScaRequired()) {
            return false;
        }
        if (!Arrays.equals(this.getChecksum(), other.getChecksum())) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        OffsetDateTime this$creationTimestamp = this.getCreationTimestamp();
        OffsetDateTime other$creationTimestamp = other.getCreationTimestamp();
        if (this$creationTimestamp == null ? other$creationTimestamp != null : !((Object)this$creationTimestamp).equals(other$creationTimestamp)) {
            return false;
        }
        LocalDate this$expireDate = this.getExpireDate();
        LocalDate other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        LocalDate this$lastActionDate = this.getLastActionDate();
        LocalDate other$lastActionDate = other.getLastActionDate();
        if (this$lastActionDate == null ? other$lastActionDate != null : !((Object)this$lastActionDate).equals(other$lastActionDate)) {
            return false;
        }
        LocalDateTime this$requestDateTime = this.getRequestDateTime();
        LocalDateTime other$requestDateTime = other.getRequestDateTime();
        if (this$requestDateTime == null ? other$requestDateTime != null : !((Object)this$requestDateTime).equals(other$requestDateTime)) {
            return false;
        }
        OffsetDateTime this$statusChangeTimestamp = this.getStatusChangeTimestamp();
        OffsetDateTime other$statusChangeTimestamp = other.getStatusChangeTimestamp();
        if (this$statusChangeTimestamp == null ? other$statusChangeTimestamp != null : !((Object)this$statusChangeTimestamp).equals(other$statusChangeTimestamp)) {
            return false;
        }
        String this$internalRequestId = this.getInternalRequestId();
        String other$internalRequestId = other.getInternalRequestId();
        if (this$internalRequestId == null ? other$internalRequestId != null : !this$internalRequestId.equals(other$internalRequestId)) {
            return false;
        }
        AuthorisationTemplateEntity this$authorisationTemplate = this.getAuthorisationTemplate();
        AuthorisationTemplateEntity other$authorisationTemplate = other.getAuthorisationTemplate();
        if (this$authorisationTemplate == null ? other$authorisationTemplate != null : !((Object)this$authorisationTemplate).equals(other$authorisationTemplate)) {
            return false;
        }
        ConsentTppInformationEntity this$tppInformation = this.getTppInformation();
        ConsentTppInformationEntity other$tppInformation = other.getTppInformation();
        if (this$tppInformation == null ? other$tppInformation != null : !((Object)this$tppInformation).equals(other$tppInformation)) {
            return false;
        }
        List<PsuData> this$psuDataList = this.getPsuDataList();
        List<PsuData> other$psuDataList = other.getPsuDataList();
        if (this$psuDataList == null ? other$psuDataList != null : !((Object)this$psuDataList).equals(other$psuDataList)) {
            return false;
        }
        List<AisConsentUsage> this$usages = this.getUsages();
        List<AisConsentUsage> other$usages = other.getUsages();
        if (this$usages == null ? other$usages != null : !((Object)this$usages).equals(other$usages)) {
            return false;
        }
        List<TppAccountAccess> this$tppAccountAccesses = this.getTppAccountAccesses();
        List<TppAccountAccess> other$tppAccountAccesses = other.getTppAccountAccesses();
        if (this$tppAccountAccesses == null ? other$tppAccountAccesses != null : !((Object)this$tppAccountAccesses).equals(other$tppAccountAccesses)) {
            return false;
        }
        List<AspspAccountAccess> this$aspspAccountAccesses = this.getAspspAccountAccesses();
        List<AspspAccountAccess> other$aspspAccountAccesses = other.getAspspAccountAccesses();
        if (this$aspspAccountAccesses == null ? other$aspspAccountAccesses != null : !((Object)this$aspspAccountAccesses).equals(other$aspspAccountAccesses)) {
            return false;
        }
        AdditionalAccountInformationType this$ownerNameType = this.getOwnerNameType();
        AdditionalAccountInformationType other$ownerNameType = other.getOwnerNameType();
        if (this$ownerNameType == null ? other$ownerNameType != null : !this$ownerNameType.equals(other$ownerNameType)) {
            return false;
        }
        ConsentStatus this$previousConsentStatus = this.getPreviousConsentStatus();
        ConsentStatus other$previousConsentStatus = other.getPreviousConsentStatus();
        return !(this$previousConsentStatus == null ? other$previousConsentStatus != null : !this$previousConsentStatus.equals(other$previousConsentStatus));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConsentEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        ConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        String $consentType = this.getConsentType();
        result = result * 59 + ($consentType == null ? 43 : $consentType.hashCode());
        result = result * 59 + this.getFrequencyPerDay();
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        result = result * 59 + (this.isMultilevelScaRequired() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getChecksum());
        result = result * 59 + Arrays.hashCode(this.getData());
        OffsetDateTime $creationTimestamp = this.getCreationTimestamp();
        result = result * 59 + ($creationTimestamp == null ? 43 : ((Object)$creationTimestamp).hashCode());
        LocalDate $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        LocalDate $lastActionDate = this.getLastActionDate();
        result = result * 59 + ($lastActionDate == null ? 43 : ((Object)$lastActionDate).hashCode());
        LocalDateTime $requestDateTime = this.getRequestDateTime();
        result = result * 59 + ($requestDateTime == null ? 43 : ((Object)$requestDateTime).hashCode());
        OffsetDateTime $statusChangeTimestamp = this.getStatusChangeTimestamp();
        result = result * 59 + ($statusChangeTimestamp == null ? 43 : ((Object)$statusChangeTimestamp).hashCode());
        String $internalRequestId = this.getInternalRequestId();
        result = result * 59 + ($internalRequestId == null ? 43 : $internalRequestId.hashCode());
        AuthorisationTemplateEntity $authorisationTemplate = this.getAuthorisationTemplate();
        result = result * 59 + ($authorisationTemplate == null ? 43 : ((Object)$authorisationTemplate).hashCode());
        ConsentTppInformationEntity $tppInformation = this.getTppInformation();
        result = result * 59 + ($tppInformation == null ? 43 : ((Object)$tppInformation).hashCode());
        List<PsuData> $psuDataList = this.getPsuDataList();
        result = result * 59 + ($psuDataList == null ? 43 : ((Object)$psuDataList).hashCode());
        List<AisConsentUsage> $usages = this.getUsages();
        result = result * 59 + ($usages == null ? 43 : ((Object)$usages).hashCode());
        List<TppAccountAccess> $tppAccountAccesses = this.getTppAccountAccesses();
        result = result * 59 + ($tppAccountAccesses == null ? 43 : ((Object)$tppAccountAccesses).hashCode());
        List<AspspAccountAccess> $aspspAccountAccesses = this.getAspspAccountAccesses();
        result = result * 59 + ($aspspAccountAccesses == null ? 43 : ((Object)$aspspAccountAccesses).hashCode());
        AdditionalAccountInformationType $ownerNameType = this.getOwnerNameType();
        result = result * 59 + ($ownerNameType == null ? 43 : $ownerNameType.hashCode());
        ConsentStatus $previousConsentStatus = this.getPreviousConsentStatus();
        result = result * 59 + ($previousConsentStatus == null ? 43 : $previousConsentStatus.hashCode());
        return result;
    }
}

