/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.api.ais.CmsAisAccountConsent;
import de.adorsys.psd2.consent.aspsp.api.ais.CmsAspspAisExportService;
import de.adorsys.psd2.consent.repository.AisConsentJpaRepository;
import de.adorsys.psd2.consent.repository.specification.AisConsentSpecification;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsAspspAisExportServiceInternal
implements CmsAspspAisExportService {
    private static final Logger log = LoggerFactory.getLogger(CmsAspspAisExportServiceInternal.class);
    private final AisConsentSpecification aisConsentSpecification;
    private final AisConsentJpaRepository aisConsentJpaRepository;
    private final AisConsentMapper aisConsentMapper;

    public Collection<CmsAisAccountConsent> exportConsentsByTpp(String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @NotNull String instanceId) {
        if (StringUtils.isBlank((CharSequence)tppAuthorisationNumber) || StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("TPP ID: [{}], InstanceId: [{}]. Export Consents by TPP: Some of these two values are empty", (Object)tppAuthorisationNumber, (Object)instanceId);
            return Collections.emptyList();
        }
        return this.aisConsentJpaRepository.findAll(this.aisConsentSpecification.byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(tppAuthorisationNumber, createDateFrom, createDateTo, psuIdData, instanceId)).stream().map(this.aisConsentMapper::mapToCmsAisAccountConsent).collect(Collectors.toList());
    }

    public Collection<CmsAisAccountConsent> exportConsentsByPsu(PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @NotNull String instanceId) {
        if (psuIdData == null || psuIdData.isEmpty() || StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("InstanceId: [{}]. Export consents by Psu failed, psuIdData or instanceId is empty or null.", (Object)instanceId);
            return Collections.emptyList();
        }
        return this.aisConsentJpaRepository.findAll(this.aisConsentSpecification.byPsuIdDataAndCreationPeriodAndInstanceId(psuIdData, createDateFrom, createDateTo, instanceId)).stream().map(this.aisConsentMapper::mapToCmsAisAccountConsent).collect(Collectors.toList());
    }

    public Collection<CmsAisAccountConsent> exportConsentsByAccountId(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @NotNull String instanceId) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("InstanceId: [{}], aspspAccountId: [{}]. Export consents by accountId failed, instanceId is empty or null.", (Object)instanceId, (Object)aspspAccountId);
            return Collections.emptyList();
        }
        return this.aisConsentJpaRepository.findAll(this.aisConsentSpecification.byAspspAccountIdAndCreationPeriodAndInstanceId(aspspAccountId, createDateFrom, createDateTo, instanceId)).stream().map(this.aisConsentMapper::mapToCmsAisAccountConsent).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"aisConsentSpecification", "aisConsentJpaRepository", "aisConsentMapper"})
    public CmsAspspAisExportServiceInternal(AisConsentSpecification aisConsentSpecification, AisConsentJpaRepository aisConsentJpaRepository, AisConsentMapper aisConsentMapper) {
        this.aisConsentSpecification = aisConsentSpecification;
        this.aisConsentJpaRepository = aisConsentJpaRepository;
        this.aisConsentMapper = aisConsentMapper;
    }
}

