/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.GetPisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.consent.api.service.PisAuthorisationService;
import de.adorsys.psd2.consent.api.service.PisAuthorisationServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PisAuthorisationServiceInternalEncrypted
implements PisAuthorisationServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(PisAuthorisationServiceInternalEncrypted.class);
    private final SecurityDataService securityDataService;
    private final PisAuthorisationService pisAuthorisationService;

    @Transactional
    public CmsResponse<CreatePisAuthorisationResponse> createAuthorization(String encryptedPaymentId, CreatePisAuthorisationRequest request) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Payment ID: [{}].Create authorisation failed, couldn't decrypt consent id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.pisAuthorisationService.createAuthorization(decryptIdOptional.get(), request);
    }

    @Transactional
    public CmsResponse<CreatePisAuthorisationResponse> createAuthorizationCancellation(String encryptedPaymentId, CreatePisAuthorisationRequest request) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Payment ID: [{}].Create authorisation cancellation failed, couldn't decrypt consent id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.pisAuthorisationService.createAuthorizationCancellation(decryptIdOptional.get(), request);
    }

    @Transactional
    public CmsResponse<UpdatePisCommonPaymentPsuDataResponse> updatePisAuthorisation(String authorisationId, UpdatePisCommonPaymentPsuDataRequest request) {
        return this.pisAuthorisationService.updatePisAuthorisation(authorisationId, request);
    }

    @Transactional
    public CmsResponse<Boolean> updatePisAuthorisationStatus(String authorisationId, ScaStatus scaStatus) {
        return this.pisAuthorisationService.updatePisAuthorisationStatus(authorisationId, scaStatus);
    }

    @Transactional
    public CmsResponse<UpdatePisCommonPaymentPsuDataResponse> updatePisCancellationAuthorisation(String authorisationId, UpdatePisCommonPaymentPsuDataRequest request) {
        return this.pisAuthorisationService.updatePisCancellationAuthorisation(authorisationId, request);
    }

    @Transactional
    public CmsResponse<GetPisAuthorisationResponse> getPisAuthorisationById(String authorisationId) {
        return this.pisAuthorisationService.getPisAuthorisationById(authorisationId);
    }

    public CmsResponse<GetPisAuthorisationResponse> getPisCancellationAuthorisationById(String cancellationId) {
        return this.pisAuthorisationService.getPisCancellationAuthorisationById(cancellationId);
    }

    public CmsResponse<List<String>> getAuthorisationsByPaymentId(String encryptedPaymentId, PaymentAuthorisationType authorisationType) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Payment ID: [{}]. Get payment authorisation list failed, couldn't decrypt consent id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.pisAuthorisationService.getAuthorisationsByPaymentId(decryptIdOptional.get(), authorisationType);
    }

    @Transactional
    public CmsResponse<ScaStatus> getAuthorisationScaStatus(String encryptedPaymentId, String authorisationId, PaymentAuthorisationType authorisationType) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Payment ID: [{}]. Get common payment authorisation SCA status failed, couldn't decrypt consent id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.pisAuthorisationService.getAuthorisationScaStatus(decryptIdOptional.get(), authorisationId, authorisationType);
    }

    public CmsResponse<Boolean> isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        return this.pisAuthorisationService.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    @Transactional
    public CmsResponse<Boolean> saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        return this.pisAuthorisationService.saveAuthenticationMethods(authorisationId, methods);
    }

    @Transactional
    public CmsResponse<Boolean> updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        return this.pisAuthorisationService.updateScaApproach(authorisationId, scaApproach);
    }

    public CmsResponse<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId, PaymentAuthorisationType authorisationType) {
        return this.pisAuthorisationService.getAuthorisationScaApproach(authorisationId, authorisationType);
    }

    @ConstructorProperties(value={"securityDataService", "pisAuthorisationService"})
    public PisAuthorisationServiceInternalEncrypted(SecurityDataService securityDataService, PisAuthorisationService pisAuthorisationService) {
        this.securityDataService = securityDataService;
        this.pisAuthorisationService = pisAuthorisationService;
    }
}

