/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentUsage;
import de.adorsys.psd2.consent.repository.AisConsentUsageRepository;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AisConsentUsageService {
    private final AisConsentUsageRepository aisConsentUsageRepository;

    @Transactional
    public void incrementUsage(AisConsent aisConsent, AisConsentActionRequest request) {
        AisConsentUsage aisConsentUsage = this.getUsage(aisConsent, request.getRequestUri());
        int usage = aisConsentUsage.getUsage();
        aisConsentUsage.setUsage(++usage);
        aisConsentUsage.setResourceId(request.getResourceId());
        aisConsentUsage.setTransactionId(request.getTransactionId());
        this.aisConsentUsageRepository.save(aisConsentUsage);
    }

    @Transactional
    public void resetUsage(AisConsent aisConsent) {
        List<AisConsentUsage> aisConsentUsageList = this.aisConsentUsageRepository.findReadByConsentAndUsageDate(aisConsent, LocalDate.now());
        aisConsentUsageList.forEach(acu -> acu.setUsage(0));
        this.aisConsentUsageRepository.saveAll(aisConsentUsageList);
    }

    @Transactional
    public Map<String, Integer> getUsageCounterMap(AisConsent aisConsent) {
        return this.aisConsentUsageRepository.findReadByConsentAndUsageDate(aisConsent, LocalDate.now()).stream().collect(Collectors.toMap(AisConsentUsage::getRequestUri, u -> Math.max(aisConsent.getAllowedFrequencyPerDay() - u.getUsage(), 0)));
    }

    private AisConsentUsage getUsage(AisConsent aisConsent, String requestUri) {
        return this.aisConsentUsageRepository.findWriteByConsentAndUsageDateAndRequestUri(aisConsent, LocalDate.now(), requestUri).orElseGet(() -> {
            AisConsentUsage usage = new AisConsentUsage(aisConsent, requestUri);
            aisConsent.addUsage(usage);
            return usage;
        });
    }

    @ConstructorProperties(value={"aisConsentUsageRepository"})
    public AisConsentUsageService(AisConsentUsageRepository aisConsentUsageRepository) {
        this.aisConsentUsageRepository = aisConsentUsageRepository;
    }
}

