/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.impl;

import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.repository.AisConsentJpaRepository;
import de.adorsys.psd2.consent.repository.AisConsentVerifyingRepository;
import de.adorsys.psd2.consent.repository.impl.ChecksumCalculatingFactory;
import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingService;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AisConsentRepositoryImpl
implements AisConsentVerifyingRepository {
    private static final Logger log = LoggerFactory.getLogger(AisConsentRepositoryImpl.class);
    private final AisConsentJpaRepository aisConsentRepository;
    private final ChecksumCalculatingFactory calculatingFactory;

    @Override
    @Transactional(rollbackFor={WrongChecksumException.class})
    public AisConsent verifyAndSave(AisConsent entity) throws WrongChecksumException {
        return this.verifyAndSaveInternal(entity);
    }

    @Override
    @Transactional(rollbackFor={WrongChecksumException.class})
    public AisConsent verifyAndUpdate(AisConsent entity) throws WrongChecksumException {
        return this.verifyAndUpdateInternal(entity);
    }

    @Override
    @Transactional(rollbackFor={WrongChecksumException.class})
    public List<AisConsent> verifyAndSaveAll(List<AisConsent> consents) throws WrongChecksumException {
        ArrayList<AisConsent> consentList = new ArrayList<AisConsent>();
        for (AisConsent aisConsent : consents) {
            AisConsent consent = this.verifyAndSaveInternal(aisConsent);
            consentList.add(consent);
        }
        return consentList;
    }

    @Override
    @Transactional
    public Optional<AisConsent> getActualAisConsent(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).filter(c -> !c.getConsentStatus().isFinalisedStatus());
    }

    private AisConsent verifyAndSaveInternal(AisConsent entity) throws WrongChecksumException {
        Optional<ChecksumCalculatingService> calculatingServiceOptional = this.calculatingFactory.getServiceByChecksum(entity.getChecksum());
        if (calculatingServiceOptional.isPresent()) {
            ChecksumCalculatingService calculatingService = calculatingServiceOptional.get();
            if (!this.isAisConsentChecksumCorrect(entity, calculatingService)) {
                throw new WrongChecksumException();
            }
            if (this.wasStatusSwitchedToValid(entity)) {
                byte[] newChecksum = calculatingService.calculateChecksumForConsent(entity);
                entity.setChecksum(newChecksum);
            }
        }
        return (AisConsent)this.aisConsentRepository.save(entity);
    }

    private AisConsent verifyAndUpdateInternal(AisConsent entity) throws WrongChecksumException {
        Optional<ChecksumCalculatingService> calculatingServiceOptional = this.calculatingFactory.getServiceByChecksum(entity.getChecksum());
        if (calculatingServiceOptional.isPresent()) {
            ChecksumCalculatingService calculatingService = calculatingServiceOptional.get();
            if (!this.isAisConsentChecksumCorrect(entity, calculatingService)) {
                throw new WrongChecksumException();
            }
            if (entity.getConsentStatus() == ConsentStatus.VALID) {
                byte[] newChecksum = calculatingService.calculateChecksumForConsent(entity);
                entity.setChecksum(newChecksum);
            }
        }
        return (AisConsent)this.aisConsentRepository.save(entity);
    }

    private boolean isAisConsentChecksumCorrect(AisConsent entity, ChecksumCalculatingService calculatingService) {
        byte[] checksumFromDb = entity.getChecksum();
        if (checksumFromDb != null && this.wasStatusHoldBefore(entity) && !calculatingService.verifyConsentWithChecksum(entity, checksumFromDb)) {
            log.warn("AIS consent checksum verification failed! AIS consent ID: [{}]. Contact ASPSP for details.", (Object)entity.getExternalId());
            return false;
        }
        return true;
    }

    private boolean wasStatusSwitchedToValid(AisConsent entity) {
        return entity.getConsentStatus() == ConsentStatus.VALID && EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.PARTIALLY_AUTHORISED).contains(entity.getPreviousConsentStatus());
    }

    private boolean wasStatusHoldBefore(AisConsent entity) {
        return entity.getPreviousConsentStatus() == ConsentStatus.VALID || entity.getPreviousConsentStatus().isFinalisedStatus();
    }

    @ConstructorProperties(value={"aisConsentRepository", "calculatingFactory"})
    public AisConsentRepositoryImpl(AisConsentJpaRepository aisConsentRepository, ChecksumCalculatingFactory calculatingFactory) {
        this.aisConsentRepository = aisConsentRepository;
        this.calculatingFactory = calculatingFactory;
    }
}

