/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain;

import de.adorsys.psd2.consent.domain.AdditionalPsuData;
import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Entity(name="psu_data")
public class PsuData
extends InstanceDependableEntity {
    @Id
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="psu_data_generator")
    @SequenceGenerator(name="psu_data_generator", sequenceName="psu_data_id_seq", allocationSize=1)
    private Long id;
    @Column(name="psu_id")
    private String psuId;
    @Column(name="psu_id_type")
    private String psuIdType;
    @Column(name="psu_corporate_id")
    private String psuCorporateId;
    @Column(name="psu_corporate_id_type")
    private String psuCorporateIdType;
    @Column(name="psu_ip_address")
    private String psuIpAddress;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="additional_psu_data_id")
    private AdditionalPsuData additionalPsuData;

    public PsuData(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String psuIpAddress) {
        this.psuId = psuId;
        this.psuIdType = psuIdType;
        this.psuCorporateId = psuCorporateId;
        this.psuCorporateIdType = psuCorporateIdType;
        this.psuIpAddress = psuIpAddress;
    }

    public PsuData(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String psuIpAddress, AdditionalPsuData additionalPsuData) {
        this(psuId, psuIdType, psuCorporateId, psuCorporateIdType, psuIpAddress);
        this.additionalPsuData = additionalPsuData;
    }

    public boolean contentEquals(@NotNull PsuData otherPsuData) {
        return StringUtils.equals((CharSequence)this.getPsuId(), (CharSequence)otherPsuData.getPsuId()) && StringUtils.equals((CharSequence)this.getPsuCorporateId(), (CharSequence)otherPsuData.getPsuCorporateId()) && StringUtils.equals((CharSequence)this.getPsuCorporateIdType(), (CharSequence)otherPsuData.getPsuCorporateIdType()) && StringUtils.equals((CharSequence)this.getPsuIdType(), (CharSequence)otherPsuData.getPsuIdType());
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.getPsuId());
    }

    public Long getId() {
        return this.id;
    }

    public String getPsuId() {
        return this.psuId;
    }

    public String getPsuIdType() {
        return this.psuIdType;
    }

    public String getPsuCorporateId() {
        return this.psuCorporateId;
    }

    public String getPsuCorporateIdType() {
        return this.psuCorporateIdType;
    }

    public String getPsuIpAddress() {
        return this.psuIpAddress;
    }

    public AdditionalPsuData getAdditionalPsuData() {
        return this.additionalPsuData;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPsuId(String psuId) {
        this.psuId = psuId;
    }

    public void setPsuIdType(String psuIdType) {
        this.psuIdType = psuIdType;
    }

    public void setPsuCorporateId(String psuCorporateId) {
        this.psuCorporateId = psuCorporateId;
    }

    public void setPsuCorporateIdType(String psuCorporateIdType) {
        this.psuCorporateIdType = psuCorporateIdType;
    }

    public void setPsuIpAddress(String psuIpAddress) {
        this.psuIpAddress = psuIpAddress;
    }

    public void setAdditionalPsuData(AdditionalPsuData additionalPsuData) {
        this.additionalPsuData = additionalPsuData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsuData)) {
            return false;
        }
        PsuData other = (PsuData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$psuId = this.getPsuId();
        String other$psuId = other.getPsuId();
        if (this$psuId == null ? other$psuId != null : !this$psuId.equals(other$psuId)) {
            return false;
        }
        String this$psuIdType = this.getPsuIdType();
        String other$psuIdType = other.getPsuIdType();
        if (this$psuIdType == null ? other$psuIdType != null : !this$psuIdType.equals(other$psuIdType)) {
            return false;
        }
        String this$psuCorporateId = this.getPsuCorporateId();
        String other$psuCorporateId = other.getPsuCorporateId();
        if (this$psuCorporateId == null ? other$psuCorporateId != null : !this$psuCorporateId.equals(other$psuCorporateId)) {
            return false;
        }
        String this$psuCorporateIdType = this.getPsuCorporateIdType();
        String other$psuCorporateIdType = other.getPsuCorporateIdType();
        if (this$psuCorporateIdType == null ? other$psuCorporateIdType != null : !this$psuCorporateIdType.equals(other$psuCorporateIdType)) {
            return false;
        }
        String this$psuIpAddress = this.getPsuIpAddress();
        String other$psuIpAddress = other.getPsuIpAddress();
        if (this$psuIpAddress == null ? other$psuIpAddress != null : !this$psuIpAddress.equals(other$psuIpAddress)) {
            return false;
        }
        AdditionalPsuData this$additionalPsuData = this.getAdditionalPsuData();
        AdditionalPsuData other$additionalPsuData = other.getAdditionalPsuData();
        return !(this$additionalPsuData == null ? other$additionalPsuData != null : !((Object)this$additionalPsuData).equals(other$additionalPsuData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PsuData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $psuId = this.getPsuId();
        result = result * 59 + ($psuId == null ? 43 : $psuId.hashCode());
        String $psuIdType = this.getPsuIdType();
        result = result * 59 + ($psuIdType == null ? 43 : $psuIdType.hashCode());
        String $psuCorporateId = this.getPsuCorporateId();
        result = result * 59 + ($psuCorporateId == null ? 43 : $psuCorporateId.hashCode());
        String $psuCorporateIdType = this.getPsuCorporateIdType();
        result = result * 59 + ($psuCorporateIdType == null ? 43 : $psuCorporateIdType.hashCode());
        String $psuIpAddress = this.getPsuIpAddress();
        result = result * 59 + ($psuIpAddress == null ? 43 : $psuIpAddress.hashCode());
        AdditionalPsuData $additionalPsuData = this.getAdditionalPsuData();
        result = result * 59 + ($additionalPsuData == null ? 43 : ((Object)$additionalPsuData).hashCode());
        return result;
    }

    public String toString() {
        return "PsuData(id=" + this.getId() + ", psuId=" + this.getPsuId() + ", psuIdType=" + this.getPsuIdType() + ", psuCorporateId=" + this.getPsuCorporateId() + ", psuCorporateIdType=" + this.getPsuCorporateIdType() + ", psuIpAddress=" + this.getPsuIpAddress() + ", additionalPsuData=" + this.getAdditionalPsuData() + ")";
    }

    public PsuData() {
    }
}

