/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.pis.CmsCommonPayment;
import de.adorsys.psd2.consent.api.pis.CmsPayment;
import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentService;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.payment.PisAuthorization;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.psu.api.CmsPsuAuthorisation;
import de.adorsys.psd2.consent.psu.api.CmsPsuPisService;
import de.adorsys.psd2.consent.psu.api.pis.CmsPisPsuDataAuthorisation;
import de.adorsys.psd2.consent.repository.PisAuthorisationRepository;
import de.adorsys.psd2.consent.repository.PisPaymentDataRepository;
import de.adorsys.psd2.consent.repository.specification.PisAuthorisationSpecification;
import de.adorsys.psd2.consent.repository.specification.PisPaymentDataSpecification;
import de.adorsys.psd2.consent.service.CommonPaymentDataService;
import de.adorsys.psd2.consent.service.CorePaymentsConvertService;
import de.adorsys.psd2.consent.service.mapper.CmsPsuAuthorisationMapper;
import de.adorsys.psd2.consent.service.mapper.CmsPsuPisMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.exception.AuthorisationIsExpiredException;
import de.adorsys.psd2.xs2a.core.exception.RedirectUrlIsExpiredException;
import de.adorsys.psd2.xs2a.core.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsPsuPisServiceInternal
implements CmsPsuPisService {
    private static final Logger log = LoggerFactory.getLogger(CmsPsuPisServiceInternal.class);
    private final PisPaymentDataRepository pisPaymentDataRepository;
    private final PisAuthorisationRepository pisAuthorisationRepository;
    private final CmsPsuPisMapper cmsPsuPisMapper;
    private final PisCommonPaymentService pisCommonPaymentService;
    private final CommonPaymentDataService commonPaymentDataService;
    private final PsuDataMapper psuDataMapper;
    private final PisAuthorisationSpecification pisAuthorisationSpecification;
    private final PisPaymentDataSpecification pisPaymentDataSpecification;
    private final CmsPsuService cmsPsuService;
    private final CmsPsuAuthorisationMapper cmsPsuPisAuthorisationMapper;
    private final CorePaymentsConvertService corePaymentsConvertService;

    @Transactional
    public boolean updatePsuInPayment(@NotNull PsuIdData psuIdData, @NotNull String authorisationId, @NotNull String instanceId) throws AuthorisationIsExpiredException {
        return this.getAuthorisationByExternalId(authorisationId, instanceId).map(auth -> this.updatePsuData((PisAuthorization)auth, psuIdData)).orElseGet(() -> {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update PSU  in Payment failed, because authorisation not found", (Object)authorisationId, (Object)instanceId);
            return false;
        });
    }

    @Transactional
    @NotNull
    public Optional<CmsPaymentResponse> checkRedirectAndGetPayment(@NotNull String redirectId, @NotNull String instanceId) throws RedirectUrlIsExpiredException {
        Optional optionalAuthorisation = this.pisAuthorisationRepository.findOne(this.pisAuthorisationSpecification.byExternalIdAndInstanceId(redirectId, instanceId));
        if (optionalAuthorisation.isPresent()) {
            PisAuthorization authorisation = (PisAuthorization)optionalAuthorisation.get();
            if (!authorisation.isRedirectUrlNotExpired()) {
                log.info("Authorisation ID [{}], Instance ID: [{}]. Check redirect URL and get payment failed, because redirect URL is expired", (Object)authorisation.getId(), (Object)instanceId);
                this.changeAuthorisationStatusToFailed(authorisation);
                throw new RedirectUrlIsExpiredException(authorisation.getTppNokRedirectUri());
            }
            return Optional.of(this.buildCmsPaymentResponse(authorisation));
        }
        log.info("Authorisation ID [{}], Instance ID: [{}]. Check redirect URL and get payment failed, because authorisation not found or has finalised status", (Object)redirectId, (Object)instanceId);
        return Optional.empty();
    }

    @Transactional
    @NotNull
    public Optional<CmsPayment> getPayment(@NotNull PsuIdData psuIdData, @NotNull String paymentId, @NotNull String instanceId) {
        if (this.isPsuDataEquals(paymentId, psuIdData)) {
            List list = this.pisPaymentDataRepository.findAll(this.pisPaymentDataSpecification.byPaymentIdAndInstanceId(paymentId, instanceId));
            if (!list.isEmpty()) {
                return Optional.of(this.cmsPsuPisMapper.mapToCmsPayment(list));
            }
            return this.commonPaymentDataService.getPisCommonPaymentData(paymentId, instanceId).map(this.cmsPsuPisMapper::mapToCmsPayment).map(payment -> (CmsCommonPayment)payment).map(this.corePaymentsConvertService::expandCommonPaymentWithCorePayment);
        }
        log.info("Payment ID: [{}], Instance ID: [{}]. Get payment failed, because given PSU data and PSU data stored in payment are not equal", (Object)paymentId, (Object)instanceId);
        return Optional.empty();
    }

    @Transactional
    @NotNull
    public Optional<CmsPaymentResponse> checkRedirectAndGetPaymentForCancellation(@NotNull String redirectId, @NotNull String instanceId) throws RedirectUrlIsExpiredException {
        Optional<PisAuthorization> optionalAuthorisation = this.pisAuthorisationRepository.findOne(this.pisAuthorisationSpecification.byExternalIdAndInstanceId(redirectId, instanceId)).filter(a -> !a.getScaStatus().isFinalisedStatus());
        if (optionalAuthorisation.isPresent()) {
            PisAuthorization authorisation = optionalAuthorisation.get();
            if (!authorisation.isRedirectUrlNotExpired()) {
                log.info("Authorisation ID [{}], Instance ID: [{}]. Check redirect URL and get payment cancellation failed, because authorisation not found or has finalised status", (Object)redirectId, (Object)instanceId);
                this.changeAuthorisationStatusToFailed(authorisation);
                throw new RedirectUrlIsExpiredException(authorisation.getTppNokRedirectUri());
            }
            return Optional.of(this.buildCmsPaymentResponse(authorisation));
        }
        log.info("Authorisation ID [{}], Instance ID: [{}]. Check redirect URL and get payment cancellation failed, because authorisation not found or has finalised status", (Object)redirectId, (Object)instanceId);
        return Optional.empty();
    }

    @NotNull
    public Optional<CmsPsuAuthorisation> getAuthorisationByAuthorisationId(@NotNull String authorisationId, @NotNull String instanceId) {
        Optional optionalAuthorisation = this.pisAuthorisationRepository.findOne(this.pisAuthorisationSpecification.byExternalIdAndInstanceId(authorisationId, instanceId));
        if (optionalAuthorisation.isPresent()) {
            PisAuthorization authorisation = (PisAuthorization)optionalAuthorisation.get();
            return Optional.of(this.cmsPsuPisAuthorisationMapper.mapToCmsPsuAuthorisationPis(authorisation));
        }
        log.info("Authorisation ID: [{}], Instance ID: [{}]. Get authorisation failed, because authorisation not found", (Object)authorisationId, (Object)instanceId);
        return Optional.empty();
    }

    @Transactional
    public boolean updateAuthorisationStatus(@NotNull PsuIdData psuIdData, @NotNull String paymentId, @NotNull String authorisationId, @NotNull ScaStatus status, @NotNull String instanceId, AuthenticationDataHolder authenticationDataHolder) throws AuthorisationIsExpiredException {
        Optional<PisAuthorization> pisAuthorisation = this.getAuthorisationByExternalId(authorisationId, instanceId);
        if (!pisAuthorisation.isPresent()) {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update authorisation status failed, because authorisation not found.", (Object)authorisationId, (Object)instanceId);
            return false;
        }
        boolean isValid = pisAuthorisation.map(auth -> auth.getPaymentData().getPaymentId()).map(id -> this.validateGivenData((String)id, paymentId, psuIdData)).orElse(false);
        if (!isValid) {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update authorisation status failed, because request data is not valid", (Object)authorisationId, (Object)instanceId);
            return false;
        }
        return this.updateAuthorisationStatusAndSaveAuthorisation(pisAuthorisation.get(), status, authenticationDataHolder);
    }

    @Transactional
    public boolean updatePaymentStatus(@NotNull String paymentId, @NotNull TransactionStatus status, @NotNull String instanceId) {
        Optional<PisCommonPaymentData> paymentDataOptional = this.commonPaymentDataService.getPisCommonPaymentData(paymentId, instanceId);
        return paymentDataOptional.filter(p -> p.getTransactionStatus().isNotFinalisedStatus()).map(pd -> this.commonPaymentDataService.updateStatusInPaymentData((PisCommonPaymentData)pd, status)).orElseGet(() -> {
            log.info("Payment ID [{}], Instance ID: [{}]. Update payment status failed, because PIS common payment data not found", (Object)paymentId, (Object)instanceId);
            return false;
        });
    }

    public Optional<List<CmsPisPsuDataAuthorisation>> getPsuDataAuthorisations(@NotNull String paymentId, @NotNull String instanceId) {
        return this.commonPaymentDataService.getPisCommonPaymentData(paymentId, instanceId).map(PisCommonPaymentData::getAuthorizations).map(this::getPsuDataAuthorisations);
    }

    @NotNull
    private List<CmsPisPsuDataAuthorisation> getPsuDataAuthorisations(List<PisAuthorization> authorisations) {
        return authorisations.stream().filter(auth -> Objects.nonNull(auth.getPsuData())).map(auth -> new CmsPisPsuDataAuthorisation(this.psuDataMapper.mapToPsuIdData(auth.getPsuData()), auth.getExternalId(), auth.getScaStatus(), auth.getAuthorizationType())).collect(Collectors.toList());
    }

    private boolean updatePsuData(PisAuthorization authorisation, PsuIdData psuIdData) {
        PsuData newPsuData = this.psuDataMapper.mapToPsuData(psuIdData);
        if (newPsuData == null || StringUtils.isBlank((CharSequence)newPsuData.getPsuId())) {
            log.info("Authorisation ID [{}]. Update PSU in payment failed in updatePsuData method, because newPsuData or psuId in newPsuData is empty or null", (Object)authorisation.getId());
            return false;
        }
        Optional<PsuData> optionalPsuData = Optional.ofNullable(authorisation.getPsuData());
        if (optionalPsuData.isPresent()) {
            newPsuData.setId(optionalPsuData.get().getId());
        } else {
            List<PsuData> paymentPsuList = authorisation.getPaymentData().getPsuDataList();
            Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(newPsuData, paymentPsuList);
            if (psuDataOptional.isPresent()) {
                newPsuData = psuDataOptional.get();
                if (PaymentAuthorisationType.CANCELLED != authorisation.getAuthorizationType()) {
                    authorisation.getPaymentData().setPsuDataList(this.cmsPsuService.enrichPsuData(newPsuData, paymentPsuList));
                }
            }
            log.info("Authorisation ID [{}]. Update PSU in payment failed in updatePsuData method because authorisation contains no PSU data.", (Object)authorisation.getId());
        }
        authorisation.setPsuData(newPsuData);
        this.pisAuthorisationRepository.save(authorisation);
        return true;
    }

    private boolean validateGivenData(String realPaymentId, String givenPaymentId, PsuIdData psuIdData) {
        return Optional.of(givenPaymentId).filter(p -> this.isPsuDataEquals((String)p, psuIdData)).map(id -> StringUtils.equals((CharSequence)realPaymentId, (CharSequence)id)).orElseGet(() -> {
            log.info("Cannot validate given PSU data, because given payment ID is null");
            return false;
        });
    }

    private boolean updateAuthorisationStatusAndSaveAuthorisation(PisAuthorization pisAuthorisation, ScaStatus status, AuthenticationDataHolder authenticationDataHolder) {
        if (pisAuthorisation.getScaStatus().isFinalisedStatus()) {
            log.info("Authorisation ID [{}], SCA status: [{}]. Update authorisation status failed in updateAuthorisationStatusAndSaveAuthorisation method, because authorisation has finalised status", (Object)pisAuthorisation.getExternalId(), (Object)pisAuthorisation.getScaStatus().getValue());
            return false;
        }
        pisAuthorisation.setScaStatus(status);
        if (authenticationDataHolder != null) {
            this.enrichAuthorisationWithAuthenticationData(pisAuthorisation, authenticationDataHolder);
        }
        return Optional.ofNullable(this.pisAuthorisationRepository.save(pisAuthorisation)).isPresent();
    }

    private boolean isPsuDataEquals(String paymentId, PsuIdData psuIdData) {
        CmsResponse psuDataResponse = this.pisCommonPaymentService.getPsuDataListByPaymentId(paymentId);
        if (psuDataResponse.hasError()) {
            log.info("Payment ID: [{}]. Cannot equal PSU data with payment ID, because PSU data list not found by ID", (Object)paymentId);
            return false;
        }
        return ((List)psuDataResponse.getPayload()).stream().anyMatch(psu -> psu.contentEquals(psuIdData));
    }

    private CmsPaymentResponse buildCmsPaymentResponse(PisAuthorization authorisation) {
        PisCommonPaymentData commonPayment = authorisation.getPaymentData();
        CmsPayment payment = this.cmsPsuPisMapper.mapPaymentDataToCmsPayment(commonPayment);
        return new CmsPaymentResponse(payment, authorisation.getExternalId(), authorisation.getTppOkRedirectUri(), authorisation.getTppNokRedirectUri());
    }

    private void changeAuthorisationStatusToFailed(PisAuthorization authorisation) {
        authorisation.setScaStatus(ScaStatus.FAILED);
        this.pisAuthorisationRepository.save(authorisation);
    }

    private Optional<PisAuthorization> getAuthorisationByExternalId(@NotNull String authorisationId, @NotNull String instanceId) throws AuthorisationIsExpiredException {
        Optional authorization = this.pisAuthorisationRepository.findOne(this.pisAuthorisationSpecification.byExternalIdAndInstanceId(authorisationId, instanceId));
        if (authorization.isPresent() && !((PisAuthorization)authorization.get()).isAuthorisationNotExpired()) {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Authorisation is expired", (Object)authorisationId, (Object)instanceId);
            throw new AuthorisationIsExpiredException(((PisAuthorization)authorization.get()).getTppNokRedirectUri());
        }
        return authorization;
    }

    private void enrichAuthorisationWithAuthenticationData(PisAuthorization authorisation, AuthenticationDataHolder authenticationDataHolder) {
        if (authenticationDataHolder.getAuthenticationData() != null) {
            authorisation.setScaAuthenticationData(authenticationDataHolder.getAuthenticationData());
        }
        if (authenticationDataHolder.getAuthenticationMethodId() != null) {
            authorisation.setChosenScaMethod(authenticationDataHolder.getAuthenticationMethodId());
        }
    }

    @ConstructorProperties(value={"pisPaymentDataRepository", "pisAuthorisationRepository", "cmsPsuPisMapper", "pisCommonPaymentService", "commonPaymentDataService", "psuDataMapper", "pisAuthorisationSpecification", "pisPaymentDataSpecification", "cmsPsuService", "cmsPsuPisAuthorisationMapper", "corePaymentsConvertService"})
    public CmsPsuPisServiceInternal(PisPaymentDataRepository pisPaymentDataRepository, PisAuthorisationRepository pisAuthorisationRepository, CmsPsuPisMapper cmsPsuPisMapper, PisCommonPaymentService pisCommonPaymentService, CommonPaymentDataService commonPaymentDataService, PsuDataMapper psuDataMapper, PisAuthorisationSpecification pisAuthorisationSpecification, PisPaymentDataSpecification pisPaymentDataSpecification, CmsPsuService cmsPsuService, CmsPsuAuthorisationMapper cmsPsuPisAuthorisationMapper, CorePaymentsConvertService corePaymentsConvertService) {
        this.pisPaymentDataRepository = pisPaymentDataRepository;
        this.pisAuthorisationRepository = pisAuthorisationRepository;
        this.cmsPsuPisMapper = cmsPsuPisMapper;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.commonPaymentDataService = commonPaymentDataService;
        this.psuDataMapper = psuDataMapper;
        this.pisAuthorisationSpecification = pisAuthorisationSpecification;
        this.pisPaymentDataSpecification = pisPaymentDataSpecification;
        this.cmsPsuService = cmsPsuService;
        this.cmsPsuPisAuthorisationMapper = cmsPsuPisAuthorisationMapper;
        this.corePaymentsConvertService = corePaymentsConvertService;
    }
}

