/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.CmsAddress;
import de.adorsys.psd2.consent.api.pis.CmsRemittance;
import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.core.payment.model.AccountReference;
import de.adorsys.psd2.core.payment.model.Address;
import de.adorsys.psd2.core.payment.model.Amount;
import de.adorsys.psd2.core.payment.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.core.payment.model.DayOfExecution;
import de.adorsys.psd2.core.payment.model.ExecutionRule;
import de.adorsys.psd2.core.payment.model.FrequencyCode;
import de.adorsys.psd2.core.payment.model.PaymentInitiationBulkElementJson;
import de.adorsys.psd2.core.payment.model.PaymentInitiationJson;
import de.adorsys.psd2.core.payment.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.core.payment.model.RemittanceInformationStructured;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class CmsCorePaymentMapper {
    public PaymentInitiationJson mapToPaymentInitiationJson(PisPayment pisPayment) {
        return Optional.ofNullable(pisPayment).map(ref -> {
            PaymentInitiationJson payment = new PaymentInitiationJson();
            payment.setCreditorAddress(this.mapToAddress(pisPayment.getCreditorAddress()));
            payment.setRemittanceInformationStructured(this.mapToRemittanceInformationStructured(pisPayment.getRemittanceInformationStructured()));
            payment.setCreditorAgent(pisPayment.getCreditorAgent());
            payment.setCreditorName(pisPayment.getCreditorName());
            payment.setCreditorAccount(this.mapToAccountReference(pisPayment.getCreditorAccount()));
            payment.setDebtorAccount(this.mapToAccountReference(pisPayment.getDebtorAccount()));
            payment.setEndToEndIdentification(pisPayment.getEndToEndIdentification());
            Amount amount = new Amount();
            amount.setAmount(pisPayment.getAmount().toPlainString());
            amount.setCurrency(this.mapToCurrency(pisPayment.getCurrency()));
            payment.setInstructedAmount(amount);
            payment.setPurposeCode(PurposeCode.fromValue((String)pisPayment.getPurposeCode()));
            payment.setRemittanceInformationUnstructured(pisPayment.getRemittanceInformationUnstructured());
            payment.setRequestedExecutionDate(pisPayment.getRequestedExecutionDate());
            payment.setUltimateCreditor(pisPayment.getUltimateCreditor());
            payment.setUltimateDebtor(pisPayment.getUltimateDebtor());
            return payment;
        }).orElse(null);
    }

    public PaymentInitiationJson mapToPaymentInitiationJson(List<PisPayment> payments) {
        if (CollectionUtils.isEmpty(payments)) {
            return null;
        }
        return this.mapToPaymentInitiationJson(payments.get(0));
    }

    public BulkPaymentInitiationJson mapToBulkPaymentInitiationJson(List<PisPayment> payments) {
        if (CollectionUtils.isEmpty(payments)) {
            return null;
        }
        PisPayment pisPayment = payments.get(0);
        BulkPaymentInitiationJson payment = new BulkPaymentInitiationJson();
        payment.setPayments(payments.stream().map(this::mapToPaymentInitiationBulkElementJson).collect(Collectors.toList()));
        payment.setBatchBookingPreferred(pisPayment.getBatchBookingPreferred());
        payment.setDebtorAccount(this.mapToAccountReference(pisPayment.getDebtorAccount()));
        payment.setRequestedExecutionDate(pisPayment.getRequestedExecutionDate());
        payment.setRequestedExecutionTime(pisPayment.getRequestedExecutionTime());
        return payment;
    }

    public PeriodicPaymentInitiationJson mapToPeriodicPaymentInitiationJson(List<PisPayment> payments) {
        if (CollectionUtils.isEmpty(payments)) {
            return null;
        }
        PisPayment pisPayment = payments.get(0);
        PeriodicPaymentInitiationJson payment = new PeriodicPaymentInitiationJson();
        payment.setDebtorAccount(this.mapToAccountReference(pisPayment.getDebtorAccount()));
        payment.setCreditorAddress(this.mapToAddress(pisPayment.getCreditorAddress()));
        payment.setRemittanceInformationStructured(this.mapToRemittanceInformationStructured(pisPayment.getRemittanceInformationStructured()));
        payment.setCreditorAgent(pisPayment.getCreditorAgent());
        payment.setCreditorName(pisPayment.getCreditorName());
        payment.setCreditorAccount(this.mapToAccountReference(pisPayment.getCreditorAccount()));
        payment.setEndToEndIdentification(pisPayment.getEndToEndIdentification());
        Amount amount = new Amount();
        amount.setAmount(pisPayment.getAmount().toPlainString());
        amount.setCurrency(this.mapToCurrency(pisPayment.getCurrency()));
        payment.setInstructedAmount(amount);
        payment.setPurposeCode(PurposeCode.fromValue((String)pisPayment.getPurposeCode()));
        payment.setRemittanceInformationUnstructured(pisPayment.getRemittanceInformationUnstructured());
        payment.setUltimateCreditor(pisPayment.getUltimateCreditor());
        payment.setUltimateDebtor(pisPayment.getUltimateDebtor());
        payment.setStartDate(pisPayment.getStartDate());
        payment.setEndDate(pisPayment.getEndDate());
        payment.setExecutionRule(ExecutionRule.fromValue((String)pisPayment.getExecutionRule().getValue()));
        payment.setFrequency(FrequencyCode.valueOf((String)pisPayment.getFrequency()));
        payment.setDayOfExecution(DayOfExecution.fromValue((String)pisPayment.getDayOfExecution().getValue()));
        return payment;
    }

    private PaymentInitiationBulkElementJson mapToPaymentInitiationBulkElementJson(PisPayment pisPayment) {
        PaymentInitiationBulkElementJson payment = new PaymentInitiationBulkElementJson();
        payment.setCreditorAddress(this.mapToAddress(pisPayment.getCreditorAddress()));
        payment.setRemittanceInformationStructured(this.mapToRemittanceInformationStructured(pisPayment.getRemittanceInformationStructured()));
        payment.setCreditorAgent(pisPayment.getCreditorAgent());
        payment.setCreditorName(pisPayment.getCreditorName());
        payment.setCreditorAccount(this.mapToAccountReference(pisPayment.getCreditorAccount()));
        payment.setEndToEndIdentification(pisPayment.getEndToEndIdentification());
        Amount amount = new Amount();
        amount.setAmount(pisPayment.getAmount().toPlainString());
        amount.setCurrency(this.mapToCurrency(pisPayment.getCurrency()));
        payment.setInstructedAmount(amount);
        payment.setPurposeCode(PurposeCode.fromValue((String)pisPayment.getPurposeCode()));
        payment.setRemittanceInformationUnstructured(pisPayment.getRemittanceInformationUnstructured());
        payment.setUltimateCreditor(pisPayment.getUltimateCreditor());
        payment.setUltimateDebtor(pisPayment.getUltimateDebtor());
        return payment;
    }

    private Address mapToAddress(CmsAddress creditorAddress) {
        return Optional.ofNullable(creditorAddress).map(ref -> {
            Address address = new Address();
            address.setBuildingNumber(ref.getBuildingNumber());
            address.setCountry(ref.getCountry());
            address.setPostCode(ref.getPostalCode());
            address.setStreetName(ref.getStreet());
            address.setTownName(ref.getCity());
            return address;
        }).orElse(null);
    }

    private RemittanceInformationStructured mapToRemittanceInformationStructured(CmsRemittance remittanceInformationStructured) {
        return Optional.ofNullable(remittanceInformationStructured).map(ref -> {
            RemittanceInformationStructured informationStructured = new RemittanceInformationStructured();
            informationStructured.setReference(ref.getReference());
            informationStructured.setReferenceIssuer(ref.getReferenceIssuer());
            informationStructured.setReferenceType(ref.getReferenceType());
            return informationStructured;
        }).orElse(null);
    }

    private AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference reference) {
        return Optional.ofNullable(reference).map(ref -> {
            AccountReference accountReference = new AccountReference();
            accountReference.setIban(ref.getIban());
            accountReference.setBban(ref.getBban());
            accountReference.setMaskedPan(ref.getMaskedPan());
            accountReference.setMsisdn(ref.getMsisdn());
            accountReference.setPan(ref.getPan());
            accountReference.setCurrency(this.mapToCurrency(ref.getCurrency()));
            return accountReference;
        }).orElse(null);
    }

    private String mapToCurrency(Currency currency) {
        return Optional.ofNullable(currency).map(Currency::getCurrencyCode).orElse(null);
    }
}

