/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.GetPisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.consent.api.service.PisAuthorisationService;
import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.ScaMethod;
import de.adorsys.psd2.consent.domain.payment.PisAuthorization;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.consent.repository.PisAuthorisationRepository;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.repository.PisPaymentDataRepository;
import de.adorsys.psd2.consent.service.CorePaymentsConvertService;
import de.adorsys.psd2.consent.service.PisCommonPaymentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.mapper.PisCommonPaymentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.ScaMethodMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PisAuthorisationServiceInternal
implements PisAuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(PisAuthorisationServiceInternal.class);
    private final PisCommonPaymentMapper pisCommonPaymentMapper;
    private final PsuDataMapper psuDataMapper;
    private final PisAuthorisationRepository pisAuthorisationRepository;
    private final PisPaymentDataRepository pisPaymentDataRepository;
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final AspspProfileService aspspProfileService;
    private final PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService;
    private final ScaMethodMapper scaMethodMapper;
    private final CmsPsuService cmsPsuService;
    @Value(value="${convert-core-payment-to-common-payment:true}")
    private boolean convertCorePaymentToCommonPayment;
    private final CorePaymentsConvertService corePaymentsConvertService;

    @Transactional
    public CmsResponse<CreatePisAuthorisationResponse> createAuthorization(String paymentId, CreatePisAuthorisationRequest request) {
        Optional<CreatePisAuthorisationResponse> responseOptional = this.readReceivedCommonPaymentDataByPaymentId(paymentId).map(pmt -> {
            this.closePreviousAuthorisationsByPsu(pmt.getAuthorizations(), request.getAuthorizationType(), request.getPsuData());
            return this.saveNewAuthorisation((PisCommonPaymentData)pmt, request);
        }).map(c -> new CreatePisAuthorisationResponse(c.getExternalId(), c.getScaStatus(), c.getPaymentData().getInternalRequestId(), c.getPaymentData().getCancellationInternalRequestId(), request.getPsuData()));
        if (responseOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)responseOptional.get()).build();
        }
        log.info("Payment ID: [{}]. Create common payment authorisation failed, because payment was not found by the ID", (Object)paymentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    @Transactional
    public CmsResponse<CreatePisAuthorisationResponse> createAuthorizationCancellation(String paymentId, CreatePisAuthorisationRequest request) {
        Optional<CreatePisAuthorisationResponse> responseOptional = this.readPisCommonPaymentDataByPaymentId(paymentId).filter(p -> p.getTransactionStatus().isNotFinalisedStatus()).map(pmt -> {
            this.closePreviousAuthorisationsByPsu(pmt.getAuthorizations(), request.getAuthorizationType(), request.getPsuData());
            return this.saveNewAuthorisation((PisCommonPaymentData)pmt, request);
        }).map(c -> new CreatePisAuthorisationResponse(c.getExternalId(), c.getScaStatus(), c.getPaymentData().getInternalRequestId(), c.getPaymentData().getCancellationInternalRequestId(), request.getPsuData()));
        if (responseOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)responseOptional.get()).build();
        }
        log.info("Payment ID: [{}]. Create common payment authorisation cancellation failed, because payment was not found by the ID", (Object)paymentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    @Transactional
    public CmsResponse<UpdatePisCommonPaymentPsuDataResponse> updatePisAuthorisation(String authorisationId, UpdatePisCommonPaymentPsuDataRequest request) {
        Optional<PisAuthorization> pisAuthorisationOptional = this.pisAuthorisationRepository.findByExternalIdAndAuthorizationType(authorisationId, PaymentAuthorisationType.CREATED);
        if (!pisAuthorisationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Update pis authorisation failed, because pis authorisation with PaymentAuthorisationType.CREATED is not found by id", (Object)authorisationId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        PisAuthorization authorisation = pisAuthorisationOptional.get();
        this.closePreviousAuthorisationsByPsu(authorisation, request.getPsuData());
        ScaStatus scaStatus = this.doUpdatePaymentAuthorisation(request, authorisation);
        return CmsResponse.builder().payload((Object)new UpdatePisCommonPaymentPsuDataResponse(scaStatus)).build();
    }

    @Transactional
    public CmsResponse<Boolean> updatePisAuthorisationStatus(String authorisationId, ScaStatus scaStatus) {
        Optional<PisAuthorization> pisAuthorisationOptional = this.pisAuthorisationRepository.findByExternalId(authorisationId);
        if (!pisAuthorisationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Update pis authorisation failed, because pis authorisation with PaymentAuthorisationType.CREATED is not found by id", (Object)authorisationId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        PisAuthorization authorisation = pisAuthorisationOptional.get();
        authorisation.setScaStatus(scaStatus);
        this.pisAuthorisationRepository.save(authorisation);
        return CmsResponse.builder().payload((Object)true).build();
    }

    @Transactional
    public CmsResponse<UpdatePisCommonPaymentPsuDataResponse> updatePisCancellationAuthorisation(String cancellationId, UpdatePisCommonPaymentPsuDataRequest request) {
        Optional<PisAuthorization> pisAuthorisationOptional = this.pisAuthorisationRepository.findByExternalIdAndAuthorizationType(cancellationId, PaymentAuthorisationType.CANCELLED);
        if (!pisAuthorisationOptional.isPresent()) {
            log.info("Cancellation ID: [{}]. Update pis cancellation authorisation failed, because pis authorisation with PaymentAuthorisationType.CANCELLED is not found by id", (Object)cancellationId);
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        PisAuthorization authorisation = pisAuthorisationOptional.get();
        this.closePreviousAuthorisationsByPsu(authorisation, request.getPsuData());
        ScaStatus scaStatus = this.doUpdatePaymentAuthorisation(request, authorisation);
        return CmsResponse.builder().payload((Object)new UpdatePisCommonPaymentPsuDataResponse(scaStatus)).build();
    }

    @Transactional
    public CmsResponse<GetPisAuthorisationResponse> getPisAuthorisationById(String authorisationId) {
        Optional<PisAuthorization> pisAuthorizationOptional = this.pisAuthorisationRepository.findByExternalIdAndAuthorizationType(authorisationId, PaymentAuthorisationType.CREATED);
        pisAuthorizationOptional.ifPresent(this::transferCorePaymentToCommonPayment);
        Optional<GetPisAuthorisationResponse> responseOptional = pisAuthorizationOptional.map(this.pisCommonPaymentMapper::mapToGetPisAuthorizationResponse);
        if (responseOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)responseOptional.get()).build();
        }
        log.info("Authorisation ID: [{}]. Get common payment authorisation by ID failed, because payment was not found by the ID", (Object)authorisationId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    void transferCorePaymentToCommonPayment(PisAuthorization pisAuthorization) {
        PisCommonPaymentData pisCommonPaymentData = pisAuthorization.getPaymentData();
        if (this.convertCorePaymentToCommonPayment && pisCommonPaymentData.getPayment() == null) {
            List<PisPayment> pisPayments = pisCommonPaymentData.getPayments().stream().map(this.pisCommonPaymentMapper::mapToPisPayment).collect(Collectors.toList());
            byte[] paymentData = this.corePaymentsConvertService.buildPaymentData(pisPayments, pisCommonPaymentData.getPaymentType());
            if (paymentData != null) {
                pisCommonPaymentData.setPayment(paymentData);
                this.pisCommonPaymentDataRepository.save(pisCommonPaymentData);
            }
        }
    }

    public CmsResponse<GetPisAuthorisationResponse> getPisCancellationAuthorisationById(String cancellationId) {
        Optional<PisAuthorization> pisAuthorizationOptional = this.pisAuthorisationRepository.findByExternalIdAndAuthorizationType(cancellationId, PaymentAuthorisationType.CANCELLED);
        pisAuthorizationOptional.ifPresent(this::transferCorePaymentToCommonPayment);
        Optional<GetPisAuthorisationResponse> responseOptional = pisAuthorizationOptional.map(this.pisCommonPaymentMapper::mapToGetPisAuthorizationResponse);
        if (responseOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)responseOptional.get()).build();
        }
        log.info("Authorisation ID: [{}]. Get common payment cancellation authorisation by ID failed, because payment was not found by the ID", (Object)cancellationId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    public CmsResponse<List<String>> getAuthorisationsByPaymentId(String paymentId, PaymentAuthorisationType authorisationType) {
        Optional<List> authorisationListOptional = this.readPisCommonPaymentDataByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).map(pmt -> this.readAuthorisationsFromPaymentCommonData((PisCommonPaymentData)pmt, authorisationType));
        if (authorisationListOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)authorisationListOptional.get()).build();
        }
        log.info("PaymentId ID: [{}]. Get payment authorisation list by ID failed, because payment was not found by the ID", (Object)paymentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    @Transactional
    public CmsResponse<ScaStatus> getAuthorisationScaStatus(@NotNull String paymentId, @NotNull String authorisationId, PaymentAuthorisationType authorisationType) {
        Optional<PisAuthorization> authorisationOptional = this.pisAuthorisationRepository.findByExternalIdAndAuthorizationType(authorisationId, authorisationType);
        if (!authorisationOptional.isPresent()) {
            log.info("Authorisation ID: [{}], Authorisation Type: [{}]. Get authorisation SCA status failed, because authorisation is not found", (Object)authorisationId, (Object)authorisationType);
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        PisCommonPaymentData paymentData = authorisationOptional.get().getPaymentData();
        if (this.pisCommonPaymentConfirmationExpirationService.isPaymentDataOnConfirmationExpired(paymentData)) {
            this.pisCommonPaymentConfirmationExpirationService.updatePaymentDataOnConfirmationExpiration(paymentData);
            log.info("Payment ID: [{}]. Get authorisation SCA status failed, because Payment is expired", (Object)paymentId);
            return CmsResponse.builder().payload((Object)ScaStatus.FAILED).build();
        }
        Optional<ScaStatus> statusOptional = authorisationOptional.filter(auth -> paymentId.equals(auth.getPaymentData().getPaymentId())).map(PisAuthorization::getScaStatus);
        if (statusOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)statusOptional.get()).build();
        }
        log.info("PaymentId ID: [{}], Authorisation ID: [{}]. Get payment authorisation SCA status failed", (Object)paymentId, (Object)authorisationId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    public CmsResponse<Boolean> isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        Optional<PisAuthorization> authorisationOptional = this.pisAuthorisationRepository.findByExternalId(authorisationId);
        Optional<Boolean> booleanOptional = authorisationOptional.map(a -> a.getAvailableScaMethods().stream().filter(m -> Objects.equals(m.getAuthenticationMethodId(), authenticationMethodId)).anyMatch(ScaMethod::isDecoupled));
        if (booleanOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)booleanOptional.get()).build();
        }
        log.info("Authorisation ID: [{}]. Get authorisation method decoupled status failed, because pis authorisation is not found", (Object)authorisationId);
        return CmsResponse.builder().payload((Object)false).build();
    }

    @Transactional
    public CmsResponse<Boolean> saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        Optional<PisAuthorization> authorisationOptional = this.pisAuthorisationRepository.findByExternalId(authorisationId);
        if (!authorisationOptional.isPresent()) {
            log.info(" Authorisation ID: [{}]. Save authentication methods failed, because authorisation is not found", (Object)authorisationId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        PisAuthorization authorisation = authorisationOptional.get();
        authorisation.setAvailableScaMethods(this.scaMethodMapper.mapToScaMethods(methods));
        this.pisAuthorisationRepository.save(authorisation);
        return CmsResponse.builder().payload((Object)true).build();
    }

    @Transactional
    public CmsResponse<Boolean> updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        Optional<PisAuthorization> authorisationOptional = this.pisAuthorisationRepository.findByExternalId(authorisationId);
        if (!authorisationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Update SCA approach failed, because pis authorisation is not found", (Object)authorisationId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        PisAuthorization authorisation = authorisationOptional.get();
        authorisation.setScaApproach(scaApproach);
        this.pisAuthorisationRepository.save(authorisation);
        return CmsResponse.builder().payload((Object)true).build();
    }

    public CmsResponse<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId, PaymentAuthorisationType authorisationType) {
        Optional<AuthorisationScaApproachResponse> responseOptional = this.pisAuthorisationRepository.findByExternalIdAndAuthorizationType(authorisationId, authorisationType).map(a -> new AuthorisationScaApproachResponse(a.getScaApproach()));
        if (responseOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)responseOptional.get()).build();
        }
        log.info("Authorisation ID: [{}]. Get payment authorisation SCA approach failed, because pis authorisation is not found", (Object)authorisationId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    private Optional<PisCommonPaymentData> readPisCommonPaymentDataByPaymentId(String paymentId) {
        Optional<PisCommonPaymentData> commonPaymentData = this.pisPaymentDataRepository.findByPaymentId(paymentId).filter(CollectionUtils::isNotEmpty).map(list -> ((PisPaymentData)list.get(0)).getPaymentData());
        if (!commonPaymentData.isPresent()) {
            commonPaymentData = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        }
        return commonPaymentData;
    }

    private PisAuthorization saveNewAuthorisation(PisCommonPaymentData paymentData, CreatePisAuthorisationRequest request) {
        PisAuthorization pisAuthorisation = new PisAuthorization();
        Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(this.psuDataMapper.mapToPsuData(request.getPsuData()), paymentData.getPsuDataList());
        ScaStatus scaStatus = ScaStatus.RECEIVED;
        if (psuDataOptional.isPresent()) {
            PsuData psuData = psuDataOptional.get();
            if (PaymentAuthorisationType.CANCELLED != request.getAuthorizationType()) {
                paymentData.setPsuDataList(this.cmsPsuService.enrichPsuData(psuData, paymentData.getPsuDataList()));
            }
            pisAuthorisation.setPsuData(psuData);
            scaStatus = ScaStatus.PSUIDENTIFIED;
        }
        pisAuthorisation.setExternalId(UUID.randomUUID().toString());
        pisAuthorisation.setScaStatus(scaStatus);
        pisAuthorisation.setAuthorizationType(request.getAuthorizationType());
        pisAuthorisation.setRedirectUrlExpirationTimestamp(this.countRedirectUrlExpirationTimestampForAuthorisationType(request.getAuthorizationType()));
        pisAuthorisation.setAuthorisationExpirationTimestamp(this.countAuthorisationExpirationTimestamp());
        pisAuthorisation.setScaApproach(request.getScaApproach());
        pisAuthorisation.setPaymentData(paymentData);
        TppRedirectUri redirectURIs = request.getTppRedirectURIs();
        AuthorisationTemplateEntity authorisationTemplate = paymentData.getAuthorisationTemplate();
        boolean isCreatedType = PaymentAuthorisationType.CREATED == request.getAuthorizationType();
        String uri = (String)StringUtils.defaultIfBlank((CharSequence)redirectURIs.getUri(), (CharSequence)(isCreatedType ? authorisationTemplate.getRedirectUri() : authorisationTemplate.getCancelRedirectUri()));
        String nokUri = (String)StringUtils.defaultIfBlank((CharSequence)redirectURIs.getNokUri(), (CharSequence)(isCreatedType ? authorisationTemplate.getNokRedirectUri() : authorisationTemplate.getCancelNokRedirectUri()));
        pisAuthorisation.setTppOkRedirectUri(uri);
        pisAuthorisation.setTppNokRedirectUri(nokUri);
        return (PisAuthorization)this.pisAuthorisationRepository.save(pisAuthorisation);
    }

    private OffsetDateTime countRedirectUrlExpirationTimestampForAuthorisationType(PaymentAuthorisationType authorisationType) {
        long redirectUrlExpirationTimeMs = authorisationType == PaymentAuthorisationType.CANCELLED ? this.aspspProfileService.getAspspSettings().getPis().getRedirectLinkToOnlineBanking().getPaymentCancellationRedirectUrlExpirationTimeMs() : this.aspspProfileService.getAspspSettings().getCommon().getRedirectUrlExpirationTimeMs();
        return OffsetDateTime.now().plus(redirectUrlExpirationTimeMs, ChronoUnit.MILLIS);
    }

    private OffsetDateTime countAuthorisationExpirationTimestamp() {
        long authorisationExpirationTimeMs = this.aspspProfileService.getAspspSettings().getCommon().getAuthorisationExpirationTimeMs();
        return OffsetDateTime.now().plus(authorisationExpirationTimeMs, ChronoUnit.MILLIS);
    }

    private void closePreviousAuthorisationsByPsu(PisAuthorization authorisation, PsuIdData psuIdData) {
        PisCommonPaymentData paymentData = authorisation.getPaymentData();
        PaymentAuthorisationType authorizationType = authorisation.getAuthorizationType();
        List<PisAuthorization> previousAuthorisations = paymentData.getAuthorizations().stream().filter(a -> !a.getExternalId().equals(authorisation.getExternalId())).collect(Collectors.toList());
        this.closePreviousAuthorisationsByPsu(previousAuthorisations, authorizationType, psuIdData);
    }

    private void closePreviousAuthorisationsByPsu(List<PisAuthorization> authorisations, PaymentAuthorisationType authorisationType, PsuIdData psuIdData) {
        PsuData psuData = this.psuDataMapper.mapToPsuData(psuIdData);
        if (psuData == null || psuData.isEmpty()) {
            log.info("Close previous authorisations by PSU failed because PSU data is not allowed");
            return;
        }
        List pisAuthorisationList = authorisations.stream().filter(auth -> auth.getAuthorizationType() == authorisationType).filter(auth -> Objects.nonNull(auth.getPsuData()) && auth.getPsuData().contentEquals(psuData)).map(this::makeAuthorisationFailedAndExpired).collect(Collectors.toList());
        this.pisAuthorisationRepository.saveAll(pisAuthorisationList);
    }

    private PisAuthorization makeAuthorisationFailedAndExpired(PisAuthorization auth) {
        auth.setScaStatus(ScaStatus.FAILED);
        auth.setRedirectUrlExpirationTimestamp(OffsetDateTime.now());
        return auth;
    }

    private List<String> readAuthorisationsFromPaymentCommonData(PisCommonPaymentData paymentData, PaymentAuthorisationType authorisationType) {
        return paymentData.getAuthorizations().stream().filter(auth -> auth.getAuthorizationType() == authorisationType).map(PisAuthorization::getExternalId).collect(Collectors.toList());
    }

    private ScaStatus doUpdatePaymentAuthorisation(UpdatePisCommonPaymentPsuDataRequest request, PisAuthorization pisAuthorisation) {
        String chosenMethod;
        if (pisAuthorisation.getScaStatus().isFinalisedStatus()) {
            return pisAuthorisation.getScaStatus();
        }
        PsuData psuDataInAuthorisation = pisAuthorisation.getPsuData();
        PsuData psuDataInRequest = this.psuDataMapper.mapToPsuData(request.getPsuData());
        if (ScaStatus.RECEIVED == pisAuthorisation.getScaStatus()) {
            if (!this.cmsPsuService.isPsuDataRequestCorrect(psuDataInRequest, psuDataInAuthorisation)) {
                log.info("Authorisation ID: [{}], SCA status: [{}]. Update payment authorisation failed, because PSU data request does not match stored PSU data", (Object)pisAuthorisation.getExternalId(), (Object)pisAuthorisation.getScaStatus().getValue());
                return pisAuthorisation.getScaStatus();
            }
            PisCommonPaymentData paymentData = pisAuthorisation.getPaymentData();
            List<PsuData> psuListInPayment = paymentData.getPsuDataList();
            Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(psuDataInRequest, psuListInPayment);
            if (psuDataOptional.isPresent()) {
                PsuData psuData = psuDataOptional.get();
                paymentData.setPsuDataList(this.cmsPsuService.enrichPsuData(psuData, psuListInPayment));
                pisAuthorisation.setPsuData(psuData);
            }
        } else if (pisAuthorisation.getAuthorizationType() == PaymentAuthorisationType.CREATED) {
            boolean isPsuCorrect;
            boolean bl = isPsuCorrect = Objects.nonNull(psuDataInAuthorisation) && Objects.nonNull(psuDataInRequest) && psuDataInAuthorisation.contentEquals(psuDataInRequest);
            if (!isPsuCorrect) {
                log.info("Authorisation ID: [{}], SCA status: [{}]. Update payment authorisation failed, because PSU data request does not match stored PSU data", (Object)pisAuthorisation.getExternalId(), (Object)pisAuthorisation.getScaStatus().getValue());
                return pisAuthorisation.getScaStatus();
            }
        }
        if (ScaStatus.SCAMETHODSELECTED == request.getScaStatus() && StringUtils.isNotBlank((CharSequence)(chosenMethod = request.getAuthenticationMethodId()))) {
            pisAuthorisation.setChosenScaMethod(chosenMethod);
        }
        pisAuthorisation.setScaStatus(request.getScaStatus());
        PisAuthorization saved = (PisAuthorization)this.pisAuthorisationRepository.save(pisAuthorisation);
        return saved.getScaStatus();
    }

    private Optional<PisCommonPaymentData> readReceivedCommonPaymentDataByPaymentId(String paymentId) {
        Optional<PisCommonPaymentData> commonPaymentData = this.pisPaymentDataRepository.findByPaymentIdAndPaymentDataTransactionStatusIn(paymentId, Arrays.asList(TransactionStatus.RCVD, TransactionStatus.PATC)).filter(CollectionUtils::isNotEmpty).map(list -> ((PisPaymentData)list.get(0)).getPaymentData()).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).filter(p -> EnumSet.of(TransactionStatus.RCVD, TransactionStatus.PATC).contains(p.getTransactionStatus()));
        if (!commonPaymentData.isPresent()) {
            commonPaymentData = this.pisCommonPaymentDataRepository.findByPaymentIdAndTransactionStatusIn(paymentId, Arrays.asList(TransactionStatus.RCVD, TransactionStatus.PATC)).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).filter(p -> EnumSet.of(TransactionStatus.RCVD, TransactionStatus.PATC).contains(p.getTransactionStatus()));
        }
        return commonPaymentData;
    }

    @ConstructorProperties(value={"pisCommonPaymentMapper", "psuDataMapper", "pisAuthorisationRepository", "pisPaymentDataRepository", "pisCommonPaymentDataRepository", "aspspProfileService", "pisCommonPaymentConfirmationExpirationService", "scaMethodMapper", "cmsPsuService", "corePaymentsConvertService"})
    public PisAuthorisationServiceInternal(PisCommonPaymentMapper pisCommonPaymentMapper, PsuDataMapper psuDataMapper, PisAuthorisationRepository pisAuthorisationRepository, PisPaymentDataRepository pisPaymentDataRepository, PisCommonPaymentDataRepository pisCommonPaymentDataRepository, AspspProfileService aspspProfileService, PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService, ScaMethodMapper scaMethodMapper, CmsPsuService cmsPsuService, CorePaymentsConvertService corePaymentsConvertService) {
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.psuDataMapper = psuDataMapper;
        this.pisAuthorisationRepository = pisAuthorisationRepository;
        this.pisPaymentDataRepository = pisPaymentDataRepository;
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.aspspProfileService = aspspProfileService;
        this.pisCommonPaymentConfirmationExpirationService = pisCommonPaymentConfirmationExpirationService;
        this.scaMethodMapper = scaMethodMapper;
        this.cmsPsuService = cmsPsuService;
        this.corePaymentsConvertService = corePaymentsConvertService;
    }
}

