/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.api.service.AisConsentAuthorisationService;
import de.adorsys.psd2.consent.api.service.AisConsentAuthorisationServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AisAuthorisationServiceInternalEncrypted
implements AisConsentAuthorisationServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(AisAuthorisationServiceInternalEncrypted.class);
    private final SecurityDataService securityDataService;
    private final AisConsentAuthorisationService aisConsentAuthorisationService;

    @Transactional
    public CmsResponse<CreateAisConsentAuthorizationResponse> createAuthorizationWithResponse(String encryptedConsentId, AisConsentAuthorizationRequest request) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Create authorisation with response failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentAuthorisationService.createAuthorizationWithResponse(decryptIdOptional.get(), request);
    }

    public CmsResponse<AisConsentAuthorizationResponse> getAccountConsentAuthorizationById(String authorisationId, String encryptedConsentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Getaccount consent authorisation failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentAuthorisationService.getAccountConsentAuthorizationById(authorisationId, decryptIdOptional.get());
    }

    @Transactional
    public CmsResponse<Boolean> updateConsentAuthorization(String authorizationId, AisConsentAuthorizationRequest request) {
        return this.aisConsentAuthorisationService.updateConsentAuthorization(authorizationId, request);
    }

    @Transactional
    public CmsResponse<Boolean> updateConsentAuthorisationStatus(String authorisationId, ScaStatus scaStatus) {
        return this.aisConsentAuthorisationService.updateConsentAuthorisationStatus(authorisationId, scaStatus);
    }

    public CmsResponse<List<String>> getAuthorisationsByConsentId(String encryptedConsentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Get the list of authorisation IDs failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentAuthorisationService.getAuthorisationsByConsentId(decryptIdOptional.get());
    }

    @Transactional
    public CmsResponse<ScaStatus> getAuthorisationScaStatus(String encryptedConsentId, String authorisationId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Get authorisation SCA status failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentAuthorisationService.getAuthorisationScaStatus(decryptIdOptional.get(), authorisationId);
    }

    public CmsResponse<Boolean> isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        return this.aisConsentAuthorisationService.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    @Transactional
    public CmsResponse<Boolean> saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        return this.aisConsentAuthorisationService.saveAuthenticationMethods(authorisationId, methods);
    }

    @Transactional
    public CmsResponse<Boolean> updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        return this.aisConsentAuthorisationService.updateScaApproach(authorisationId, scaApproach);
    }

    public CmsResponse<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId) {
        return this.aisConsentAuthorisationService.getAuthorisationScaApproach(authorisationId);
    }

    @ConstructorProperties(value={"securityDataService", "aisConsentAuthorisationService"})
    public AisAuthorisationServiceInternalEncrypted(SecurityDataService securityDataService, AisConsentAuthorisationService aisConsentAuthorisationService) {
        this.securityDataService = securityDataService;
        this.aisConsentAuthorisationService = aisConsentAuthorisationService;
    }
}

