/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.impl;

import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingService;
import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingServiceV1;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ChecksumCalculatingFactory {
    private final Map<String, ChecksumCalculatingService> services = new HashMap<String, ChecksumCalculatingService>();
    private final ChecksumCalculatingServiceV1 v001 = new ChecksumCalculatingServiceV1();

    public ChecksumCalculatingFactory() {
        this.services.put(this.v001.getVersion(), this.v001);
    }

    Optional<ChecksumCalculatingService> getServiceByChecksum(byte[] checksum) {
        if (checksum == null) {
            return Optional.of(this.getDefaultService());
        }
        String checksumStr = new String(checksum);
        String[] elements = checksumStr.split("_%_");
        if (elements.length < 1) {
            return Optional.of(this.getDefaultService());
        }
        String versionSting = elements[0];
        return Optional.ofNullable(this.services.get(versionSting));
    }

    private ChecksumCalculatingService getDefaultService() {
        return this.v001;
    }
}

