/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.impl;

import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.repository.AisConsentJpaRepository;
import de.adorsys.psd2.consent.repository.AisConsentVerifyingRepository;
import de.adorsys.psd2.consent.repository.impl.ChecksumCalculatingFactory;
import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingService;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class AisConsentRepositoryImpl
implements AisConsentVerifyingRepository {
    private static final Logger log = LoggerFactory.getLogger(AisConsentRepositoryImpl.class);
    private final AisConsentJpaRepository aisConsentRepository;
    private final ChecksumCalculatingFactory calculatingFactory;

    @Override
    public AisConsent verifyAndSave(AisConsent entity) {
        return this.verifyAndSaveInternal(entity);
    }

    @Override
    public AisConsent verifyAndUpdate(AisConsent entity) {
        return this.verifyAndUpdateInternal(entity);
    }

    @Override
    public List<AisConsent> verifyAndSaveAll(List<AisConsent> entity) {
        return entity.stream().map(this::verifyAndSaveInternal).collect(Collectors.toList());
    }

    private AisConsent verifyAndSaveInternal(AisConsent entity) {
        Optional<ChecksumCalculatingService> calculatingServiceOptional = this.calculatingFactory.getServiceByChecksum(entity.getChecksum());
        if (calculatingServiceOptional.isPresent()) {
            ChecksumCalculatingService calculatingService = calculatingServiceOptional.get();
            if (!this.isAisConsentChecksumCorrect(entity, calculatingService)) {
                return entity;
            }
            if (this.wasStatusSwitchedToValid(entity)) {
                byte[] newChecksum = calculatingService.calculateChecksumForConsent(entity);
                entity.setChecksum(newChecksum);
            }
        }
        return (AisConsent)this.aisConsentRepository.save(entity);
    }

    private AisConsent verifyAndUpdateInternal(AisConsent entity) {
        Optional<ChecksumCalculatingService> calculatingServiceOptional = this.calculatingFactory.getServiceByChecksum(entity.getChecksum());
        if (calculatingServiceOptional.isPresent()) {
            ChecksumCalculatingService calculatingService = calculatingServiceOptional.get();
            if (!this.isAisConsentChecksumCorrect(entity, calculatingService)) {
                return entity;
            }
            if (entity.getConsentStatus() == ConsentStatus.VALID) {
                byte[] newChecksum = calculatingService.calculateChecksumForConsent(entity);
                entity.setChecksum(newChecksum);
            }
        }
        return (AisConsent)this.aisConsentRepository.save(entity);
    }

    private boolean isAisConsentChecksumCorrect(AisConsent entity, ChecksumCalculatingService calculatingService) {
        byte[] checksumFromDb = entity.getChecksum();
        if (checksumFromDb != null && this.wasStatusValidBefore(entity) && !calculatingService.verifyConsentWithChecksum(entity, checksumFromDb)) {
            log.warn("Checksum verification failed!");
            return false;
        }
        return true;
    }

    private boolean wasStatusSwitchedToValid(AisConsent entity) {
        return entity.getConsentStatus() == ConsentStatus.VALID && EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.PARTIALLY_AUTHORISED).contains(entity.getPreviousConsentStatus());
    }

    private boolean wasStatusValidBefore(AisConsent entity) {
        return entity.getPreviousConsentStatus() == ConsentStatus.VALID;
    }

    @ConstructorProperties(value={"aisConsentRepository", "calculatingFactory"})
    public AisConsentRepositoryImpl(AisConsentJpaRepository aisConsentRepository, ChecksumCalculatingFactory calculatingFactory) {
        this.aisConsentRepository = aisConsentRepository;
        this.calculatingFactory = calculatingFactory;
    }
}

