/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.payment.PisAuthorization;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class CmsAuthorisationMapper {
    private final PsuDataMapper psuDataMapper;

    @NotNull
    List<Authorisation> mapToAuthorisations(@NotNull List<PisAuthorization> pisAuthorisations) {
        return pisAuthorisations.stream().map(this::mapToAuthorisation).collect(Collectors.toList());
    }

    @NotNull
    private Authorisation mapToAuthorisation(@NotNull PisAuthorization pisAuthorisation) {
        PsuIdData psuIdData = this.psuDataMapper.mapToPsuIdData(pisAuthorisation.getPsuData());
        return new Authorisation(pisAuthorisation.getExternalId(), pisAuthorisation.getScaStatus(), psuIdData);
    }

    @ConstructorProperties(value={"psuDataMapper"})
    public CmsAuthorisationMapper(PsuDataMapper psuDataMapper) {
        this.psuDataMapper = psuDataMapper;
    }
}

