/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.service.TppService;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.repository.TppInfoRepository;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TppServiceInternal
implements TppService {
    private static final Logger log = LoggerFactory.getLogger(TppServiceInternal.class);
    private final TppInfoRepository tppInfoRepository;
    @Value(value="${cms.service.instance-id:UNDEFINED}")
    private String serviceInstanceId;

    @Transactional
    public boolean updateTppInfo(@NotNull TppInfo tppInfo) {
        Optional<TppInfoEntity> tppInfoEntityOptional = this.tppInfoRepository.findFirstByAuthorisationNumberAndInstanceId(tppInfo.getAuthorisationNumber(), this.serviceInstanceId);
        if (!tppInfoEntityOptional.isPresent()) {
            return false;
        }
        TppInfoEntity tppInfoEntity = tppInfoEntityOptional.get();
        tppInfoEntity.setTppRoles(tppInfo.getTppRoles());
        this.tppInfoRepository.save(tppInfoEntity);
        return true;
    }

    @ConstructorProperties(value={"tppInfoRepository"})
    public TppServiceInternal(TppInfoRepository tppInfoRepository) {
        this.tppInfoRepository = tppInfoRepository;
    }
}

