/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.piis;

import de.adorsys.psd2.consent.domain.AccountReferenceEntity;
import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.piis.PiisConsentTppAccessType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;

@Entity(name="piis_consent")
@ApiModel(description="Piis consent entity", value="PiisConsentEntity")
public class PiisConsentEntity
extends InstanceDependableEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="piis_consent_generator")
    @SequenceGenerator(name="piis_consent_generator", sequenceName="piis_consent_id_seq", allocationSize=1)
    private Long id;
    @Column(name="external_id", nullable=false)
    @ApiModelProperty(value="An external exposed identification of the created PIIS consent", required=true, example="bf489af6-a2cb-4b75-b71d-d66d58b934d7")
    private String externalId;
    @Column(name="recurring_indicator", nullable=false)
    @ApiModelProperty(value="'true', if the consent is for recurring access to the account data , 'false', if the consent is for single access to the account data", required=true, example="false")
    private boolean recurringIndicator;
    @Column(name="request_date_time", nullable=false)
    @ApiModelProperty(value="Date of the last request for this consent. The content is the local ASPSP date in ISODate Format", required=true, example="2018-10-25T15:30:35.035Z")
    private OffsetDateTime requestDateTime;
    @Column(name="last_action_date")
    @ApiModelProperty(value="Date of the last action for this consent. The content is the local ASPSP date in ISODate Format", example="2018-05-04")
    private LocalDate lastActionDate;
    @Column(name="expire_date")
    @ApiModelProperty(value="Expiration date for the requested consent. The content is the local ASPSP date in ISODate Format", example="2018-05-04")
    private LocalDate expireDate;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="psu_id")
    private PsuData psuData;
    @Column(name="consent_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="The following code values are permitted 'received', 'valid', 'rejected', 'expired', 'revoked by psu', 'terminated by tpp'. These values might be extended by ASPSP by more values.", required=true, example="VALID")
    private ConsentStatus consentStatus;
    @JoinColumn(name="acc_reference_id")
    @ManyToOne(cascade={CascadeType.ALL})
    private AccountReferenceEntity account;
    @Column(name="tpp_access_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the tpp access: SINGLE_TPP or ALL_TPP.", required=true, example="ALL_TPP")
    private PiisConsentTppAccessType tppAccessType;
    @Column(name="creation_timestamp", nullable=false)
    private OffsetDateTime creationTimestamp = OffsetDateTime.now();
    @Column(name="card_number", length=35)
    private String cardNumber;
    @Column(name="card_expiry_date")
    private LocalDate cardExpiryDate;
    @Column(name="card_information", length=140)
    private String cardInformation;
    @Column(name="registration_information", length=140)
    private String registrationInformation;
    @Column(name="status_change_timestamp")
    private OffsetDateTime statusChangeTimestamp;
    @Column(name="tpp_authorisation_number")
    @ApiModelProperty(value="Fully described Tpp attribute", example="PSDDE-FAKENCA-87B2AC")
    private String tppAuthorisationNumber;
    @Transient
    private ConsentStatus previousConsentStatus;

    @PostLoad
    public void piisConsentPostLoad() {
        this.previousConsentStatus = this.consentStatus;
    }

    @PreUpdate
    public void piisConsentPreUpdate() {
        if (this.previousConsentStatus != this.consentStatus) {
            this.statusChangeTimestamp = OffsetDateTime.now();
        }
    }

    @PrePersist
    public void piisConsentPrePersist() {
        if (Objects.isNull(this.statusChangeTimestamp)) {
            this.statusChangeTimestamp = this.creationTimestamp;
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public OffsetDateTime getRequestDateTime() {
        return this.requestDateTime;
    }

    public LocalDate getLastActionDate() {
        return this.lastActionDate;
    }

    public LocalDate getExpireDate() {
        return this.expireDate;
    }

    public PsuData getPsuData() {
        return this.psuData;
    }

    public ConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    public AccountReferenceEntity getAccount() {
        return this.account;
    }

    public PiisConsentTppAccessType getTppAccessType() {
        return this.tppAccessType;
    }

    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public LocalDate getCardExpiryDate() {
        return this.cardExpiryDate;
    }

    public String getCardInformation() {
        return this.cardInformation;
    }

    public String getRegistrationInformation() {
        return this.registrationInformation;
    }

    public OffsetDateTime getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public String getTppAuthorisationNumber() {
        return this.tppAuthorisationNumber;
    }

    public ConsentStatus getPreviousConsentStatus() {
        return this.previousConsentStatus;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setRequestDateTime(OffsetDateTime requestDateTime) {
        this.requestDateTime = requestDateTime;
    }

    public void setLastActionDate(LocalDate lastActionDate) {
        this.lastActionDate = lastActionDate;
    }

    public void setExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public void setPsuData(PsuData psuData) {
        this.psuData = psuData;
    }

    public void setConsentStatus(ConsentStatus consentStatus) {
        this.consentStatus = consentStatus;
    }

    public void setAccount(AccountReferenceEntity account) {
        this.account = account;
    }

    public void setTppAccessType(PiisConsentTppAccessType tppAccessType) {
        this.tppAccessType = tppAccessType;
    }

    public void setCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public void setCardExpiryDate(LocalDate cardExpiryDate) {
        this.cardExpiryDate = cardExpiryDate;
    }

    public void setCardInformation(String cardInformation) {
        this.cardInformation = cardInformation;
    }

    public void setRegistrationInformation(String registrationInformation) {
        this.registrationInformation = registrationInformation;
    }

    public void setStatusChangeTimestamp(OffsetDateTime statusChangeTimestamp) {
        this.statusChangeTimestamp = statusChangeTimestamp;
    }

    public void setTppAuthorisationNumber(String tppAuthorisationNumber) {
        this.tppAuthorisationNumber = tppAuthorisationNumber;
    }

    public void setPreviousConsentStatus(ConsentStatus previousConsentStatus) {
        this.previousConsentStatus = previousConsentStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PiisConsentEntity)) {
            return false;
        }
        PiisConsentEntity other = (PiisConsentEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        OffsetDateTime this$requestDateTime = this.getRequestDateTime();
        OffsetDateTime other$requestDateTime = other.getRequestDateTime();
        if (this$requestDateTime == null ? other$requestDateTime != null : !((Object)this$requestDateTime).equals(other$requestDateTime)) {
            return false;
        }
        LocalDate this$lastActionDate = this.getLastActionDate();
        LocalDate other$lastActionDate = other.getLastActionDate();
        if (this$lastActionDate == null ? other$lastActionDate != null : !((Object)this$lastActionDate).equals(other$lastActionDate)) {
            return false;
        }
        LocalDate this$expireDate = this.getExpireDate();
        LocalDate other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        PsuData this$psuData = this.getPsuData();
        PsuData other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !((Object)this$psuData).equals(other$psuData)) {
            return false;
        }
        ConsentStatus this$consentStatus = this.getConsentStatus();
        ConsentStatus other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        AccountReferenceEntity this$account = this.getAccount();
        AccountReferenceEntity other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        PiisConsentTppAccessType this$tppAccessType = this.getTppAccessType();
        PiisConsentTppAccessType other$tppAccessType = other.getTppAccessType();
        if (this$tppAccessType == null ? other$tppAccessType != null : !this$tppAccessType.equals(other$tppAccessType)) {
            return false;
        }
        OffsetDateTime this$creationTimestamp = this.getCreationTimestamp();
        OffsetDateTime other$creationTimestamp = other.getCreationTimestamp();
        if (this$creationTimestamp == null ? other$creationTimestamp != null : !((Object)this$creationTimestamp).equals(other$creationTimestamp)) {
            return false;
        }
        String this$cardNumber = this.getCardNumber();
        String other$cardNumber = other.getCardNumber();
        if (this$cardNumber == null ? other$cardNumber != null : !this$cardNumber.equals(other$cardNumber)) {
            return false;
        }
        LocalDate this$cardExpiryDate = this.getCardExpiryDate();
        LocalDate other$cardExpiryDate = other.getCardExpiryDate();
        if (this$cardExpiryDate == null ? other$cardExpiryDate != null : !((Object)this$cardExpiryDate).equals(other$cardExpiryDate)) {
            return false;
        }
        String this$cardInformation = this.getCardInformation();
        String other$cardInformation = other.getCardInformation();
        if (this$cardInformation == null ? other$cardInformation != null : !this$cardInformation.equals(other$cardInformation)) {
            return false;
        }
        String this$registrationInformation = this.getRegistrationInformation();
        String other$registrationInformation = other.getRegistrationInformation();
        if (this$registrationInformation == null ? other$registrationInformation != null : !this$registrationInformation.equals(other$registrationInformation)) {
            return false;
        }
        OffsetDateTime this$statusChangeTimestamp = this.getStatusChangeTimestamp();
        OffsetDateTime other$statusChangeTimestamp = other.getStatusChangeTimestamp();
        if (this$statusChangeTimestamp == null ? other$statusChangeTimestamp != null : !((Object)this$statusChangeTimestamp).equals(other$statusChangeTimestamp)) {
            return false;
        }
        String this$tppAuthorisationNumber = this.getTppAuthorisationNumber();
        String other$tppAuthorisationNumber = other.getTppAuthorisationNumber();
        if (this$tppAuthorisationNumber == null ? other$tppAuthorisationNumber != null : !this$tppAuthorisationNumber.equals(other$tppAuthorisationNumber)) {
            return false;
        }
        ConsentStatus this$previousConsentStatus = this.getPreviousConsentStatus();
        ConsentStatus other$previousConsentStatus = other.getPreviousConsentStatus();
        return !(this$previousConsentStatus == null ? other$previousConsentStatus != null : !this$previousConsentStatus.equals(other$previousConsentStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PiisConsentEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        OffsetDateTime $requestDateTime = this.getRequestDateTime();
        result = result * 59 + ($requestDateTime == null ? 43 : ((Object)$requestDateTime).hashCode());
        LocalDate $lastActionDate = this.getLastActionDate();
        result = result * 59 + ($lastActionDate == null ? 43 : ((Object)$lastActionDate).hashCode());
        LocalDate $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        PsuData $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : ((Object)$psuData).hashCode());
        ConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        AccountReferenceEntity $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        PiisConsentTppAccessType $tppAccessType = this.getTppAccessType();
        result = result * 59 + ($tppAccessType == null ? 43 : $tppAccessType.hashCode());
        OffsetDateTime $creationTimestamp = this.getCreationTimestamp();
        result = result * 59 + ($creationTimestamp == null ? 43 : ((Object)$creationTimestamp).hashCode());
        String $cardNumber = this.getCardNumber();
        result = result * 59 + ($cardNumber == null ? 43 : $cardNumber.hashCode());
        LocalDate $cardExpiryDate = this.getCardExpiryDate();
        result = result * 59 + ($cardExpiryDate == null ? 43 : ((Object)$cardExpiryDate).hashCode());
        String $cardInformation = this.getCardInformation();
        result = result * 59 + ($cardInformation == null ? 43 : $cardInformation.hashCode());
        String $registrationInformation = this.getRegistrationInformation();
        result = result * 59 + ($registrationInformation == null ? 43 : $registrationInformation.hashCode());
        OffsetDateTime $statusChangeTimestamp = this.getStatusChangeTimestamp();
        result = result * 59 + ($statusChangeTimestamp == null ? 43 : ((Object)$statusChangeTimestamp).hashCode());
        String $tppAuthorisationNumber = this.getTppAuthorisationNumber();
        result = result * 59 + ($tppAuthorisationNumber == null ? 43 : $tppAuthorisationNumber.hashCode());
        ConsentStatus $previousConsentStatus = this.getPreviousConsentStatus();
        result = result * 59 + ($previousConsentStatus == null ? 43 : $previousConsentStatus.hashCode());
        return result;
    }

    public String toString() {
        return "PiisConsentEntity(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", recurringIndicator=" + this.isRecurringIndicator() + ", requestDateTime=" + this.getRequestDateTime() + ", lastActionDate=" + this.getLastActionDate() + ", expireDate=" + this.getExpireDate() + ", psuData=" + this.getPsuData() + ", consentStatus=" + this.getConsentStatus() + ", account=" + this.getAccount() + ", tppAccessType=" + this.getTppAccessType() + ", creationTimestamp=" + this.getCreationTimestamp() + ", cardNumber=" + this.getCardNumber() + ", cardExpiryDate=" + this.getCardExpiryDate() + ", cardInformation=" + this.getCardInformation() + ", registrationInformation=" + this.getRegistrationInformation() + ", statusChangeTimestamp=" + this.getStatusChangeTimestamp() + ", tppAuthorisationNumber=" + this.getTppAuthorisationNumber() + ", previousConsentStatus=" + this.getPreviousConsentStatus() + ")";
    }
}

