/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.payment;

import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.payment.PisAuthorization;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;

@Entity(name="pis_common_payment")
public class PisCommonPaymentData
extends InstanceDependableEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="pis_common_payment_generator")
    @SequenceGenerator(name="pis_common_payment_generator", sequenceName="pis_common_payment_id_seq", allocationSize=1)
    private Long id;
    @Column(name="payment_id", nullable=false)
    private String paymentId;
    @Column(name="payment_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private PaymentType paymentType;
    @Column(name="payment_product", nullable=false)
    private String paymentProduct;
    @Column(name="transaction_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private TransactionStatus transactionStatus;
    @Lob
    @Column(name="payment")
    private byte[] payment;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="pis_common_payment_psu_data", joinColumns={@JoinColumn(name="pis_common_payment_id")}, inverseJoinColumns={@JoinColumn(name="psu_data_id")})
    private List<PsuData> psuDataList = new ArrayList<PsuData>();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="tpp_info_id", nullable=false)
    private TppInfoEntity tppInfo;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="authorisation_template_id", nullable=false)
    private AuthorisationTemplateEntity authorisationTemplate;
    @OneToMany(mappedBy="paymentData", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PisAuthorization> authorizations = new ArrayList<PisAuthorization>();
    @OneToMany(mappedBy="paymentData", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PisPaymentData> payments = new ArrayList<PisPaymentData>();
    @Column(name="creation_timestamp", nullable=false)
    private OffsetDateTime creationTimestamp = OffsetDateTime.now();
    @Column(name="multilevel_sca_required", nullable=false)
    private boolean multilevelScaRequired;
    @Column(name="aspsp_account_id", length=100)
    private String aspspAccountId;
    @Column(name="status_change_timestamp")
    private OffsetDateTime statusChangeTimestamp;
    @Column(name="int_req_id")
    private String internalRequestId;
    @Column(name="canc_int_req_id")
    private String cancellationInternalRequestId;
    @Transient
    private TransactionStatus previousTransactionStatus;

    @PostLoad
    public void pisCommonPaymentDataPostLoad() {
        this.previousTransactionStatus = this.transactionStatus;
    }

    @PreUpdate
    public void pisCommonPaymentDataPreUpdate() {
        if (this.previousTransactionStatus != this.transactionStatus) {
            this.statusChangeTimestamp = OffsetDateTime.now();
        }
    }

    @PrePersist
    public void pisCommonPaymentDataPrePersist() {
        if (Objects.isNull(this.statusChangeTimestamp)) {
            this.statusChangeTimestamp = this.creationTimestamp;
        }
    }

    public boolean isConfirmationExpired(long expirationPeriodMs) {
        if (this.isNotConfirmed()) {
            return this.creationTimestamp.plus(expirationPeriodMs, ChronoUnit.MILLIS).isBefore(OffsetDateTime.now());
        }
        return false;
    }

    public boolean isNotConfirmed() {
        return this.transactionStatus == TransactionStatus.RCVD;
    }

    public boolean isFinalised() {
        return this.transactionStatus.isFinalisedStatus();
    }

    public Long getId() {
        return this.id;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public String getPaymentProduct() {
        return this.paymentProduct;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public byte[] getPayment() {
        return this.payment;
    }

    public List<PsuData> getPsuDataList() {
        return this.psuDataList;
    }

    public TppInfoEntity getTppInfo() {
        return this.tppInfo;
    }

    public AuthorisationTemplateEntity getAuthorisationTemplate() {
        return this.authorisationTemplate;
    }

    public List<PisAuthorization> getAuthorizations() {
        return this.authorizations;
    }

    public List<PisPaymentData> getPayments() {
        return this.payments;
    }

    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public boolean isMultilevelScaRequired() {
        return this.multilevelScaRequired;
    }

    public String getAspspAccountId() {
        return this.aspspAccountId;
    }

    public OffsetDateTime getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public String getInternalRequestId() {
        return this.internalRequestId;
    }

    public String getCancellationInternalRequestId() {
        return this.cancellationInternalRequestId;
    }

    public TransactionStatus getPreviousTransactionStatus() {
        return this.previousTransactionStatus;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public void setPaymentProduct(String paymentProduct) {
        this.paymentProduct = paymentProduct;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setPayment(byte[] payment) {
        this.payment = payment;
    }

    public void setPsuDataList(List<PsuData> psuDataList) {
        this.psuDataList = psuDataList;
    }

    public void setTppInfo(TppInfoEntity tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setAuthorisationTemplate(AuthorisationTemplateEntity authorisationTemplate) {
        this.authorisationTemplate = authorisationTemplate;
    }

    public void setAuthorizations(List<PisAuthorization> authorizations) {
        this.authorizations = authorizations;
    }

    public void setPayments(List<PisPaymentData> payments) {
        this.payments = payments;
    }

    public void setCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public void setMultilevelScaRequired(boolean multilevelScaRequired) {
        this.multilevelScaRequired = multilevelScaRequired;
    }

    public void setAspspAccountId(String aspspAccountId) {
        this.aspspAccountId = aspspAccountId;
    }

    public void setStatusChangeTimestamp(OffsetDateTime statusChangeTimestamp) {
        this.statusChangeTimestamp = statusChangeTimestamp;
    }

    public void setInternalRequestId(String internalRequestId) {
        this.internalRequestId = internalRequestId;
    }

    public void setCancellationInternalRequestId(String cancellationInternalRequestId) {
        this.cancellationInternalRequestId = cancellationInternalRequestId;
    }

    public void setPreviousTransactionStatus(TransactionStatus previousTransactionStatus) {
        this.previousTransactionStatus = previousTransactionStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisCommonPaymentData)) {
            return false;
        }
        PisCommonPaymentData other = (PisCommonPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        PaymentType this$paymentType = this.getPaymentType();
        PaymentType other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        String this$paymentProduct = this.getPaymentProduct();
        String other$paymentProduct = other.getPaymentProduct();
        if (this$paymentProduct == null ? other$paymentProduct != null : !this$paymentProduct.equals(other$paymentProduct)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        if (!Arrays.equals(this.getPayment(), other.getPayment())) {
            return false;
        }
        List<PsuData> this$psuDataList = this.getPsuDataList();
        List<PsuData> other$psuDataList = other.getPsuDataList();
        if (this$psuDataList == null ? other$psuDataList != null : !((Object)this$psuDataList).equals(other$psuDataList)) {
            return false;
        }
        TppInfoEntity this$tppInfo = this.getTppInfo();
        TppInfoEntity other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !((Object)this$tppInfo).equals(other$tppInfo)) {
            return false;
        }
        AuthorisationTemplateEntity this$authorisationTemplate = this.getAuthorisationTemplate();
        AuthorisationTemplateEntity other$authorisationTemplate = other.getAuthorisationTemplate();
        if (this$authorisationTemplate == null ? other$authorisationTemplate != null : !((Object)this$authorisationTemplate).equals(other$authorisationTemplate)) {
            return false;
        }
        List<PisAuthorization> this$authorizations = this.getAuthorizations();
        List<PisAuthorization> other$authorizations = other.getAuthorizations();
        if (this$authorizations == null ? other$authorizations != null : !((Object)this$authorizations).equals(other$authorizations)) {
            return false;
        }
        List<PisPaymentData> this$payments = this.getPayments();
        List<PisPaymentData> other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        OffsetDateTime this$creationTimestamp = this.getCreationTimestamp();
        OffsetDateTime other$creationTimestamp = other.getCreationTimestamp();
        if (this$creationTimestamp == null ? other$creationTimestamp != null : !((Object)this$creationTimestamp).equals(other$creationTimestamp)) {
            return false;
        }
        if (this.isMultilevelScaRequired() != other.isMultilevelScaRequired()) {
            return false;
        }
        String this$aspspAccountId = this.getAspspAccountId();
        String other$aspspAccountId = other.getAspspAccountId();
        if (this$aspspAccountId == null ? other$aspspAccountId != null : !this$aspspAccountId.equals(other$aspspAccountId)) {
            return false;
        }
        OffsetDateTime this$statusChangeTimestamp = this.getStatusChangeTimestamp();
        OffsetDateTime other$statusChangeTimestamp = other.getStatusChangeTimestamp();
        if (this$statusChangeTimestamp == null ? other$statusChangeTimestamp != null : !((Object)this$statusChangeTimestamp).equals(other$statusChangeTimestamp)) {
            return false;
        }
        String this$internalRequestId = this.getInternalRequestId();
        String other$internalRequestId = other.getInternalRequestId();
        if (this$internalRequestId == null ? other$internalRequestId != null : !this$internalRequestId.equals(other$internalRequestId)) {
            return false;
        }
        String this$cancellationInternalRequestId = this.getCancellationInternalRequestId();
        String other$cancellationInternalRequestId = other.getCancellationInternalRequestId();
        if (this$cancellationInternalRequestId == null ? other$cancellationInternalRequestId != null : !this$cancellationInternalRequestId.equals(other$cancellationInternalRequestId)) {
            return false;
        }
        TransactionStatus this$previousTransactionStatus = this.getPreviousTransactionStatus();
        TransactionStatus other$previousTransactionStatus = other.getPreviousTransactionStatus();
        return !(this$previousTransactionStatus == null ? other$previousTransactionStatus != null : !this$previousTransactionStatus.equals(other$previousTransactionStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisCommonPaymentData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        PaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        String $paymentProduct = this.getPaymentProduct();
        result = result * 59 + ($paymentProduct == null ? 43 : $paymentProduct.hashCode());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayment());
        List<PsuData> $psuDataList = this.getPsuDataList();
        result = result * 59 + ($psuDataList == null ? 43 : ((Object)$psuDataList).hashCode());
        TppInfoEntity $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : ((Object)$tppInfo).hashCode());
        AuthorisationTemplateEntity $authorisationTemplate = this.getAuthorisationTemplate();
        result = result * 59 + ($authorisationTemplate == null ? 43 : ((Object)$authorisationTemplate).hashCode());
        List<PisAuthorization> $authorizations = this.getAuthorizations();
        result = result * 59 + ($authorizations == null ? 43 : ((Object)$authorizations).hashCode());
        List<PisPaymentData> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        OffsetDateTime $creationTimestamp = this.getCreationTimestamp();
        result = result * 59 + ($creationTimestamp == null ? 43 : ((Object)$creationTimestamp).hashCode());
        result = result * 59 + (this.isMultilevelScaRequired() ? 79 : 97);
        String $aspspAccountId = this.getAspspAccountId();
        result = result * 59 + ($aspspAccountId == null ? 43 : $aspspAccountId.hashCode());
        OffsetDateTime $statusChangeTimestamp = this.getStatusChangeTimestamp();
        result = result * 59 + ($statusChangeTimestamp == null ? 43 : ((Object)$statusChangeTimestamp).hashCode());
        String $internalRequestId = this.getInternalRequestId();
        result = result * 59 + ($internalRequestId == null ? 43 : $internalRequestId.hashCode());
        String $cancellationInternalRequestId = this.getCancellationInternalRequestId();
        result = result * 59 + ($cancellationInternalRequestId == null ? 43 : $cancellationInternalRequestId.hashCode());
        TransactionStatus $previousTransactionStatus = this.getPreviousTransactionStatus();
        result = result * 59 + ($previousTransactionStatus == null ? 43 : $previousTransactionStatus.hashCode());
        return result;
    }

    public String toString() {
        return "PisCommonPaymentData(id=" + this.getId() + ", paymentId=" + this.getPaymentId() + ", paymentType=" + this.getPaymentType() + ", paymentProduct=" + this.getPaymentProduct() + ", transactionStatus=" + this.getTransactionStatus() + ", payment=" + Arrays.toString(this.getPayment()) + ", psuDataList=" + this.getPsuDataList() + ", tppInfo=" + this.getTppInfo() + ", authorisationTemplate=" + this.getAuthorisationTemplate() + ", authorizations=" + this.getAuthorizations() + ", payments=" + this.getPayments() + ", creationTimestamp=" + this.getCreationTimestamp() + ", multilevelScaRequired=" + this.isMultilevelScaRequired() + ", aspspAccountId=" + this.getAspspAccountId() + ", statusChangeTimestamp=" + this.getStatusChangeTimestamp() + ", internalRequestId=" + this.getInternalRequestId() + ", cancellationInternalRequestId=" + this.getCancellationInternalRequestId() + ", previousTransactionStatus=" + this.getPreviousTransactionStatus() + ")";
    }
}

