/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.account;

import de.adorsys.psd2.consent.api.AccountInfo;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.domain.account.AccountAccessHolder;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public final class AspspAccountAccessHolder
extends AccountAccessHolder<AspspAccountAccess> {
    public AspspAccountAccessHolder(AisAccountAccessInfo accountAccessInfo) {
        super(accountAccessInfo);
    }

    @Override
    public void doFillAccess(List<AccountInfo> info, TypeAccess typeAccess) {
        if (CollectionUtils.isNotEmpty(info)) {
            info.forEach(a -> this.addAccountAccess(a.getAspspAccountId(), a.getAccountIdentifier(), a.getResourceId(), this.getCurrencyByString(a.getCurrency()), a.getAccountType(), typeAccess));
        }
    }

    private void addAccountAccess(String aspspAccountId, String accountIdentifier, String resourceId, Currency currency, AccountReferenceType accountReferenceType, TypeAccess typeAccess) {
        this.accountAccesses.add(new AspspAccountAccess(accountIdentifier, typeAccess, accountReferenceType, currency, resourceId, aspspAccountId));
        if (EnumSet.of(TypeAccess.BALANCE, TypeAccess.TRANSACTION).contains(typeAccess)) {
            this.accountAccesses.add(new AspspAccountAccess(accountIdentifier, TypeAccess.ACCOUNT, accountReferenceType, currency, resourceId, aspspAccountId));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspspAccountAccessHolder)) {
            return false;
        }
        AspspAccountAccessHolder other = (AspspAccountAccessHolder)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AspspAccountAccessHolder;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "AspspAccountAccessHolder()";
    }
}

