/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.account;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import io.swagger.annotations.ApiModelProperty;
import java.util.Currency;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class AccountAccess {
    @Column(name="account_identifier", length=34, nullable=false)
    @ApiModelProperty(value="Account-Identifier: This data element can be used in the body of the CreateConsentReq Request Message for retrieving account access consent from this payment account", example="DE2310010010123456789", required=true)
    private String accountIdentifier;
    @Column(name="currency", length=3)
    @ApiModelProperty(value="Currency Type", example="EUR")
    private Currency currency;
    @Column(name="type_access", length=30, nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Types of given accesses: account, balance, transaction, payment", example="ACCOUNT")
    private TypeAccess typeAccess;
    @Column(name="account_reference_type", nullable=false, length=30)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the account: IBAN, BBAN, IBAN, BBAN, PAN, MASKED_PAN, MSISDN", required=true, example="IBAN")
    private AccountReferenceType accountReferenceType;

    public AccountAccess(String accountIdentifier, TypeAccess typeAccess, AccountReferenceType accountReferenceType, Currency currency) {
        this.accountIdentifier = accountIdentifier;
        this.typeAccess = typeAccess;
        this.accountReferenceType = accountReferenceType;
        this.currency = currency;
    }

    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public TypeAccess getTypeAccess() {
        return this.typeAccess;
    }

    public AccountReferenceType getAccountReferenceType() {
        return this.accountReferenceType;
    }

    public void setAccountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setTypeAccess(TypeAccess typeAccess) {
        this.typeAccess = typeAccess;
    }

    public void setAccountReferenceType(AccountReferenceType accountReferenceType) {
        this.accountReferenceType = accountReferenceType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAccess)) {
            return false;
        }
        AccountAccess other = (AccountAccess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accountIdentifier = this.getAccountIdentifier();
        String other$accountIdentifier = other.getAccountIdentifier();
        if (this$accountIdentifier == null ? other$accountIdentifier != null : !this$accountIdentifier.equals(other$accountIdentifier)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        TypeAccess this$typeAccess = this.getTypeAccess();
        TypeAccess other$typeAccess = other.getTypeAccess();
        if (this$typeAccess == null ? other$typeAccess != null : !this$typeAccess.equals(other$typeAccess)) {
            return false;
        }
        AccountReferenceType this$accountReferenceType = this.getAccountReferenceType();
        AccountReferenceType other$accountReferenceType = other.getAccountReferenceType();
        return !(this$accountReferenceType == null ? other$accountReferenceType != null : !this$accountReferenceType.equals(other$accountReferenceType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountAccess;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accountIdentifier = this.getAccountIdentifier();
        result = result * 59 + ($accountIdentifier == null ? 43 : $accountIdentifier.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        TypeAccess $typeAccess = this.getTypeAccess();
        result = result * 59 + ($typeAccess == null ? 43 : $typeAccess.hashCode());
        AccountReferenceType $accountReferenceType = this.getAccountReferenceType();
        result = result * 59 + ($accountReferenceType == null ? 43 : $accountReferenceType.hashCode());
        return result;
    }

    public String toString() {
        return "AccountAccess(accountIdentifier=" + this.getAccountIdentifier() + ", currency=" + this.getCurrency() + ", typeAccess=" + this.getTypeAccess() + ", accountReferenceType=" + this.getAccountReferenceType() + ")";
    }

    public AccountAccess() {
    }
}

