/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security.provider.aes;

import de.adorsys.psd2.consent.service.security.DecryptedData;
import de.adorsys.psd2.consent.service.security.EncryptedData;
import de.adorsys.psd2.consent.service.security.provider.CryptoProvider;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesEcbCryptoProviderImpl
implements CryptoProvider {
    private static final Logger log = LoggerFactory.getLogger(AesEcbCryptoProviderImpl.class);
    private final String cryptoProviderId;
    private final String algorithm;
    private final int keyLength;
    private final int hashIterations;
    private final String skfAlgorithm;

    public AesEcbCryptoProviderImpl(String cryptoProviderId, String algorithm, int keyLength, int hashIterations, String skfAlgorithm) {
        this.cryptoProviderId = cryptoProviderId;
        this.algorithm = algorithm;
        this.keyLength = keyLength;
        this.hashIterations = hashIterations;
        this.skfAlgorithm = skfAlgorithm;
    }

    @Override
    public Optional<EncryptedData> encryptData(byte[] data, String password) {
        try {
            SecretKey secretKey = this.getSecretKey(password);
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(1, secretKey);
            byte[] encryptedData = cipher.doFinal(data);
            return Optional.of(new EncryptedData(encryptedData));
        }
        catch (GeneralSecurityException e) {
            log.info("Error encryption data: {}", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<DecryptedData> decryptData(byte[] data, String password) {
        try {
            SecretKey secretKey = this.getSecretKey(password);
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(2, secretKey);
            byte[] decryptedData = cipher.doFinal(data);
            return Optional.of(new DecryptedData(decryptedData));
        }
        catch (BadPaddingException e) {
            log.info("Error decryption data. Wrong password");
        }
        catch (GeneralSecurityException e) {
            log.info("Error decryption data: {}", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public String getCryptoProviderId() {
        return this.cryptoProviderId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey getSecretKey(String password) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] salt = new byte[16];
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, this.hashIterations, this.keyLength);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.skfAlgorithm);
            SecretKey secretKey = factory.generateSecret(keySpec);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
            return secretKeySpec;
        }
        finally {
            keySpec.clearPassword();
        }
    }
}

