/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu;

import de.adorsys.psd2.consent.domain.piis.PiisConsentEntity;
import de.adorsys.psd2.consent.psu.api.CmsPsuPiisService;
import de.adorsys.psd2.consent.repository.PiisConsentRepository;
import de.adorsys.psd2.consent.repository.specification.PiisConsentEntitySpecification;
import de.adorsys.psd2.consent.service.mapper.PiisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsPsuPiisServiceInternal
implements CmsPsuPiisService {
    private static final Logger log = LoggerFactory.getLogger(CmsPsuPiisServiceInternal.class);
    private final PiisConsentRepository piisConsentRepository;
    private final PiisConsentMapper piisConsentMapper;
    private final PsuDataMapper psuDataMapper;
    private final PiisConsentEntitySpecification piisConsentEntitySpecification;

    @NotNull
    public Optional<PiisConsent> getConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        return this.piisConsentRepository.findOne(this.piisConsentEntitySpecification.byConsentIdAndInstanceId(consentId, instanceId)).filter(con -> this.isPsuIdDataContentEquals((PiisConsentEntity)con, psuIdData)).map(this.piisConsentMapper::mapToPiisConsent);
    }

    @NotNull
    public List<PiisConsent> getConsentsForPsu(@NotNull PsuIdData psuIdData, @NotNull String instanceId) {
        return this.piisConsentRepository.findAll(this.piisConsentEntitySpecification.byPsuDataAndInstanceId(psuIdData, instanceId)).stream().filter(con -> this.isPsuIdDataContentEquals((PiisConsentEntity)con, psuIdData)).map(this.piisConsentMapper::mapToPiisConsent).collect(Collectors.toList());
    }

    @Transactional
    public boolean revokeConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        Optional<PiisConsentEntity> piisConsentEntity = this.piisConsentRepository.findOne(this.piisConsentEntitySpecification.byConsentIdAndInstanceId(consentId, instanceId)).filter(con -> this.isPsuIdDataContentEquals((PiisConsentEntity)con, psuIdData) && !con.getConsentStatus().isFinalisedStatus());
        if (piisConsentEntity.isPresent()) {
            this.revokeConsent(piisConsentEntity.get());
            return true;
        }
        log.info("Consent ID [{}], Instance ID: [{}]. Revoke consent failed, because given psuData is not equals stored psuData, or consent status is finalised, or consent not found", (Object)consentId, (Object)instanceId);
        return false;
    }

    private boolean isPsuIdDataContentEquals(PiisConsentEntity piisConsentEntity, PsuIdData psuIdData) {
        PsuIdData psuIdDataMapped = this.psuDataMapper.mapToPsuIdData(piisConsentEntity.getPsuData());
        Optional<PsuIdData> optionalPsuIdData = Optional.ofNullable(psuIdDataMapped);
        if (optionalPsuIdData.isPresent()) {
            return optionalPsuIdData.get().contentEquals(psuIdData);
        }
        log.info("PIIS Consent ID [{}]. isPsuIdDataContentEquals failed, because psuIdData is not present", (Object)piisConsentEntity.getExternalId());
        return false;
    }

    private void revokeConsent(PiisConsentEntity consent) {
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(ConsentStatus.REVOKED_BY_PSU);
        this.piisConsentRepository.save(consent);
    }

    @ConstructorProperties(value={"piisConsentRepository", "piisConsentMapper", "psuDataMapper", "piisConsentEntitySpecification"})
    public CmsPsuPiisServiceInternal(PiisConsentRepository piisConsentRepository, PiisConsentMapper piisConsentMapper, PsuDataMapper psuDataMapper, PiisConsentEntitySpecification piisConsentEntitySpecification) {
        this.piisConsentRepository = piisConsentRepository;
        this.piisConsentMapper = piisConsentMapper;
        this.psuDataMapper = psuDataMapper;
        this.piisConsentEntitySpecification = piisConsentEntitySpecification;
    }
}

