/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.authorisation;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.repository.AisConsentJpaRepository;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.authorisation.CmsAuthorisationService;
import de.adorsys.psd2.consent.service.mapper.AuthorisationMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AisAuthService
extends CmsAuthorisationService<AisConsent> {
    private static final Logger log = LoggerFactory.getLogger(AisAuthService.class);
    private AisConsentJpaRepository aisConsentJpaRepository;

    @Autowired
    public AisAuthService(CmsPsuService cmsPsuService, PsuDataMapper psuDataMapper, AspspProfileService aspspProfileService, AuthorisationRepository authorisationRepository, AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService, AisConsentJpaRepository aisConsentJpaRepository, AuthorisationMapper authorisationMapper) {
        super(cmsPsuService, psuDataMapper, aspspProfileService, authorisationMapper, authorisationRepository, aisConsentConfirmationExpirationService);
        this.aisConsentJpaRepository = aisConsentJpaRepository;
    }

    @Override
    public Optional<Authorisable> getNotFinalisedAuthorisationParent(String parentId) {
        return this.aisConsentJpaRepository.findByExternalId(parentId).filter(con -> !con.getConsentStatus().isFinalisedStatus()).map(con -> con);
    }

    @Override
    public Optional<Authorisable> getAuthorisationParent(String parentId) {
        return this.aisConsentJpaRepository.findByExternalId(parentId).map(con -> con);
    }

    @Override
    protected void updateAuthorisable(Object authorisable) {
        this.aisConsentJpaRepository.save((AisConsent)authorisable);
    }

    @Override
    AuthorisationType getAuthorisationType() {
        return AuthorisationType.AIS;
    }

    @Override
    AisConsent castToParent(Authorisable authorisable) {
        return (AisConsent)authorisable;
    }
}

