/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.aspsp.api.piis.CmsAspspPiisService;
import de.adorsys.psd2.consent.aspsp.api.piis.CreatePiisConsentRequest;
import de.adorsys.psd2.consent.domain.piis.PiisConsentEntity;
import de.adorsys.psd2.consent.repository.PiisConsentRepository;
import de.adorsys.psd2.consent.repository.specification.PiisConsentEntitySpecification;
import de.adorsys.psd2.consent.service.mapper.PiisConsentMapper;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsAspspPiisServiceInternal
implements CmsAspspPiisService {
    private static final Logger log = LoggerFactory.getLogger(CmsAspspPiisServiceInternal.class);
    private final PiisConsentRepository piisConsentRepository;
    private final PiisConsentEntitySpecification piisConsentEntitySpecification;
    private final PiisConsentMapper piisConsentMapper;

    @Transactional
    public Optional<String> createConsent(@NotNull PsuIdData psuIdData, @NotNull CreatePiisConsentRequest request) {
        if (this.isInvalidConsentCreationRequest(psuIdData, request)) {
            log.info("Consent cannot be created, because request contains no allowed tppInfo or empty psuIdData or empty accounts or validUntil or cardExpiryDate in the past");
            return Optional.empty();
        }
        this.closePreviousPiisConsents(psuIdData, request);
        PiisConsentEntity consent = this.piisConsentMapper.mapToPiisConsentEntity(psuIdData, request);
        PiisConsentEntity savedConsent = (PiisConsentEntity)this.piisConsentRepository.save(consent);
        if (savedConsent.getId() != null) {
            return Optional.ofNullable(savedConsent.getExternalId());
        }
        log.info("External Consent ID: [{}]. PIIS consent cannot be created, because when saving to DB got null ID", (Object)consent.getExternalId());
        return Optional.empty();
    }

    @NotNull
    public List<PiisConsent> getConsentsForPsu(@NotNull PsuIdData psuIdData, @NotNull String instanceId) {
        if (psuIdData.isEmpty()) {
            return Collections.emptyList();
        }
        return this.piisConsentRepository.findAll(this.piisConsentEntitySpecification.byPsuDataAndInstanceId(psuIdData, instanceId)).stream().map(this.piisConsentMapper::mapToPiisConsent).collect(Collectors.toList());
    }

    @Transactional
    public boolean terminateConsent(@NotNull String consentId, @NotNull String instanceId) {
        Optional entityOptional = this.piisConsentRepository.findOne(this.piisConsentEntitySpecification.byConsentIdAndInstanceId(consentId, instanceId));
        if (!entityOptional.isPresent()) {
            log.info("Consent ID: [{}], Instance ID: [{}]. PIIS consent cannot be terminated, because it was not found by consentId and instanceId", (Object)consentId, (Object)instanceId);
            return false;
        }
        PiisConsentEntity entity = (PiisConsentEntity)entityOptional.get();
        this.changeStatusAndLastActionDate(entity, ConsentStatus.TERMINATED_BY_ASPSP);
        this.piisConsentRepository.save(entity);
        return true;
    }

    private void closePreviousPiisConsents(PsuIdData psuIdData, CreatePiisConsentRequest request) {
        AccountReference accountReference = request.getAccount();
        Specification<PiisConsentEntity> specification = this.piisConsentEntitySpecification.byPsuIdDataAndAuthorisationNumberAndAccountReference(psuIdData, request.getTppAuthorisationNumber(), accountReference);
        List piisConsentEntities = this.piisConsentRepository.findAll(specification);
        List<PiisConsentEntity> consentsToRevoke = piisConsentEntities.stream().filter(c -> !c.getConsentStatus().isFinalisedStatus()).collect(Collectors.toList());
        consentsToRevoke.forEach(entity -> this.changeStatusAndLastActionDate((PiisConsentEntity)entity, ConsentStatus.REVOKED_BY_PSU));
        this.piisConsentRepository.saveAll(consentsToRevoke);
    }

    private void changeStatusAndLastActionDate(PiisConsentEntity piisConsentEntity, ConsentStatus consentStatus) {
        piisConsentEntity.setLastActionDate(LocalDate.now());
        piisConsentEntity.setConsentStatus(consentStatus);
    }

    private boolean isInvalidConsentCreationRequest(@NotNull PsuIdData psuIdData, CreatePiisConsentRequest request) {
        return StringUtils.isBlank((CharSequence)request.getTppAuthorisationNumber()) || psuIdData.isEmpty() || request.getAccount() == null || request.getValidUntil() == null || request.getValidUntil().isBefore(LocalDate.now()) || request.getCardExpiryDate() != null && request.getCardExpiryDate().isBefore(LocalDate.now());
    }

    @ConstructorProperties(value={"piisConsentRepository", "piisConsentEntitySpecification", "piisConsentMapper"})
    public CmsAspspPiisServiceInternal(PiisConsentRepository piisConsentRepository, PiisConsentEntitySpecification piisConsentEntitySpecification, PiisConsentMapper piisConsentMapper) {
        this.piisConsentRepository = piisConsentRepository;
        this.piisConsentEntitySpecification = piisConsentEntitySpecification;
        this.piisConsentMapper = piisConsentMapper;
    }
}

